package com.ejie.ab78.service.listados;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.dao.listados.BusquedasDao;
import com.ejie.ab78.dao.listados.ParametrosDao;
import com.ejie.ab78.model.listados.Busquedas;
import com.ejie.ab78.model.listados.Parametros;
import com.ejie.x38.dto.TableRequestDto;

/**
 * BusquedasServiceImpl
 * 
 * 
 */

@Service(value = "busquedasService")
public class BusquedasServiceImpl implements BusquedasService {

	@Autowired
	private BusquedasDao busquedasDao;
	@Autowired
	private ParametrosDao parametrosDao;

	/**
	 * Finds a single row in the Busquedas table.
	 *
	 * @param busquedas
	 *            Busquedas
	 * @return Busquedas
	 */
	public Busquedas find(Busquedas busquedas) {
		return (Busquedas) this.busquedasDao.find(busquedas);
	}

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param filterBusquedas
	 *            Busquedas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Busquedas>
	 */
	public List<Busquedas> findAllLike(Busquedas filterBusquedas, TableRequestDto TableRequestDto, Boolean startsWith) {
		List<Busquedas> listaBusquedas = this.busquedasDao.findAllLike(filterBusquedas, null, false);
		List<Busquedas> resultado = new ArrayList<Busquedas>();
		for (Busquedas busquedas : listaBusquedas) {
			Parametros filterParametros = new Parametros();
			filterParametros.setIdBusqueda(busquedas.getIdBusqueda());
			List<Parametros> listaParametros = this.parametrosDao.findAllLike(filterParametros, null, false);
			busquedas.setParametros(listaParametros);
			resultado.add(busquedas);
		}
		return resultado;
	}
}
