package com.ejie.ab78.service.expedientes;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab78.adaptadores.ab61WebServiceAdaptadorService;
import com.ejie.ab78.clientesWS.ab61WebService.EmisorInicioOficio;
import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.dao.expedientes.ExpedientesDao;
import com.ejie.ab78.model.Inspeccion;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.denuncias.IrregularidadDenuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.ab78.model.util.ErrorResultAjaxOperation;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.model.util.SuccessResultAjaxOperation;
import com.ejie.ab78.service.denuncias.DenunciasService;
import com.ejie.ab78.service.denuncias.IrregularidadesDenunciaService;
import com.ejie.ab78.service.procedimientos.ProcedimientosService;
import com.ejie.ab78.service.procedimientos.ProcedureActions;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

@SessionAttributes("usuario")
@Service(value = "expedientesService")
public class ExpedientesServiceImpl implements ExpedientesService {

	private final static Logger logger = Logger.getLogger(ExpedientesServiceImpl.class.getName());

	@Autowired
	private ExpedientesDao expedientesDao;

	@Autowired
	private ProcedimientosService procedimientosService;

	@Autowired
	private ab61WebServiceAdaptadorService ab61WebServiceAdaptadorService;

	@Autowired
	private ab61WebServiceAdaptadorService ab61WebServiceService;

	@Autowired
	private DenunciasService denunciasService;

	@Autowired
	private IrregularidadesDenunciaService irregularidadesDenunciaService;

	/**
	 * Inserts a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Expedientes add(Expedientes expedientes) {
		return this.expedientesDao.add(expedientes);
	}

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Expedientes update(Expedientes expedientes) {
		return this.expedientesDao.update(expedientes);
	}

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Expedientes updateFolder(Expedientes expedientes) {
		return this.expedientesDao.updateFolder(expedientes);
	}

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Expedientes updateExpedienteFolder(Expedientes expedientes) {
		return this.expedientesDao.updateExpedienteFolder(expedientes);
	}

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	public Expedientes find(Expedientes expedientes) {
		return this.expedientesDao.find(expedientes);
	}

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	public Expedientes findProcedureIdPorExpediente(Expedientes expedientes) {
		return this.expedientesDao.findProcedureIdPorExpediente(expedientes);
	}

	/**
	 * Finds a single row in the Expedientes table por Folder ID.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	public Expedientes findByFolderId(Expedientes expedientes) {
		return this.expedientesDao.findByFolderId(expedientes);
	}

	/**
	 * Finds a single row in the Expedientes table por Folder ID.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	public Expedientes findByFolderNumber(Expedientes expedientes) {
		return this.expedientesDao.findByFolderNumber(expedientes);
	}

	/**
	 * Deletes a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Expedientes expedientes) {
		this.expedientesDao.remove(expedientes);
	}

	/**
	 * Finds a list of rows in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Expedientes>
	 */
	@Override
	public List<Expedientes> findAll(Expedientes expedientes, TableRequestDto TableRequestDto) {
		return this.expedientesDao.findAll(expedientes, TableRequestDto);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Expedientes filterExpedientes, TableRequestDto TableRequestDto, Boolean startsWith) {
		this.expedientesDao.removeMultiple(filterExpedientes, TableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDtor
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Expedientes>
	 */
	@Override
	public TableResponseDto<Expedientes> filterTer(Expedientes filterExpedientes, TableRequestDto TableRequestDto,
			Boolean startsWith) {

		List<Expedientes> listaExpedientes = this.expedientesDao.findAllLikeTer(filterExpedientes, TableRequestDto,
				false);
		Long recordNum = this.expedientesDao
				.findAllLikeCountTer(filterExpedientes != null ? filterExpedientes : new Expedientes(), false);

		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Expedientes>> reorderSelection = this.expedientesDao.reorderSelection(filterExpedientes,
					TableRequestDto, startsWith);
			return new TableResponseDto<Expedientes>(TableRequestDto, recordNum, listaExpedientes, reorderSelection);
		}

		return new TableResponseDto<Expedientes>(TableRequestDto, recordNum, listaExpedientes);
	}

	/**
	 * Filter method in the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDtor
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Expedientes>
	 */
	@Override
	public TableResponseDto<Expedientes> filter(Expedientes filterExpedientes, TableRequestDto TableRequestDto,
			Boolean startsWith) {

		List<Expedientes> listaExpedientes = this.expedientesDao.findAllLike(filterExpedientes, TableRequestDto, false);
		Long recordNum = this.expedientesDao
				.findAllLikeCount(filterExpedientes != null ? filterExpedientes : new Expedientes(), false);

		if (TableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Expedientes>> reorderSelection = this.expedientesDao.reorderSelection(filterExpedientes,
					TableRequestDto, startsWith);
			return new TableResponseDto<Expedientes>(TableRequestDto, recordNum, listaExpedientes, reorderSelection);
		}

		return new TableResponseDto<Expedientes>(TableRequestDto, recordNum, listaExpedientes);
	}

	/**
	 * Finds rows in the ActSubvencionable table using like.
	 *
	 * @param Expedientes
	 *            expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<ActSubvencionable>
	 */
	@Override
	public List<Expedientes> findAllLikeTer(Expedientes expedientes, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		return this.expedientesDao.findAllLikeTer(expedientes, TableRequestDto, startsWith);
	}

	/**
	 * M�todo para obtener el Expediente mediante el FOLDER_NUMBER.
	 *
	 * @param String
	 *            folderNumber
	 * 
	 * @return List<Expedientes> Expedientes
	 */

	@Override
	public List<Expedientes> findExpediente(String folderNumber) {

		return expedientesDao.findLupaExpediente(folderNumber);

	}

	/**
	 * Searches rows in the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param searchExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Expedientes>>
	 */
	@Override
	public List<TableRowDto<Expedientes>> search(Expedientes filterExpedientes, Expedientes searchExpedientes,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.expedientesDao.search(filterExpedientes, searchExpedientes, TableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	@Override
	public Object reorderSelection(Expedientes filterExpedientes, TableRequestDto TableRequestDto, Boolean startsWith) {
		return this.expedientesDao.reorderSelection(filterExpedientes, TableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Expedientes>>
	 */
	@Override
	public TableResponseDto<JerarquiaDto<Expedientes>> jerarquia(Expedientes filterExpedientes,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Expedientes>> listaExpedientes = this.expedientesDao.findAllLikeJerarquia(filterExpedientes,
				TableRequestDto);
		Long recordNum = this.expedientesDao.findAllLikeCountJerarquia(filterExpedientes, TableRequestDto);
		return new TableResponseDto<JerarquiaDto<Expedientes>>(TableRequestDto, recordNum, listaExpedientes);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Expedientes
	 * table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Expedientes>>
	 */
	@Override
	public TableResponseDto<JerarquiaDto<Expedientes>> jerarquiaChildren(Expedientes filterExpedientes,
			TableRequestDto TableRequestDto) {
		TableResponseDto<JerarquiaDto<Expedientes>> TableResponseDto = new TableResponseDto<JerarquiaDto<Expedientes>>();
		TableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.expedientesDao.findAllChild(filterExpedientes, TableRequestDto));
		return TableResponseDto;
	}

	/**
	 * Busca los expedientes que estan abiertos.
	 * 
	 * @param idExpediente
	 */
	@Override
	public List<Expedientes> findExpedientesPendientesByExpediente(Integer idExpediente) {
		return this.expedientesDao.findExpedientesPendientesByExpediente(idExpediente);
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public ResultAjaxOperation save(Denuncia form, ProcedureActions procedureActions, HttpServletRequest request,
			Boolean executeProccess) {

		Expedientes expedientes = form.getExpediente();

		if (expedientes.getIdExpediente() != null && form.getIdProvinciaTthh() != null) {

			Expedientes expediente = new Expedientes(form.getExpediente().getIdExpediente());
			expediente.setIdTerritorioHistorico(Long.valueOf(form.getIdProvinciaTthh()));
			this.updateTerritorioHistorico(expediente);
		}

		if (Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(expedientes.getProcedimientos().getTipoDenuncia())) {
			this.registerChecksDenuncia(form);
		}

		Map<String, String> data = new HashMap<String, String>();
		if (executeProccess && procedureActions.isEnableExecuteAction(expedientes)) {
			data = procedureActions.executeAction(expedientes, form);
			if (data.containsKey(Constantes.KEY_AJAX_ERROR)) {
				return new ErrorResultAjaxOperation(data.get(Constantes.KEY_AJAX_ERROR));
			}
		}

		SuccessResultAjaxOperation success = new SuccessResultAjaxOperation(Constantes.OK_GENERICO_GUARDADO);
		if (data.containsKey(Constantes.KEY_AJAX_CALLBACK)) {
			success.setCallback(data.get(Constantes.KEY_AJAX_CALLBACK));
			data.remove(Constantes.KEY_AJAX_CALLBACK);
		}
		if (data.containsKey(Constantes.KEY_AJAX_MESSAGE)) {
			success.setMessage(data.get(Constantes.KEY_AJAX_MESSAGE));
			data.remove(Constantes.KEY_AJAX_MESSAGE);
		}

		success.setData(data);
		return success;
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void updateExpedienteTitle(Denuncia denuncia, Map<String, String> data, ProcedureActions procedureActions) {
		Expedientes expedientes = denuncia.getExpediente();
		String titleOld = expedientes.getTituloExpediente();
		try {
			String titleNew = createNewTitleExpediente(expedientes, data, procedureActions);
			logger.info("[EXP] titulo nuevo: " + titleNew);
			String tituloActualizado = "";
			if (expedientes.getFolderId() != null) {
				tituloActualizado = this.ab61WebServiceAdaptadorService
						.actualizarTituloExpediente(expedientes.getFolderId(), titleNew);
			}
			// FolderId = null son migradas
			if ("ok".equals(tituloActualizado) || expedientes.getFolderId() == null) {
				logger.info("[EXP] Actualizado en TRAMITAGUNE");
				Expedientes expediente = this.expedientesDao.find(expedientes);
				expediente.setTitulo(titleNew);
				if (expediente.getFolderId() == null) {
					this.expedientesDao.updateTituloMigrados(expediente);
				} else {
					this.expedientesDao.updateExpedienteFolder(expediente);
				}
				logger.info("[EXP] Actualizado en BBDD");
				data.put(Constantes.KEY_TITLE_UPDATED, titleNew);
				data.put(Constantes.KEY_TITLE_COMPLETE, expedientes.getFolderNumber() + " - " + titleNew);
			}
		} catch (Exception e) {
			logger.info("[EXP] ERROR al actualizar el titulo intentado restaurar el anterior...");
			try {
				this.ab61WebServiceAdaptadorService.actualizarTituloExpediente(expedientes.getFolderId(), titleOld);
			} catch (Exception e1) {
				logger.info("[EXP] ERROR al restaurar el titulo anterior...");
			}
		}
	}

	private String createNewTitleExpediente(Expedientes initForm, Map<String, String> data,
			ProcedureActions procedureActions) {
		String lastTitle = initForm.getTituloExpediente();
		Denuncia denuncia = new Denuncia();
		denuncia.setExpediente(initForm);
		denuncia = denunciasService.findByIdExpediente(denuncia);

		initForm.setProcedimiento(findProcedureIdPorExpediente(initForm).getProcedimiento());

		Procedimientos procedimientos = this.procedimientosService.findProc(initForm.getProcedimientos());

		String template = procedimientos.getCamposTituloExpediente();

		String newTitle = template.replace("{{ubiEstablecimientoProvincia}}",
				denuncia.getDireccionDenunciado().getIdProvinciaPad());

		if (Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(procedimientos.getTipoDenuncia())) {
			if (denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getEstablecimiento() != null) {
				newTitle = newTitle.replace("{{nombreRazonSocialV}}", denuncia.getDireccionDenunciado().getEstablecimiento());
			} else {
				newTitle = newTitle.replace("{{nombreRazonSocialV}}", "");
			}
		} else {
			if (denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getEstablecimiento() != null) {
				newTitle = newTitle.replace("{{establecimientoNombre}}", denuncia.getDireccionDenunciado().getEstablecimiento());
			} else {
				newTitle = newTitle.replace("{{establecimientoNombre}}", "");
			}
		}
		if ((denuncia.getIdDireccion().equals(Constantes.COD_DIRECCION_TURISMO)
				|| Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(procedimientos.getTipoDenuncia()))
				&& !denuncia.getIndTipoReclamacion().equals(Constantes.ESTABLECIMIENTO_NO_CENSADO)) {
			if (null != denuncia.getDireccionDenunciado()
					&& denuncia.getDireccionDenunciado().getIdentificadorEstablecimiento() != null && !denuncia.getDireccionDenunciado().getIdentificadorEstablecimiento().equals("")) {
				newTitle = newTitle.replace("{{actividad}}{{tipoEstSign}}{{signature}}{{correlativEstSign}}",
						denuncia.getDireccionDenunciado().getIdentificadorEstablecimiento());
			} else if (null != denuncia.getIdTipoEstablecimiento()) {
				newTitle = newTitle.replace("{{actividad}}{{tipoEstSign}}{{signature}}{{correlativEstSign}}",
						denuncia.getIdTipoEstablecimiento());
			} else {
				newTitle = newTitle.replace("{{actividad}}{{tipoEstSign}}{{signature}}{{correlativEstSign}}", "  ");
			}
			if (denuncia.getIdDireccion().equals(Constantes.COD_DIRECCION_TURISMO)) {
				
				
				if (denuncia.getDireccionDenunciado().getIdProvincia() == null || (denuncia.getDireccionDenunciado().getIdProvincia() != null
						&& denuncia.getDireccionDenunciado().getIdProvincia() != 0 && denuncia.getDireccionDenunciado().getIdProvincia() != 1
						 && denuncia.getDireccionDenunciado().getIdProvincia() != 20  && denuncia.getDireccionDenunciado().getIdProvincia() != 48)){
					
					String provinciaTth = (denuncia.getIdProvinciaTthh()!=null && denuncia.getIdProvinciaTthh()!="" && denuncia.getIdProvinciaTthh().length() < 2?"0"+denuncia.getIdProvinciaTthh():denuncia.getIdProvinciaTthh());
					
					newTitle = newTitle.replace("{{ComboProvincia}}", provinciaTth);
				}else{
					
					String provinciaDenunciado = "";
					
					if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
							&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() < 2){
						
						provinciaDenunciado = "0"+denuncia.getDireccionDenunciado().getIdProvincia();
					}else if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
							&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() > 1){
						provinciaDenunciado = denuncia.getDireccionDenunciado().getIdProvincia().toString();
					}else{
						provinciaDenunciado = " ";
					}
					newTitle = newTitle.replace("{{ComboProvincia}}", provinciaDenunciado);
				}
			}
			if (Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(procedimientos.getTipoDenuncia())) {
				
				if (denuncia.getDireccionDenunciado().getIdProvincia() == null || (denuncia.getDireccionDenunciado().getIdProvincia() != null
						&& denuncia.getDireccionDenunciado().getIdProvincia() != 0 && denuncia.getDireccionDenunciado().getIdProvincia() != 1
						 && denuncia.getDireccionDenunciado().getIdProvincia() != 20  && denuncia.getDireccionDenunciado().getIdProvincia() != 48)){
					
					String provinciaTth = (denuncia.getIdProvinciaTthh()!=null && denuncia.getIdProvinciaTthh()!="" && denuncia.getIdProvinciaTthh().length() < 2?"0"+denuncia.getIdProvinciaTthh():denuncia.getIdProvinciaTthh());
					
					newTitle = newTitle.replace("{{ubicacionViviendaProv}}", provinciaTth);
				}else{
					
					String provinciaDenunciado = "";
					
					if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
							&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() < 2){
						
						provinciaDenunciado = "0"+denuncia.getDireccionDenunciado().getIdProvincia();
					}else if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
							&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() > 1){
						provinciaDenunciado = denuncia.getDireccionDenunciado().getIdProvincia().toString();
					}else{
						provinciaDenunciado = " ";
					}
					newTitle = newTitle.replace("{{ubicacionViviendaProv}}", provinciaDenunciado);
				}
			}
		} else if (denuncia.getIndTipoReclamacion().equals(Constantes.ESTABLECIMIENTO_NO_CENSADO)
				&& Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(procedimientos.getTipoDenuncia())) {
			newTitle = newTitle.replace("{{actividad}}{{tipoEstSign}}{{signature}}{{correlativEstSign}}", denuncia.getIdTipoEstablecimiento());
			
			if (denuncia.getDireccionDenunciado().getIdProvincia() == null || (denuncia.getDireccionDenunciado().getIdProvincia() != null
					&& denuncia.getDireccionDenunciado().getIdProvincia() != 0 && denuncia.getDireccionDenunciado().getIdProvincia() != 1
					 && denuncia.getDireccionDenunciado().getIdProvincia() != 20  && denuncia.getDireccionDenunciado().getIdProvincia() != 48)){
				
				String provinciaTth = (denuncia.getIdProvinciaTthh()!=null && denuncia.getIdProvinciaTthh()!="" && denuncia.getIdProvinciaTthh().length() < 2?"0"+denuncia.getIdProvinciaTthh():denuncia.getIdProvinciaTthh());
				
				newTitle = newTitle.replace("{{ubicacionViviendaProv}}", provinciaTth);
			}else{
				
				String provinciaDenunciado = "";
				
				if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
						&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() < 2){
					
					provinciaDenunciado = "0"+denuncia.getDireccionDenunciado().getIdProvincia();
				}else if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
						&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() > 1){
					provinciaDenunciado = denuncia.getDireccionDenunciado().getIdProvincia().toString();
				}else{
					provinciaDenunciado = " ";
				}
				newTitle = newTitle.replace("{{ubicacionViviendaProv}}", provinciaDenunciado);
			}
		} else if (denuncia.getIndTipoReclamacion().equals(Constantes.ESTABLECIMIENTO_NO_CENSADO)
				&& !Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(procedimientos.getTipoDenuncia())) {
			newTitle = newTitle.replace("{{actividad}}{{tipoEstSign}}{{signature}}{{correlativEstSign}}", denuncia.getIdTipoEstablecimiento());
			if (denuncia.getIdDireccion().equals(Constantes.COD_DIRECCION_TURISMO)) {
				
				if (denuncia.getDireccionDenunciado().getIdProvincia() == null || (denuncia.getDireccionDenunciado().getIdProvincia() != null
						&& denuncia.getDireccionDenunciado().getIdProvincia() != 0 && denuncia.getDireccionDenunciado().getIdProvincia() != 1
						 && denuncia.getDireccionDenunciado().getIdProvincia() != 20  && denuncia.getDireccionDenunciado().getIdProvincia() != 48)){
					
					String provinciaTth = (denuncia.getIdProvinciaTthh()!=null && denuncia.getIdProvinciaTthh()!="" && denuncia.getIdProvinciaTthh().length() < 2?"0"+denuncia.getIdProvinciaTthh():denuncia.getIdProvinciaTthh());
					
					newTitle = newTitle.replace("{{ComboProvincia}}", provinciaTth);
				}else{
					
					String provinciaDenunciado = "";
					
					if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
							&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() < 2){
						
						provinciaDenunciado = "0"+denuncia.getDireccionDenunciado().getIdProvincia();
					}else if(denuncia.getDireccionDenunciado() != null && denuncia.getDireccionDenunciado().getIdProvincia()!=null 
							&& denuncia.getDireccionDenunciado().getIdProvincia() !=0 && denuncia.getDireccionDenunciado().getIdProvincia().toString().length() > 1){
						provinciaDenunciado = denuncia.getDireccionDenunciado().getIdProvincia().toString();
					}else{
						provinciaDenunciado = " ";
					}
					newTitle = newTitle.replace("{{ComboProvincia}}", provinciaDenunciado);
				}
			}
		}

		return newTitle.contains("{{") ? lastTitle : newTitle;
	}

	/**
	 * 
	 * @param establecimiento
	 * @param expedientes
	 * @return
	 */

	@Override
	public List<Expedientes> findAllExpedientesOrigen(String identificadorEstablecimiento) {
		return this.expedientesDao.findAllExpedientesOrigen(identificadorEstablecimiento);
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Boolean updateOrigen(Expedientes expedientes) {
		return this.expedientesDao.updateOrigen(expedientes);
	}

	@Override
	public Boolean hasInspectExpedient(Integer idExpediente) {
		return this.expedientesDao.hasInspectExpedient(idExpediente);
	}

	@Override
	public Boolean hasInspeccion(Integer idExpediente) {
		return this.expedientesDao.hasInspeccion(idExpediente);
	}

	@Override
	public Inspeccion getInspect(String idInspeccion) {
		return this.expedientesDao.getInspect(idInspeccion);
	}

	@Override
	public Inspeccion getInspectExpedient(Integer idExpediente) {
		return this.expedientesDao.getInspectExpedient(idExpediente);
	}

	@Override
	public Inspeccion getInspectByFolderId(String folderId) {
		return this.expedientesDao.getInspectByFolderId(folderId);
	}

	@Override
	public boolean checkIsClosed(Expedientes expediente) {
		return this.expedientesDao.checkDateExpediente(expediente, Constantes.ETIQUETA_FECHA_EXP_CIERRE);
	}

	@Override
	public Expedientes updateTerritorioHistorico(Expedientes expediente) {
		return this.expedientesDao.updateTerritorioHistorico(expediente);
	}

	@Override
	public Date getMaxDateExpediente(Integer idExpediente, String tipoFecha, boolean isEtiqueta) {
		return this.expedientesDao.getMaxDateExpediente(idExpediente, tipoFecha, isEtiqueta);
	}

	private EmisorInicioOficio loadEmisorInicioOficio(HttpServletRequest request) {
		EmisorInicioOficio emisor = new EmisorInicioOficio();
		emisor.setIdEmsisor(UtilUsuario.fncIdUsuario(request));
		emisor.setNombreEmisor(UtilUsuario.fncNombre(request));
		emisor.setPrimerApellido(UtilUsuario.fncApellidos(request));
		return emisor;
	}

	private void registerChecksDenuncia(Denuncia denuncia) {
		// TODO: IRREGULARIDADES
		IrregularidadDenuncia irregularidadDenuncia = new IrregularidadDenuncia();
		irregularidadDenuncia.setDenuncia(new Denuncia(denuncia.getIdReclamacion()));
		List<IrregularidadDenuncia> irregularidadesActuales = this.irregularidadesDenunciaService
				.findAll(irregularidadDenuncia, null);
		if (denuncia.getCheckIrregularidad() != null && !denuncia.getCheckIrregularidad().isEmpty()) {
			List<String> listCheckIrregularidades = denuncia.getCheckIrregularidad();
			boolean isChecked = false;
			// primero eliminamos los no checkeados
			for (IrregularidadDenuncia irregularidadDenunciaActuales : irregularidadesActuales) {
				isChecked = false;
				for (Iterator<String> iterator = listCheckIrregularidades.iterator(); iterator.hasNext();) {
					String checkIrregularidades = iterator.next();
					Long idIrregularidad = Long.parseLong(checkIrregularidades);
					if (irregularidadDenunciaActuales.getIrregularidad().getIdIrregularidad() == idIrregularidad) {
						isChecked = true;
					}
				}
				if (!isChecked) {
					this.irregularidadesDenunciaService.delete(irregularidadDenunciaActuales);
				}
			}

			// agregamos los restantes
			for (String checkIrregularidades : listCheckIrregularidades) {
				Long idIrregularidad = Long.parseLong(checkIrregularidades);
				isChecked = false;
				for (IrregularidadDenuncia irregularidadDenunciaActuales : irregularidadesActuales) {
					if (irregularidadDenunciaActuales.getIrregularidad().getIdIrregularidad() == idIrregularidad) {
						isChecked = true;
					}
				}
				if (!isChecked) {
					irregularidadDenuncia.setIrregularidad(new Irregularidad(idIrregularidad));
					this.irregularidadesDenunciaService.add(irregularidadDenuncia);
				}
			}

		} else {
			// Si no hay nada selecionado se eliminan los registros
			for (IrregularidadDenuncia irregularidad : irregularidadesActuales) {
				this.irregularidadesDenunciaService.delete(irregularidad);
			}
		}
	}

	@Override
	public boolean esExpedienteCerrado(Expedientes expediente) {
		return this.expedientesDao.esExpedienteCerrado(expediente);
	}

}
