package com.ejie.ab78.service.expedientes;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.ejie.ab78.model.Inspeccion;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.service.procedimientos.ProcedureActions;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

public interface ExpedientesService {

	/**
	 * Inserts a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes add(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes update(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateFolder(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateExpedienteFolder(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes find(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findProcedureIdPorExpediente(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table por FolderId.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findByFolderId(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table por FolderId.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findByFolderNumber(Expedientes expedientes);

	/**
	 * Deletes a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 */
	void remove(Expedientes expedientes);

	/**
	 * Finds a list of rows in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Expedientes>
	 */
	List<Expedientes> findAll(Expedientes expedientes, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the Expedientes table using like.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Expedientes>
	 */
	List<Expedientes> findAllLikeTer(Expedientes expedientes, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Expedientes filterExpedientes, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Expedientes>
	 */
	TableResponseDto<Expedientes> filterTer(Expedientes filterExpedientes, TableRequestDto TableRequestDto,
			Boolean startsWith);

	TableResponseDto<Expedientes> filter(Expedientes filterExpedientes, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches rows in the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param searchExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Expedientes>>
	 */
	List<TableRowDto<Expedientes>> search(Expedientes filterExpedientes, Expedientes searchExpedientes,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Expedientes filterExpedientes, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<Expedientes>>
	 */
	TableResponseDto<JerarquiaDto<Expedientes>> jerarquia(Expedientes filterExpedientes,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Expedientes
	 * table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<Expedientes>>
	 */
	TableResponseDto<JerarquiaDto<Expedientes>> jerarquiaChildren(Expedientes filterExpedientes,
			TableRequestDto TableRequestDto);

	/**
	 * Método para obtener el Expediente mediante el FOLDER_NUMBER.
	 *
	 * @param String
	 *            folderNumber
	 * 
	 * @return List<Expedientes>
	 */
	List<Expedientes> findExpediente(String folderNumber);

	List<Expedientes> findExpedientesPendientesByExpediente(Integer idExpediente);

	ResultAjaxOperation save(Denuncia denuncia, ProcedureActions procedureActions, HttpServletRequest request,
			Boolean executeProcess);

	List<Expedientes> findAllExpedientesOrigen(String identificadorEstablecimiento);

	Boolean updateOrigen(Expedientes expedientes);

	Boolean hasInspectExpedient(Integer idExpediente);

	Boolean hasInspeccion(Integer idExpediente);

	Inspeccion getInspectExpedient(Integer idExpediente);

	Inspeccion getInspect(String idInspeccion);

	void updateExpedienteTitle(Denuncia denuncia, Map<String, String> data, ProcedureActions procedureActions);

	boolean checkIsClosed(Expedientes expediente);

	/**
	 * Actualiza el territorio hist�rico
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateTerritorioHistorico(Expedientes expediente);

	Date getMaxDateExpediente(Integer idExpediente, String tipoFecha, boolean isEtiqueta);

	Inspeccion getInspectByFolderId(String folderId);

	boolean esExpedienteCerrado(Expedientes expediente);

}
