package com.ejie.ab78.service.expedientes;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.dao.expedientes.ExpedientesHistoricosDao;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.ExpedienteHistorico;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

@Service(value = "expedientesHistoricosService")
public class ExpedientesHistoricosServiceImpl implements ExpedientesHistoricosService {

	@Autowired
	private ExpedientesHistoricosDao expedientesHistoricosDao;

	@Override
	public ExpedienteHistorico find(ExpedienteHistorico expedienteHistorico) {
		return expedientesHistoricosDao.find(expedienteHistorico);
	}

	@Override
	public ExpedienteHistorico findByFolderNumber(ExpedienteHistorico expedienteHistorico) {
		return expedientesHistoricosDao.findByFolderNumber(expedienteHistorico);
	}

	@Override
	public List<ExpedienteHistorico> findAll(ExpedienteHistorico expedienteHistorico, TableRequestDto tableRequestDto) {
		return expedientesHistoricosDao.findAll(expedienteHistorico, tableRequestDto);
	}

	@Override
	public List<ExpedienteHistorico> findAllLike(ExpedienteHistorico expedienteHistorico,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return expedientesHistoricosDao.findAllLike(expedienteHistorico, tableRequestDto, startsWith);
	}

	@Override
	public Long findAllLikeCount(ExpedienteHistorico expedienteHistorico, Boolean startsWith) {
		return expedientesHistoricosDao.findAllLikeCount(expedienteHistorico, startsWith);
	}

	@Override
	public Long findAllCount(ExpedienteHistorico expedienteHistorico) {
		return expedientesHistoricosDao.findAllCount(expedienteHistorico);
	}

	@Override
	public TableResponseDto<ExpedienteHistorico> filter(ExpedienteHistorico filterExpedientes,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<ExpedienteHistorico> listaExpedientes = this.expedientesHistoricosDao.findAllLike(filterExpedientes,
				tableRequestDto, false);
		Long recordNum = this.expedientesHistoricosDao
				.findAllLikeCount(filterExpedientes != null ? filterExpedientes : new ExpedienteHistorico(), false);

		return new TableResponseDto<ExpedienteHistorico>(tableRequestDto, recordNum, listaExpedientes);
	}


	@Override
	public ExpedienteHistorico findByDenuncia(Denuncia denuncia) {
		return expedientesHistoricosDao.findByDenuncia(denuncia);
	}

}
