package com.ejie.ab78.service.establecimientos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.dao.establecimientos.EstablecimientoDao;
import com.ejie.ab78.model.establecimientos.Establecimiento;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * Ab6301s00ServiceImpl  
 * 
 *  
 */

@Service(value = "establecimientoService")
public class EstablecimientoServiceImpl implements EstablecimientoService {

	@Autowired
	private EstablecimientoDao establecimientoDao;

	@Override
	public TableResponseDto<Establecimiento> filter(Establecimiento filterAb6301s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<Establecimiento> listaAb6301s00 = this.establecimientoDao.findAllLike(filterAb6301s00, tableRequestDto,
				false);

		Long recordNum = this.establecimientoDao
				.findAllLikeCount(filterAb6301s00 != null ? filterAb6301s00 : new Establecimiento(), false);

		return new TableResponseDto<Establecimiento>(tableRequestDto, recordNum, listaAb6301s00);
	}

	@Override
	public List<Establecimiento> findAllLike(Establecimiento ab6301s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.establecimientoDao.findAllLike(ab6301s00, tableRequestDto, startsWith);
	}

}