package com.ejie.ab78.service.denuncias;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.dao.denuncias.IrregularidadesDenunciaDao;
import com.ejie.ab78.model.denuncias.IrregularidadDenuncia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

@Service(value = "irregularidadesDenunciaService")
public class IrregularidadesDenunciaServiceImpl implements IrregularidadesDenunciaService {

	@Autowired
	private IrregularidadesDenunciaDao irregularidadesDenunciaDao;

	@Override
	public TableResponseDto<IrregularidadDenuncia> filter(IrregularidadDenuncia irregularidadDenuncia,
			TableRequestDto tableRequestDto, Boolean startsWith) {

		List<IrregularidadDenuncia> lista = this.irregularidadesDenunciaDao.findAllLike(irregularidadDenuncia,
				tableRequestDto, false);

		Long recordNum = this.irregularidadesDenunciaDao.findAllLikeCount(
				irregularidadDenuncia != null ? irregularidadDenuncia : new IrregularidadDenuncia(), false);

		return new TableResponseDto<IrregularidadDenuncia>(tableRequestDto, recordNum, lista);
	}

	@Override
	public List<IrregularidadDenuncia> findAllLike(IrregularidadDenuncia irregularidadDenuncia,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<IrregularidadDenuncia>) this.irregularidadesDenunciaDao.findAllLike(irregularidadDenuncia,
				tableRequestDto, startsWith);
	}

	@Override
	public IrregularidadDenuncia add(IrregularidadDenuncia irregularidadDenuncia) {
		return this.irregularidadesDenunciaDao.add(irregularidadDenuncia);
	}

	@Override
	public IrregularidadDenuncia update(IrregularidadDenuncia irregularidadDenuncia) {
		return this.irregularidadesDenunciaDao.update(irregularidadDenuncia);
	}

	@Override
	public IrregularidadDenuncia delete(IrregularidadDenuncia irregularidadDenuncia) {
		return this.irregularidadesDenunciaDao.delete(irregularidadDenuncia);
	}

	@Override
	public IrregularidadDenuncia find(IrregularidadDenuncia irregularidadDenuncia) {
		return this.irregularidadesDenunciaDao.find(irregularidadDenuncia);
	}

	@Override
	public List<IrregularidadDenuncia> findAll(IrregularidadDenuncia irregularidadDenuncia,
			TableRequestDto tableRequestDto) {
		return this.irregularidadesDenunciaDao.findAll(irregularidadDenuncia, tableRequestDto);
	}

	@Override
	public Long findAllLikeCount(IrregularidadDenuncia irregularidadDenuncia, Boolean startsWith) {
		return this.irregularidadesDenunciaDao.findAllLikeCount(irregularidadDenuncia, startsWith);
	}

	@Override
	public Long findAllCount(IrregularidadDenuncia irregularidadDenuncia) {
		return this.irregularidadesDenunciaDao.findAllCount(irregularidadDenuncia);
	}

}
