package com.ejie.ab78.service.denuncias;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.dao.denuncias.InfoEstablecimientosDao;
import com.ejie.ab78.model.InfoEstablecimiento;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DenunciasNoFormalesServiceImpl  
 * 
 *  
 */

@Service(value = "infoEstablecimientosService")
public class InfoEstablecimientosServiceImpl implements InfoEstablecimientosService {

	@Autowired
	private InfoEstablecimientosDao infoEstablecimientosDao;

	@Override
	public InfoEstablecimiento find(InfoEstablecimiento infoEstablecimiento) {
		return infoEstablecimientosDao.find(infoEstablecimiento);
	}

	@Override
	public InfoEstablecimiento findByIdentificadorEstablecimiento(InfoEstablecimiento infoEstablecimiento) {
		return infoEstablecimientosDao.findByIdentificadorEstablecimiento(infoEstablecimiento);
	}

	@Override
	public List<InfoEstablecimiento> findAll(InfoEstablecimiento infoEstablecimiento, TableRequestDto tableRequestDto) {
		return infoEstablecimientosDao.findAll(infoEstablecimiento, tableRequestDto);
	}

	@Override
	public List<InfoEstablecimiento> findAllLike(InfoEstablecimiento infoEstablecimiento,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return infoEstablecimientosDao.findAllLike(infoEstablecimiento, tableRequestDto, startsWith);
	}

	@Override
	public Long findAllLikeCount(InfoEstablecimiento infoEstablecimiento, Boolean startsWith) {
		return infoEstablecimientosDao.findAllLikeCount(infoEstablecimiento, startsWith);
	}

	@Override
	public Long findAllCount(InfoEstablecimiento infoEstablecimiento) {
		return infoEstablecimientosDao.findAllCount(infoEstablecimiento);
	}

}
