package com.ejie.ab78.service.denuncias;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.model.Aviso;
import com.ejie.ab78.dao.denuncias.ExpedienteDenunciaDao;
import com.ejie.ab78.model.denuncias.ExpedienteDenuncia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

@Service(value = "expedienteDenunciaService")
public class ExpedienteDenunciaServiceImpl implements ExpedienteDenunciaService {

	@Autowired
	private ExpedienteDenunciaDao expedienteDenunciaDao;

	@Override
	public TableResponseDto<ExpedienteDenuncia> filter(ExpedienteDenuncia expedienteDenuncia,
			TableRequestDto tableRequestDto, Boolean startsWith) {

		List<ExpedienteDenuncia> lista = this.expedienteDenunciaDao.findAllLike(expedienteDenuncia, tableRequestDto,
				false);

		Long recordNum = this.expedienteDenunciaDao
				.findAllLikeCount(expedienteDenuncia != null ? expedienteDenuncia : new ExpedienteDenuncia(), false);

		return new TableResponseDto<ExpedienteDenuncia>(tableRequestDto, recordNum, lista);
	}

	@Override
	public List<ExpedienteDenuncia> findAllLike(ExpedienteDenuncia expedienteDenuncia, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return (List<ExpedienteDenuncia>) this.expedienteDenunciaDao.findAllLike(expedienteDenuncia, tableRequestDto,
				startsWith);
	}

	@Override
	public List<Aviso> avisoPorFecha(Integer idAplicacion) {
		return this.expedienteDenunciaDao.avisoPorFecha(idAplicacion);
	}
}
