package com.ejie.ab78.service.denuncias;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.dao.denuncias.DenunciasDao;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.model.util.SuccessResultAjaxOperation;
import com.ejie.ab78.service.terceros.DatosDireccionesService;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DenunciasServiceImpl  
 * 
 *  
 */

@Service(value = "denunciasService")
public class DenunciasServiceImpl implements DenunciasService {

	@Autowired
	private DenunciasDao denunciasDao;

	@Autowired
	private DatosDireccionesService datosDireccionesService;

	/**
	 * Inserts a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia add(Denuncia denuncia) {
		return this.denunciasDao.add(denuncia);
	}

	/**
	 * Updates a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia update(Denuncia denuncia) {

		// Si hay establecimiento denunciado asociado, se asocia la signatura a
		// la direccin y se actualiza su la misma
		if (null != denuncia.getDireccionDenunciado() && denuncia.getDireccionDenunciado().getIdDireccion() != null
				&& denuncia.getDireccionDenunciado().getIdDireccion() > 0) {

			denuncia.getDireccionDenunciado()
					.setIdentificadorEstablecimiento(denuncia.getDireccionDenunciado().getIdentificadorEstablecimiento());
			this.datosDireccionesService.updateDireccionEstablecimientoDenunciado(denuncia.getDireccionDenunciado());
		} else if (null != denuncia.getDireccionDenunciado()) {
			this.datosDireccionesService.addDireccionDenuncia(denuncia);
		}
		return this.denunciasDao.update(denuncia);
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public ResultAjaxOperation saveDenuncia(Denuncia denuncia) {
		update(denuncia);
		return new SuccessResultAjaxOperation(Constantes.OK_GENERICO_GUARDADO);
	}

	/**
	 * Finds a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	public Denuncia find(Denuncia denuncia) {
		return (Denuncia) this.denunciasDao.find(denuncia);
	}

	public Denuncia findByIdExpediente(Denuncia denuncia) {
		return (Denuncia) this.denunciasDao.findByIdExpediente(denuncia);
	}

	/**
	 * Deletes a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Denuncia denuncia) {
		this.denunciasDao.remove(denuncia);
	}

	/**
	 * Finds a list of rows in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Denuncia>
	 */
	public List<Denuncia> findAll(Denuncia denuncia, TableRequestDto tableRequestDto) {
		return (List<Denuncia>) this.denunciasDao.findAll(denuncia, tableRequestDto);
	}

	/**
	 * Finds rows in the Denuncia table using like.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Denuncia>
	 */
	public List<Denuncia> findAllLike(Denuncia denuncia, TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<Denuncia>) this.denunciasDao.findAllLike(denuncia, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the Denuncia table.
	 *
	 * @param filterAb7801s00
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<Denuncia>
	 */
	public TableResponseDto<Denuncia> filter(Denuncia filterAb7801s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<Denuncia> listaAb7801s00 = this.denunciasDao.findAllLike(filterAb7801s00, tableRequestDto, false);
		Long recordNum = this.denunciasDao.findAllLikeCount(filterAb7801s00 != null ? filterAb7801s00 : new Denuncia(),
				false);

		TableResponseDto<Denuncia> usuarioDto = new TableResponseDto<Denuncia>(tableRequestDto, recordNum,
				listaAb7801s00);

		return usuarioDto;
	}


}
