package com.ejie.ab78.service.denuncias;

import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DenunciasService  
 * 
 *  
 */

public interface DenunciasService {

	/**
	 * Inserts a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia add(Denuncia denuncia);

	/**
	 * Updates a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia update(Denuncia denuncia);

	/**
	 * Finds a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia find(Denuncia denuncia);

	Denuncia findByIdExpediente(Denuncia denuncia);

	/**
	 * Deletes a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 */
	void remove(Denuncia denuncia);

	/**
	 * Finds a list of rows in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Denuncia>
	 */
	List<Denuncia> findAll(Denuncia denuncia, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Denuncia table using like.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Denuncia>
	 */
	List<Denuncia> findAllLike(Denuncia denuncia, TableRequestDto tableRequestDto, Boolean startsWith);

	TableResponseDto<Denuncia> filter(Denuncia filterAb7801s00, TableRequestDto tableRequestDto, Boolean startsWith);

	ResultAjaxOperation saveDenuncia(Denuncia denuncia);

}
