package com.ejie.ab78.service;

import com.ejie.ab78.dao.RelacionMotivoDenDao;
import com.ejie.ab78.model.denuncias.RelacionMotivoDen;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * RelacionMotivoDenServiceImpl  
 * 
 *  
 */

@Service(value = "relacionMotivoDenService")
public class RelacionMotivoDenServiceImpl implements RelacionMotivoDenService {

	@Autowired
	private RelacionMotivoDenDao relacionMotivoDenDao;

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelacionMotivoDen add(RelacionMotivoDen relacionMotivoDen) {
		return this.relacionMotivoDenDao.add(relacionMotivoDen);
	}

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelacionMotivoDen update(RelacionMotivoDen relacionMotivoDen) {
		return this.relacionMotivoDenDao.update(relacionMotivoDen);
	}

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	public RelacionMotivoDen find(RelacionMotivoDen relacionMotivoDen) {
		return (RelacionMotivoDen) this.relacionMotivoDenDao.find(relacionMotivoDen);
	}

	/**
	 * Deletes a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RelacionMotivoDen relacionMotivoDen) {
		this.relacionMotivoDenDao.remove(relacionMotivoDen);
	}

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	public List<RelacionMotivoDen> findAll(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto) {
		return (List<RelacionMotivoDen>) this.relacionMotivoDenDao.findAll(relacionMotivoDen, tableRequestDto);
	}

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelacionMotivoDen>
	 */
	public List<RelacionMotivoDen> findAllLike(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return (List<RelacionMotivoDen>) this.relacionMotivoDenDao.findAllLike(relacionMotivoDen, tableRequestDto,
				startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		this.relacionMotivoDenDao.removeMultiple(filterRelacionMotivoDen, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelacionMotivoDen>
	 */
	public TableResponseDto<RelacionMotivoDen> filter(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<RelacionMotivoDen> listaRelacionMotivoDen = this.relacionMotivoDenDao.findAllLike(filterRelacionMotivoDen,
				tableRequestDto, false);
		Long recordNum = this.relacionMotivoDenDao.findAllLikeCount(
				filterRelacionMotivoDen != null ? filterRelacionMotivoDen : new RelacionMotivoDen(), false);

		TableResponseDto<RelacionMotivoDen> usuarioDto = new TableResponseDto<RelacionMotivoDen>(tableRequestDto,
				recordNum, listaRelacionMotivoDen);
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<RelacionMotivoDen>> reorderSeeker = this.relacionMotivoDenDao
					.reorderSelection(filterRelacionMotivoDen, tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param searchRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	public List<TableRowDto<RelacionMotivoDen>> search(RelacionMotivoDen filterRelacionMotivoDen,
			RelacionMotivoDen searchRelacionMotivoDen, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.relacionMotivoDenDao.search(filterRelacionMotivoDen, searchRelacionMotivoDen, tableRequestDto,
				startsWith);
	}

	/**
	 * Reorder the selection made in RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		return this.relacionMotivoDenDao.reorderSelection(filterRelacionMotivoDen, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	public TableResponseDto<JerarquiaDto<RelacionMotivoDen>> jerarquia(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<RelacionMotivoDen>> listaRelacionMotivoDen = this.relacionMotivoDenDao
				.findAllLikeJerarquia(filterRelacionMotivoDen, tableRequestDto);
		Long recordNum = this.relacionMotivoDenDao.findAllLikeCountJerarquia(filterRelacionMotivoDen, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<RelacionMotivoDen>>(tableRequestDto, recordNum,
				listaRelacionMotivoDen);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the RelacionMotivoDen
	 * table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	public TableResponseDto<JerarquiaDto<RelacionMotivoDen>> jerarquiaChildren(
			RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<RelacionMotivoDen>> tableResponseDto = new TableResponseDto<JerarquiaDto<RelacionMotivoDen>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.relacionMotivoDenDao.findAllChild(filterRelacionMotivoDen, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<RelacionMotivoDen> getMultiple(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.relacionMotivoDenDao.getMultiple(filterRelacionMotivoDen, tableRequestDto, startsWith);
	}

}
