package com.ejie.ab78.service;

import com.ejie.ab78.model.denuncias.RelacionMotivoDen;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

/**
 * RelacionMotivoDenService  
 * 
 *  
 */

public interface RelacionMotivoDenService {

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	RelacionMotivoDen add(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	RelacionMotivoDen update(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	RelacionMotivoDen find(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Deletes a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 */
	void remove(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	List<RelacionMotivoDen> findAll(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelacionMotivoDen>
	 */
	List<RelacionMotivoDen> findAllLike(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelacionMotivoDen>
	 */
	TableResponseDto<RelacionMotivoDen> filter(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param searchRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<RelacionMotivoDen>> search(RelacionMotivoDen filterRelacionMotivoDen,
			RelacionMotivoDen searchRelacionMotivoDen, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	TableResponseDto<JerarquiaDto<RelacionMotivoDen>> jerarquia(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the RelacionMotivoDen
	 * table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>>
	 */
	TableResponseDto<JerarquiaDto<RelacionMotivoDen>> jerarquiaChildren(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<RelacionMotivoDen> getMultiple(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith);

}
