package com.ejie.ab78.security;

import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.x38.security.PerimetralSecurityWrapperN38Impl;
import com.ejie.x38.security.XlnetCore;

import n38c.exe.N38API;

/**
 * The Class Ab78PerimetralSecurityWrapperImpl.
 * 
 *  
 */
public class Ab78PerimetralSecurityWrapperImpl extends PerimetralSecurityWrapperN38Impl {

	private static final Logger logger = LoggerFactory.getLogger(Ab78PerimetralSecurityWrapperImpl.class);

	private boolean useXlnetProfiles = false;

	public static final String PATH_XMLSESION_N38PERFILES = "/n38/elementos/elemento[@subtipo='N38Sesion']/parametro[@id='n38perfiles']/valor";

	/**
	 * Retrieve an Session XLNets and save in session and load on httpSesion, if
	 * userData is not null load info for use on application as userCredencials
	 * 
	 * @param n38Api
	 * @param httpSession
	 * @throws Exception
	 */

	// Recovery and storage of the Credential info of XLNets
	@Override
	protected String loadXlnetsCredentialInfo(HttpServletRequest httpRequest, String xLNetsUserId) {

		N38API n38Api = XlnetCore.getN38API(httpRequest);
		HttpSession httpSession = httpRequest.getSession(false);
		Vector<String> userProfiles = new Vector<String>();
		String UserName;
		String serialNumber = null;
		String policy;

		// Recovering general data of XLNets user credentials
		httpSession.setAttribute("nif", XlnetCore.getParameterSession(n38Api, N38API.NOMBRE_DNI));
		policy = XlnetCore.getParameterSession(n38Api, N38API.NOMBRE_N38CERTIFICADOPOLITICAS);
		httpSession.setAttribute("policy", policy);

		if (!(policy.toLowerCase().equals("no"))) {
			httpSession.setAttribute("isCertificate", "true");
		} else {
			httpSession.setAttribute("isCertificate", "false");
		}

		if (!(XlnetCore.getParameterSession(n38Api, "n38uidOrg").equals("0"))) {
			// User is in the XLNets's LDap
			UserName = XlnetCore.getParameterSession(n38Api, "n38personasuid");

			// Recovering XLNets user credentials
			httpSession.setAttribute("userName", UserName);
			httpSession.setAttribute("position", XlnetCore.getParameterSession(n38Api, N38API.NOMBRE_N38PUESTOUID));
			httpSession.setAttribute("uidSession", XlnetCore.getParameterSession(n38Api, N38API.NOMBRE_N38UIDSESION));
			httpSession.setAttribute("udaValidateSessionId", xLNetsUserId);

			userProfiles.addAll(XlnetCore.searchParameterIntoXlnetSesion(XlnetCore.getN38ItemSesion(n38Api),
					PATH_XMLSESION_N38PERFILES));

			// Set obtain user's profiles
			httpSession.setAttribute("userProfiles", userProfiles);

		} else {
			// User isn't in the XLNets's LDap
			UserName = (String) httpSession.getAttribute("fullName");
			serialNumber = (String) httpSession.getAttribute("serialNumber");

			// Recovering user credentials
			httpSession.setAttribute("userName", UserName);
			httpSession.setAttribute("uidSession", httpSession.getId());
			httpSession.setAttribute("udaValidateSessionId", xLNetsUserId);

			Vector<String> userprofile = new Vector<String>();

			// Deleting the serialNumber object
			httpSession.removeAttribute("serialNumber");

			httpSession.setAttribute("userProfiles", userprofile);
		}

		return UserName;
	}

	// Getters & Setters

	public boolean isUseXlnetProfiles() {
		return useXlnetProfiles;
	}

	public void setUseXlnetProfiles(boolean useXlnetProfiles) {
		this.useXlnetProfiles = useXlnetProfiles;
	}

}
