package com.ejie.ab78.model.terceros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class TiposTercero implements java.io.Serializable {

	private Long idTipoTercero;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private String role;

	private List<DatosTerceros> terceroses = new ArrayList<DatosTerceros>();

	/**
	 * Method 'TiposTercero'.
	 */
	public TiposTercero() {
	}

	/**
	 * Method 'TiposTercero'.
	 * 
	 * @param idTipoTercero
	 *            Long
	 */
	public TiposTercero(Long idTipoTercero) {
		this.idTipoTercero = idTipoTercero;
	}

	/**
	 * Method 'TiposTercero'.
	 * 
	 * @param idTipoTercero
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 */
	public TiposTercero(Long idTipoTercero, String descripcionCastellano, String descripcionEuskera, Date fechaRegistro,
			String usuarioRegistro, String role) {
		this.idTipoTercero = idTipoTercero;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.role = role;
	}

	/**
	 * Method 'TiposTercero'.
	 * 
	 * @param idTipoTercero
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param empresases
	 *            List<Empresas>
	 * @param terceroses
	 *            List<Terceros>
	 */
	public TiposTercero(Long idTipoTercero, String descripcionCastellano, String descripcionEuskera, Date fechaRegistro,
			String usuarioRegistro, String role, List<DatosTerceros> terceroses) {

		this.idTipoTercero = idTipoTercero;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.role = role;
		this.terceroses = terceroses;
	}

	/**
	 * Method 'getIdTipoTercero'.
	 *
	 * @return Long
	 */

	public Long getIdTipoTercero() {
		return this.idTipoTercero;
	}

	/**
	 * Method 'setIdTipoTercero'.
	 *
	 * @param idTipoTercero
	 *            Long
	 * @return
	 */

	public void setIdTipoTercero(Long idTipoTercero) {
		this.idTipoTercero = idTipoTercero;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * @return the role
	 */
	public String getRole() {
		return role;
	}

	/**
	 * @param role
	 *            the role to set
	 */
	public void setRole(String role) {
		this.role = role;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoTercero: ").append(this.idTipoTercero).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ Role: ").append(this.role).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the terceroses
	 */
	public List<DatosTerceros> getTerceroses() {
		return terceroses;
	}

	/**
	 * @param terceroses
	 *            the terceroses to set
	 */
	public void setTerceroses(List<DatosTerceros> terceroses) {
		this.terceroses = terceroses;
	}

}
