package com.ejie.ab78.model.terceros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class TiposDocumento implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idTipoDocumento;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<DatosTerceros> terceroses = new ArrayList<DatosTerceros>();

	/**
	 * Method 'TiposDocumento'.
	 */
	public TiposDocumento() {
	}

	/**
	 * Method 'TiposDocumento'.
	 * 
	 * @param idTipoDocumento
	 *            Long
	 */
	public TiposDocumento(Long idTipoDocumento) {
		this.idTipoDocumento = idTipoDocumento;
	}

	/**
	 * Method 'TiposDocumento'.
	 * 
	 * @param idTipoDocumento
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 */
	public TiposDocumento(Long idTipoDocumento, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro) {
		this.idTipoDocumento = idTipoDocumento;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'TiposDocumento'.
	 * 
	 * @param idTipoDocumento
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param terceroses
	 *            List<Terceros>
	 */
	public TiposDocumento(Long idTipoDocumento, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro, List<DatosTerceros> terceroses) {

		this.idTipoDocumento = idTipoDocumento;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.terceroses = terceroses;
	}

	/**
	 * Method 'getIdTipoDocumento'.
	 *
	 * @return Long
	 */

	public Long getIdTipoDocumento() {
		return this.idTipoDocumento;
	}

	/**
	 * Method 'setIdTipoDocumento'.
	 *
	 * @param idTipoDocumento
	 *            Long
	 * @return
	 */

	public void setIdTipoDocumento(Long idTipoDocumento) {
		this.idTipoDocumento = idTipoDocumento;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	public TiposDocumento(String descripcionCastellano, String descripcionEuskera) {
		super();
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoDocumento: ").append(this.idTipoDocumento).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the terceroses
	 */
	public List<DatosTerceros> getTerceroses() {
		return terceroses;
	}

	/**
	 * @param terceroses
	 *            the terceroses to set
	 */
	public void setTerceroses(List<DatosTerceros> terceroses) {
		this.terceroses = terceroses;
	}

}
