package com.ejie.ab78.model.terceros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * TiposDireccion  
 * 
 *  
 */

public class TiposDireccion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idTipoDireccion;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<DatosDirecciones> datosDireccioneses = new ArrayList<DatosDirecciones>();

	/**
	 * Method 'TiposDireccion'.
	 */
	public TiposDireccion() {
	}

	/**
	 * Method 'TiposDireccion'.
	 * 
	 * @param idTipoDireccion
	 *            Long
	 */
	public TiposDireccion(Long idTipoDireccion) {
		this.idTipoDireccion = idTipoDireccion;
	}

	/**
	 * Method 'TiposDireccion'.
	 * 
	 * @param idTipoDireccion
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 */
	public TiposDireccion(Long idTipoDireccion, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro) {
		this.idTipoDireccion = idTipoDireccion;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'TiposDireccion'.
	 * 
	 * @param idTipoDireccion
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param datosDireccioneses
	 *            List<DatosDirecciones>
	 */
	public TiposDireccion(Long idTipoDireccion, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro, List<DatosDirecciones> datosDireccioneses) {

		this.idTipoDireccion = idTipoDireccion;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.datosDireccioneses = datosDireccioneses;
	}

	/**
	 * Method 'getIdTipoDireccion'.
	 *
	 * @return Long
	 */

	public Long getIdTipoDireccion() {
		return this.idTipoDireccion;
	}

	/**
	 * Method 'setIdTipoDireccion'.
	 *
	 * @param idTipoDireccion
	 *            Long
	 * @return
	 */

	public void setIdTipoDireccion(Long idTipoDireccion) {
		this.idTipoDireccion = idTipoDireccion;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getDatosDireccioneses'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<DatosDirecciones> getDatosDireccioneses() {
		return this.datosDireccioneses;
	}

	/**
	 * Method 'setDatosDireccioneses'.
	 *
	 * @param datosDireccioneses
	 *            List
	 * @return
	 */
	public void setDatosDireccioneses(List<DatosDirecciones> datosDireccioneses) {
		this.datosDireccioneses = datosDireccioneses;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoDireccion: ").append(this.idTipoDireccion).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
