package com.ejie.ab78.model.terceros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class TiposCanalAviso implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idTipoCanalAviso;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<CanalesAviso> canalesAvisos = new ArrayList<CanalesAviso>();

	/**
	 * Method 'TiposCanalAviso'.
	 */
	public TiposCanalAviso() {
	}

	/**
	 * Method 'TiposCanalAviso'.
	 * 
	 * @param idTipoCanalAviso
	 *            Long
	 */
	public TiposCanalAviso(Long idTipoCanalAviso) {
		this.idTipoCanalAviso = idTipoCanalAviso;
	}

	/**
	 * Method 'TiposCanalAviso'.
	 * 
	 * @param idTipoCanalAviso
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 */
	public TiposCanalAviso(Long idTipoCanalAviso, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro) {
		this.idTipoCanalAviso = idTipoCanalAviso;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'TiposCanalAviso'.
	 * 
	 * @param idTipoCanalAviso
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param canalesAvisos
	 *            List<CanalesAviso>
	 */
	public TiposCanalAviso(Long idTipoCanalAviso, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro, List<CanalesAviso> canalesAvisos) {

		this.idTipoCanalAviso = idTipoCanalAviso;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.canalesAvisos = canalesAvisos;
	}

	/**
	 * Method 'getIdTipoCanalAviso'.
	 *
	 * @return Long
	 */

	public Long getIdTipoCanalAviso() {
		return this.idTipoCanalAviso;
	}

	/**
	 * Method 'setIdTipoCanalAviso'.
	 *
	 * @param idTipoCanalAviso
	 *            Long
	 * @return
	 */

	public void setIdTipoCanalAviso(Long idTipoCanalAviso) {
		this.idTipoCanalAviso = idTipoCanalAviso;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getCanalesAvisos'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<CanalesAviso> getCanalesAvisos() {
		return this.canalesAvisos;
	}

	/**
	 * Method 'setCanalesAvisos'.
	 *
	 * @param canalesAvisos
	 *            List
	 * @return
	 */
	public void setCanalesAvisos(List<CanalesAviso> canalesAvisos) {
		this.canalesAvisos = canalesAvisos;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoCanalAviso: ").append(this.idTipoCanalAviso).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
