package com.ejie.ab78.model.terceros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * RelExpTer  
 * 
 *  
 */

public class RelExpTer implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idRelExpTer;
	private DatosTerceros datosTerceros;
	private Integer idExpediente;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private String participantId;
	private TiposTercero tiposTercero;
	private Integer idSubtipo;

	private Integer orden;
	private List<DatosTerceros> datosTercerosList = new ArrayList<DatosTerceros>();
	private List<DatosDirecciones> listaDirecciones = new ArrayList<DatosDirecciones>();

	/**
	 * Method 'RelExpTer'.
	 */
	public RelExpTer() {
	}

	/**
	 * Method 'RelExpTer'.
	 * 
	 * @param idRelExpTer
	 *            Integer
	 */
	public RelExpTer(Integer idRelExpTer) {
		this.idRelExpTer = idRelExpTer;
	}

	/**
	 * Method 'RelExpTer'.
	 * 
	 * @param idRelExpTer
	 *            Integer
	 * @param idExpediente
	 *            Integer
	 * @param idTipoTercero
	 *            Long
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param idParticipacion
	 *            String
	 * @param datosTerceros
	 *            DatosTerceros
	 */
	public RelExpTer(Integer idRelExpTer, Integer idExpediente, String participantId, Integer orden, Date fechaRegistro,
			String usuarioRegistro, DatosTerceros datosTerceros, TiposTercero tiposTercero) {

		this.idRelExpTer = idRelExpTer;

		this.idExpediente = idExpediente;

		this.participantId = participantId;
		this.orden = orden;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.datosTerceros = datosTerceros;
		this.tiposTercero = tiposTercero;
	}

	/**
	 * Method 'RelExpTer'.
	 * 
	 * @param idRelExpTer
	 *            Integer
	 * @param idExpediente
	 *            Integer
	 * @param idTipoTercero
	 *            Long
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param idParticipacion
	 *            String
	 * @param datosTerceros
	 *            DatosTerceros
	 */
	public RelExpTer(Integer idRelExpTer, DatosTerceros datosTerceros) {

		this.idRelExpTer = idRelExpTer;
		this.datosTerceros = datosTerceros;

	}

	/**
	 * Method 'getIdRelExpTer'.
	 *
	 * @return Integer
	 */

	public Integer getIdRelExpTer() {
		return this.idRelExpTer;
	}

	/**
	 * Method 'setIdRelExpTer'.
	 *
	 * @param idRelExpTer
	 *            Integer
	 * @return
	 */

	public void setIdRelExpTer(Integer idRelExpTer) {
		this.idRelExpTer = idRelExpTer;
	}

	/**
	 * Method 'getDatosTerceros'.
	 *
	 * @return DatosTerceros
	 */

	public DatosTerceros getDatosTerceros() {
		return this.datosTerceros;
	}

	/**
	 * Method 'setDatosTerceros'.
	 *
	 * @param datosTerceros
	 *            DatosTerceros
	 * @return
	 */

	public void setDatosTerceros(DatosTerceros datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

	/**
	 * Method 'getIdExpediente'.
	 *
	 * @return Integer
	 */

	public Integer getIdExpediente() {
		return this.idExpediente;
	}

	/**
	 * Method 'setIdExpediente'.
	 *
	 * @param idExpediente
	 *            Integer
	 * @return
	 */

	public void setIdExpediente(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * @return the participantId
	 */
	public String getParticipantId() {
		return participantId;
	}

	/**
	 * @param participantId
	 *            the participantId to set
	 */
	public void setParticipantId(String participantId) {
		this.participantId = participantId;
	}

	/**
	 * @return the tiposTercero
	 */
	public TiposTercero getTiposTercero() {
		return tiposTercero;
	}

	/**
	 * @param tiposTercero
	 *            the tiposTercero to set
	 */
	public void setTiposTercero(TiposTercero tiposTercero) {
		this.tiposTercero = tiposTercero;
	}

	/**
	 * @return the datosTercerosList
	 */
	public List<DatosTerceros> getDatosTercerosList() {
		return datosTercerosList;
	}

	/**
	 * @param datosTercerosList
	 *            the datosTercerosList to set
	 */
	public void setDatosTercerosList(List<DatosTerceros> datosTercerosList) {
		this.datosTercerosList = datosTercerosList;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "RelExpTer [idRelExpTer=" + idRelExpTer + ", datosTerceros=" + datosTerceros + ", idExpediente="
				+ idExpediente + ", fechaRegistro=" + fechaRegistro + ", usuarioRegistro=" + usuarioRegistro
				+ ", participantId=" + participantId + ", tiposTercero=" + tiposTercero + ", datosTercerosList="
				+ datosTercerosList + "]";
	}

	/**
	 * @return the orden
	 */
	public Integer getOrden() {
		return orden;
	}

	/**
	 * @param orden
	 *            the orden to set
	 */
	public void setOrden(Integer orden) {
		this.orden = orden;
	}

	/**
	 * @return the listaDirecciones
	 */
	public List<DatosDirecciones> getListaDirecciones() {
		return listaDirecciones;
	}

	/**
	 * @param listaDirecciones
	 *            the listaDirecciones to set
	 */
	public void setListaDirecciones(List<DatosDirecciones> listaDirecciones) {
		this.listaDirecciones = listaDirecciones;
	}

	/**
	 * @return the fechaUltmodificacion
	 */
	public Date getFechaUltmodificacion() {
		return fechaUltmodificacion;
	}

	/**
	 * @param fechaUltmodificacion
	 *            the fechaUltmodificacion to set
	 */
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * @return the usuarioUltmodificacion
	 */
	public String getUsuarioUltmodificacion() {
		return usuarioUltmodificacion;
	}

	/**
	 * @param usuarioUltmodificacion
	 *            the usuarioUltmodificacion to set
	 */
	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public Integer getIdSubtipo() {
		return idSubtipo;
	}

	public void setIdSubtipo(Integer idSubtipo) {
		this.idSubtipo = idSubtipo;
	}

}
