package com.ejie.ab78.model.terceros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * DatosTerceros  
 * 
 *  
 */

public class DatosTerceros implements java.io.Serializable {

	private static final long serialVersionUID = 4507867311258651874L;

	private Integer idTercero;
	private String documento;
	private TiposDocumento tiposDocumento;
	private String nombre;
	private String apellido1;
	private String apellido2;
	private Sexo sexo;
	private Long telefono;
	private String email;
	private Integer idioma;
	private Integer tipoParticipante;
	private String usuarioRegistro;
	private String usuarioUltmodificacion;

	private List<DatosDirecciones> listDatosDirecciones = new ArrayList<DatosDirecciones>();
	private List<RelExpTer> relExpTers = new ArrayList<RelExpTer>();
	private List<CanalesAviso> canalesAvisos = new ArrayList<CanalesAviso>();

	private String datosTerceros;

	private String nombreCompuesto;
	private TiposTercero tiposTercero;
	private String participantId;

	/**
	 * Method 'DatosTerceros'.
	 */
	public DatosTerceros() {

	}

	/**
	 * Method 'DatosTerceros'.
	 * 
	 * @param idTercero
	 *            Integer
	 */
	public DatosTerceros(Integer idTercero) {
		this.idTercero = idTercero;
	}

	/**
	 * Method 'DatosTerceros'.
	 * 
	 * @param idTercero
	 *            Integer
	 * @param documento
	 *            String
	 * @param idTipoDocumento
	 *            Long
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @param idSexo
	 *            Long
	 * @param telefono
	 *            Long
	 * @param email
	 *            String
	 * @param idioma
	 *            Integer
	 * @param tipoParticipante
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param datosTerceros
	 *            DatosTerceros
	 */
	public DatosTerceros(Integer idTercero, String documento, TiposDocumento tiposDocumento, String nombre,
			String apellido1, String apellido2, Sexo sexo, Long telefono, String email, Integer idioma,
			Integer tipoParticipante) {

		this.idTercero = idTercero;
		this.documento = documento;
		this.tiposDocumento = tiposDocumento;
		this.nombre = nombre;
		this.apellido1 = apellido1;
		this.apellido2 = apellido2;
		this.sexo = sexo;
		this.telefono = telefono;
		this.email = email;
		this.idioma = idioma;
		this.tipoParticipante = tipoParticipante;
		// aki
		String nombreCompuestoAux = "";
		if (nombre != null || apellido1 != null || apellido2 != null) {
			// nombreCompuestoAux = nombre;

			if (nombre != null) {
				nombreCompuestoAux = nombre;
			}

			if (apellido1 != null) {
				if (!"".equals(nombreCompuestoAux)) {
					nombreCompuestoAux = nombreCompuestoAux + " " + apellido1;
				} else {
					nombreCompuestoAux = apellido1;
				}
			}

			if (apellido2 != null) {

				if (!"".equals(nombreCompuestoAux)) {
					nombreCompuestoAux = nombreCompuestoAux + " " + apellido2;
				} else {
					nombreCompuestoAux = apellido2;
				}
			}
		}
		this.nombreCompuesto = nombreCompuestoAux;
	}

	public DatosTerceros(Integer idTercero, String documento, TiposDocumento tiposDocumento, String nombre,
			String apellido1, String apellido2, Sexo sexo, Long telefono, String email, Integer idioma,
			Integer tipoParticipante, List<DatosDirecciones> datosDireccioneses, List<RelExpTer> relExpTers) {

		this.idTercero = idTercero;

		this.documento = documento;
		this.tiposDocumento = tiposDocumento;
		this.nombre = nombre;
		this.apellido1 = apellido1;
		this.apellido2 = apellido2;
		this.sexo = sexo;
		this.telefono = telefono;
		this.email = email;
		this.idioma = idioma;
		this.tipoParticipante = tipoParticipante;

		this.listDatosDirecciones = datosDireccioneses;
		this.relExpTers = relExpTers;
	}

	public Integer getIdTercero() {
		return this.idTercero;
	}

	public void setIdTercero(Integer idTercero) {
		this.idTercero = idTercero;
	}

	public String getDocumento() {
		return this.documento;
	}

	public void setDocumento(String documento) {
		this.documento = documento;
	}

	public TiposDocumento getTiposDocumento() {
		return tiposDocumento;
	}

	public void setTiposDocumento(TiposDocumento tiposDocumento) {
		this.tiposDocumento = tiposDocumento;
	}

	public String getNombre() {
		return this.nombre;
	}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	public String getApellido1() {
		return this.apellido1;
	}

	public void setApellido1(String apellido1) {
		this.apellido1 = apellido1;
	}

	public String getApellido2() {
		return this.apellido2;
	}

	public void setApellido2(String apellido2) {
		this.apellido2 = apellido2;
	}

	public Long getTelefono() {
		return this.telefono;
	}

	public Sexo getSexo() {
		return sexo;
	}

	public void setSexo(Sexo sexo) {
		this.sexo = sexo;
	}

	public void setTelefono(Long telefono) {
		this.telefono = telefono;
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Integer getIdioma() {
		return this.idioma;
	}

	public void setIdioma(Integer idioma) {
		this.idioma = idioma;
	}

	public Integer getTipoParticipante() {
		return this.tipoParticipante;
	}

	public void setTipoParticipante(Integer tipoParticipante) {
		this.tipoParticipante = tipoParticipante;
	}

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	@JsonIgnore
	public List<DatosDirecciones> getListDatosDirecciones() {
		return this.listDatosDirecciones;
	}

	public void setListDatosDirecciones(List<DatosDirecciones> datosDireccioneses) {
		this.listDatosDirecciones = datosDireccioneses;
	}

	@JsonIgnore
	public List<RelExpTer> getRelExpTers() {
		return this.relExpTers;
	}

	public void setRelExpTers(List<RelExpTer> relExpTers) {
		this.relExpTers = relExpTers;
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTercero: ").append(this.idTercero).append(" ]");
		result.append(", [ documento: ").append(this.documento).append(" ]");
		result.append(", [ nombre: ").append(this.nombre).append(" ]");
		result.append(", [ apellido1: ").append(this.apellido1).append(" ]");
		result.append(", [ apellido2: ").append(this.apellido2).append(" ]");
		result.append(", [ telefono: ").append(this.telefono).append(" ]");
		result.append(", [ email: ").append(this.email).append(" ]");
		result.append(", [ idioma: ").append(this.idioma).append(" ]");
		result.append(", [ tipoParticipante: ").append(this.tipoParticipante).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the canalesAvisos
	 */
	public List<CanalesAviso> getCanalesAvisos() {
		return canalesAvisos;
	}

	/**
	 * @param canalesAvisos
	 *            the canalesAvisos to set
	 */
	public void setCanalesAvisos(List<CanalesAviso> canalesAvisos) {
		this.canalesAvisos = canalesAvisos;
	}

	/**
	 * @return the datosTerceros
	 */
	public String getDatosTerceros() {
		return datosTerceros;
	}

	/**
	 * @param datosTerceros
	 *            the datosTerceros to set
	 */
	public void setDatosTerceros(String datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

	public String getNombreCompuesto() {
		return nombreCompuesto;
	}

	public void setNombreCompuesto(String nombreCompuesto) {
		this.nombreCompuesto = nombreCompuesto;
	}

	public TiposTercero getTiposTercero() {
		return tiposTercero;
	}

	public void setTiposTercero(TiposTercero tiposTercero) {
		this.tiposTercero = tiposTercero;
	}

	public String getParticipantId() {
		return participantId;
	}

	public void setParticipantId(String participantId) {
		this.participantId = participantId;
	}
}
