package com.ejie.ab78.model.terceros;

import java.util.Date;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.nora.T17Localidad;
import com.ejie.ab78.model.nora.T17Municipio;
import com.ejie.ab78.model.nora.T17Pais;
import com.ejie.ab78.model.nora.T17Provincia;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * DatosDirecciones  
 * 
 *  
 */

public class DatosDirecciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDireccion;
	private DatosTerceros datosTerceros;
	private TiposDireccion tiposDireccion;
	private String direccion;
	private String numero;
	private String escalera;
	private String piso;
	private String letra;
	private String codigoPostal;
	private Long idProvincia;
	private Long idMunicipio;
	private Long idLocalidad;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private String establecimiento;
	private String identificadorEstablecimiento;

	private String paisdso;
	private String provinciadso;
	private String municipiodso;
	private String localidaddso;

	private Long idPais;
	private String descProvinciaExtranjera;
	private String descCiudadExtranjera;

	private String direccionCompuesta;

	private Integer idExpediente;
	
	private String complementoDireccion;
	
	private String descripcionCiudad;
	private String descripcionProvincia;
	
	private T17Pais pais;
	private T17Provincia provincia;
	private T17Municipio municipio;
	private T17Localidad localidad;

	public String getComplementoDireccion() {
		return complementoDireccion;
	}

	public void setComplementoDireccion(String complementoDireccion) {
		this.complementoDireccion = complementoDireccion;
	}

	public String getDescripcionCiudad() {
		return descripcionCiudad;
	}

	public void setDescripcionCiudad(String descripcionCiudad) {
		this.descripcionCiudad = descripcionCiudad;
	}

	public String getDescripcionProvincia() {
		return descripcionProvincia;
	}

	public void setDescripcionProvincia(String descripcionProvincia) {
		this.descripcionProvincia = descripcionProvincia;
	}

	public T17Pais getPais() {
		return pais;
	}

	public void setPais(T17Pais pais) {
		this.pais = pais;
	}

	public T17Provincia getProvincia() {
		return provincia;
	}

	public void setProvincia(T17Provincia provincia) {
		this.provincia = provincia;
	}

	public T17Municipio getMunicipio() {
		return municipio;
	}

	public void setMunicipio(T17Municipio municipio) {
		this.municipio = municipio;
	}

	public T17Localidad getLocalidad() {
		return localidad;
	}

	public void setLocalidad(T17Localidad localidad) {
		this.localidad = localidad;
	}

	/**
	 * Method 'DatosDirecciones'.
	 */
	public DatosDirecciones() {
	}

	public DatosDirecciones(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	public DatosDirecciones(Integer idDireccion, String establecimiento, String direccion, String numero,
			String escalera, String piso, String letra, String codigoPostal, Long idPais, Long idProvincia,
			Long idMunicipio, Long idLocalidad, String descProvinciaExtranjera, String descCiudadExtranjera,
			String identificadorEstablecimiento, DatosTerceros datosTerceros, TiposDireccion tiposDireccion,
			String municipiodso) {

		this.idDireccion = idDireccion;
		this.establecimiento = establecimiento;
		this.datosTerceros = datosTerceros;
		this.tiposDireccion = tiposDireccion;
		this.direccion = direccion;
		this.numero = numero;
		this.escalera = escalera;
		this.piso = piso;
		this.letra = letra;
		this.codigoPostal = codigoPostal;
		this.idPais = idPais;
		this.idProvincia = idProvincia;
		this.idMunicipio = idMunicipio;
		this.idLocalidad = idLocalidad;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.descProvinciaExtranjera = descProvinciaExtranjera;
		this.descCiudadExtranjera = descCiudadExtranjera;
		this.municipiodso = municipiodso;
		// aki snts
		String direccionAux = "";
		if (direccion != null) {
			direccionAux = direccion;
		}

		if (numero != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + " " + numero;
			} else {
				direccionAux = numero;
			}
		}

		if (escalera != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + escalera;
			} else {
				direccionAux = escalera;
			}
		}

		if (piso != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + piso;
			} else {
				direccionAux = piso;
			}
		}

		if (letra != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + letra;
			} else {
				direccionAux = letra;
			}
		}

		if (municipiodso != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + " (" + municipiodso + ")";
			} else {
				direccionAux = municipiodso;
			}
		}

		this.direccionCompuesta = direccionAux;
	}

	public DatosDirecciones(Integer idDireccion, String establecimiento, String direccion, String numero,
			String escalera, String piso, String letra, String codigoPostal, Long idPais, Long idProvincia,
			Long idMunicipio, Long idLocalidad, String descProvinciaExtranjera, String descCiudadExtranjera,
			String identificadorEstablecimiento, DatosTerceros datosTerceros, TiposDireccion tiposDireccion, String paisDso,
			String provinciadso, String municipiodso, String localidaddso) {

		this.idDireccion = idDireccion;
		this.establecimiento = establecimiento;
		this.datosTerceros = datosTerceros;
		this.tiposDireccion = tiposDireccion;
		this.direccion = direccion;
		this.numero = numero;
		this.escalera = escalera;
		this.piso = piso;
		this.letra = letra;
		this.codigoPostal = codigoPostal;
		this.idPais = idPais;
		this.idProvincia = idProvincia;
		this.idMunicipio = idMunicipio;
		this.idLocalidad = idLocalidad;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.descProvinciaExtranjera = descProvinciaExtranjera;
		this.descCiudadExtranjera = descCiudadExtranjera;
		this.provinciadso = provinciadso;
		this.municipiodso = municipiodso;
		this.localidaddso = localidaddso;
		this.paisdso = paisDso;
		// aki snts
		String direccionAux = "";
		if (direccion != null) {
			direccionAux = direccion;
		}

		if (numero != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + " " + numero;
			} else {
				direccionAux = numero;
			}
		}

		if (escalera != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + escalera;
			} else {
				direccionAux = escalera;
			}
		}

		if (piso != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + piso;
			} else {
				direccionAux = piso;
			}
		}

		if (letra != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + letra;
			} else {
				direccionAux = letra;
			}
		}

		if (municipiodso != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + " (" + municipiodso + ")";
			} else {
				direccionAux = municipiodso;
			}
		}

		this.direccionCompuesta = direccionAux;
	}

	public DatosDirecciones(Integer idDireccion, String direccion, String codigoPostal, Long idProvincia,
			Long idMunicipio, Long idLocalidad, TiposDireccion tiposDireccion, String provinciadso, String municipiodso,
			String localidaddso, String numero, String escalera, String piso, String letra) {
		this.idDireccion = idDireccion;
		this.tiposDireccion = tiposDireccion;
		this.direccion = direccion;
		this.codigoPostal = codigoPostal;
		this.idProvincia = idProvincia;
		this.idMunicipio = idMunicipio;
		this.idLocalidad = idLocalidad;
		this.provinciadso = provinciadso;
		this.municipiodso = municipiodso;
		this.localidaddso = localidaddso;
		this.numero = numero;
		this.escalera = escalera;
		this.piso = piso;
		this.letra = letra;

		String direccionAux = "";
		if (direccion != null) {
			direccionAux = direccion;
		}

		if (numero != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + " " + numero;
			} else {
				direccionAux = numero;
			}
		}

		if (escalera != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + escalera;
			} else {
				direccionAux = escalera;
			}
		}

		if (piso != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + piso;
			} else {
				direccionAux = piso;
			}
		}

		if (letra != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + ", " + letra;
			} else {
				direccionAux = letra;
			}
		}

		if (municipiodso != null) {
			if (!"".equals(direccionAux)) {
				direccionAux = direccionAux + " (" + municipiodso + ")";
			} else {
				direccionAux = municipiodso;
			}
		}

		this.direccionCompuesta = direccionAux;
	}

	public Integer getIdDireccion() {
		return this.idDireccion;
	}

	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	public DatosTerceros getDatosTerceros() {
		return this.datosTerceros;
	}

	public void setDatosTerceros(DatosTerceros datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

	public TiposDireccion getTiposDireccion() {
		return this.tiposDireccion;
	}

	public void setTiposDireccion(TiposDireccion tiposDireccion) {
		this.tiposDireccion = tiposDireccion;
	}


	public String getDireccion() {
		return this.direccion;
	}

	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	public String getNumero() {
		return this.numero;
	}

	public void setNumero(String numero) {
		this.numero = numero;
	}

	public String getEscalera() {
		return this.escalera;
	}

	public void setEscalera(String escalera) {
		this.escalera = escalera;
	}

	public String getPiso() {
		return this.piso;
	}

	public void setPiso(String piso) {
		this.piso = piso;
	}

	public String getLetra() {
		return this.letra;
	}

	public void setLetra(String letra) {
		this.letra = letra;
	}

	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}
	
	public Long getIdProvincia() {
		return this.idProvincia;
	}

	public String getIdProvinciaPad() {
		if (this.idProvincia == null || this.idProvincia == 0)
			return "";
		return String.format("%02d", this.idProvincia);
	}

	public String getIdLocalidadPad() {
		if (this.idLocalidad == null || this.idLocalidad == 0)
			return "";
		return String.format("%015d", this.idLocalidad);
	}

	public void setIdProvincia(Long idProvincia) {
		this.idProvincia = idProvincia;
	}

	public Long getIdMunicipio() {
		return this.idMunicipio;
	}

	public String getIdMunicipioPad() {
		if (this.idMunicipio == null || this.idMunicipio == 0)
			return "";
		return String.format("%03d", this.idMunicipio);
	}

	public void setIdMunicipio(Long idMunicipio) {
		this.idMunicipio = idMunicipio;
	}
	
	public Long getIdLocalidad() {
		return this.idLocalidad;
	}

	public void setIdLocalidad(Long idLocalidad) {
		this.idLocalidad = idLocalidad;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public String getEstablecimiento() {
		return establecimiento;
	}

	public void setEstablecimiento(String establecimiento) {
		this.establecimiento = establecimiento;
	}

	public String getIdentificadorEstablecimiento() {
		return identificadorEstablecimiento;
	}

	public void setIdentificadorEstablecimiento(String identificadorEstablecimiento) {
		this.identificadorEstablecimiento = identificadorEstablecimiento;
	}

	public String getPaisdso() {
		return paisdso;
	}

	public void setPaisdso(String paisdso) {
		this.paisdso = paisdso;
	}

	public String getProvinciadso() {
		return provinciadso;
	}

	public void setProvinciadso(String provinciadso) {
		this.provinciadso = provinciadso;
	}

	public String getMunicipiodso() {
		return municipiodso;
	}

	public void setMunicipiodso(String municipiodso) {
		this.municipiodso = municipiodso;
	}

	public String getLocalidaddso() {
		return localidaddso;
	}

	public void setLocalidaddso(String localidaddso) {
		this.localidaddso = localidaddso;
	}

	public void setTipoEstablecimiento() {
		this.tiposDireccion = new TiposDireccion((long) Constantes.ID_TIPO_DIRECCION_ESTABLECIMIENTO_EXPEDIENTE);
	}

	public Long getIdPais() {
		return idPais;
	}

	public String getIdPaisPad() {
		if (this.idPais == null || this.idPais == 0)
			return "";
		return String.format("%03d", this.idPais);
	}

	public void setIdPais(Long idPais) {
		this.idPais = idPais;
	}

	public String getDescProvinciaExtranjera() {
		return descProvinciaExtranjera;
	}

	public void setDescProvinciaExtranjera(String descProvinciaExtranjera) {
		this.descProvinciaExtranjera = descProvinciaExtranjera;
	}

	public String getDescCiudadExtranjera() {
		return descCiudadExtranjera;
	}

	public void setDescCiudadExtranjera(String descCiudadExtranjera) {
		this.descCiudadExtranjera = descCiudadExtranjera;
	}

	public String getDireccionCompuesta() {
		return direccionCompuesta;
	}

	public void setDireccionCompuesta(String direccionCompuesta) {
		this.direccionCompuesta = direccionCompuesta;
	}

	public String getNumeroExtranjeraAgencia() {
		return numero;
	}

	public void setNumeroExtranjeraAgencia(String numeroExtranjeraAgencia) {
		this.numero = numeroExtranjeraAgencia;
	}

	public String getPisoExtranjeraAgencia() {
		return piso;
	}

	public void setPisoExtranjeraAgencia(String pisoExtranjeraAgencia) {
		this.piso = pisoExtranjeraAgencia;
	}

	public String getLetraExtranjeraAgencia() {
		return letra;
	}

	public void setLetraExtranjeraAgencia(String letraExtranjeraAgencia) {
		this.letra = letraExtranjeraAgencia;
	}

	public String getCodigoPostalExtranjeraAgencia() {
		return codigoPostal;
	}

	public void setCodigoPostalExtranjeraAgencia(String codigoPostalExtranjeraAgencia) {
		this.codigoPostal = codigoPostalExtranjeraAgencia;
	}

	public Long getIdPaisExtranjeraAgencia() {
		return idPais;
	}

	public void setIdPaisExtranjeraAgencia(Long idPaisExtranjeraAgencia) {
		this.idPais = idPaisExtranjeraAgencia;
	}

	public Integer getIdExpediente() {
		return idExpediente;
	}

	public void setIdExpediente(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "DatosDirecciones [idDireccion=" + idDireccion + ", datosTerceros=" + datosTerceros + ", tiposDireccion="
				+ tiposDireccion + ", direccion=" + direccion + ", numero=" + numero + ", escalera=" + escalera
				+ ", piso=" + piso + ", letra=" + letra + ", codigoPostal=" + codigoPostal + ", idProvincia="
				+ idProvincia + ", idMunicipio=" + idMunicipio + ", idLocalidad=" + idLocalidad + ", fechaRegistro="
				+ fechaRegistro + ", usuarioRegistro=" + usuarioRegistro + ", fechaUltmodificacion="
				+ fechaUltmodificacion + ", usuarioUltmodificacion=" + usuarioUltmodificacion + ", establecimiento="
				+ establecimiento + "]";
	}

}
