package com.ejie.ab78.model.terceros;

import java.util.Date;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class CanalesAviso implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idCanalAviso;
	private DatosTerceros datosTerceros;
	private TiposCanalAviso tiposCanalAviso;

	private String canalAviso;
	private Date fechaRegistro;
	private String usuarioRegistro;

	/**
	 * Method 'CanalesAviso'.
	 */
	public CanalesAviso() {
	}

	/**
	 * Method 'CanalesAviso'.
	 * 
	 * @param idCanalAviso
	 *            Integer
	 */
	public CanalesAviso(Integer idCanalAviso) {
		this.idCanalAviso = idCanalAviso;
	}

	/**
	 * Method 'CanalesAviso'.
	 * 
	 * @param idCanalAviso
	 *            Integer
	 * @param canalAviso
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param terceros
	 *            Terceros
	 * @param tiposCanalAviso
	 *            TiposCanalAviso
	 * @param empresas
	 *            Empresas
	 */
	public CanalesAviso(Integer idCanalAviso, String canalAviso, Date fechaRegistro, String usuarioRegistro,
			DatosTerceros datosTerceros, TiposCanalAviso tiposCanalAviso) {

		this.idCanalAviso = idCanalAviso;

		this.tiposCanalAviso = tiposCanalAviso;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.datosTerceros = datosTerceros;
		this.canalAviso = canalAviso;

	}

	/**
	 * Method 'getIdCanalAviso'.
	 *
	 * @return Integer
	 */

	public Integer getIdCanalAviso() {
		return this.idCanalAviso;
	}

	/**
	 * Method 'setIdCanalAviso'.
	 *
	 * @param idCanalAviso
	 *            Integer
	 * @return
	 */

	public void setIdCanalAviso(Integer idCanalAviso) {
		this.idCanalAviso = idCanalAviso;
	}

	/**
	 * Method 'getTiposCanalAviso'.
	 *
	 * @return TiposCanalAviso
	 */
	@JsonIgnore

	public TiposCanalAviso getTiposCanalAviso() {
		return this.tiposCanalAviso;
	}

	/**
	 * Method 'setTiposCanalAviso'.
	 *
	 * @param tiposCanalAviso
	 *            TiposCanalAviso
	 * @return
	 */

	public void setTiposCanalAviso(TiposCanalAviso tiposCanalAviso) {
		this.tiposCanalAviso = tiposCanalAviso;
	}

	/**
	 * Method 'getCanalAviso'.
	 *
	 * @return String
	 */

	public String getCanalAviso() {
		return this.canalAviso;
	}

	/**
	 * Method 'setCanalAviso'.
	 *
	 * @param canalAviso
	 *            String
	 * @return
	 */

	public void setCanalAviso(String canalAviso) {
		this.canalAviso = canalAviso;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idCanalAviso: ").append(this.idCanalAviso).append(" ]");
		result.append(", [ canalAviso: ").append(this.canalAviso).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @return the datosTerceros
	 */
	public DatosTerceros getDatosTerceros() {
		return datosTerceros;
	}

	/**
	 * @param datosTerceros
	 *            the datosTerceros to set
	 */
	public void setDatosTerceros(DatosTerceros datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

}
