package com.ejie.ab78.model.procedimientos;

import java.util.Date;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Procedimientos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idProcedimiento;
	private Direcciones direcciones;
	private Areas areas;
	private String descripcionEs;
	private String descripcionEu;
	private String codProcedureId;
	private String camposTituloExpediente;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private String inspeccionable;

	private Integer tipoDenuncia;

	/**
	 * Method 'Procedimientos'.
	 */
	public Procedimientos() {
	}

	/**
	 * Method 'Procedimientos'.
	 * 
	 * @param idProcedimiento
	 *            Integer
	 */
	public Procedimientos(Integer idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}

	/**
	 * Method 'Procedimientos'.
	 * 
	 * @param idProcedimiento
	 *            Integer
	 * @param codProcedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param folderNumber
	 *            String
	 * @param camposTituloExpediente
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param direcciones
	 *            Direcciones
	 * @param areas
	 *            Areas
	 * @param inspeccionable
	 */
	public Procedimientos(Integer idProcedimiento, String codProcedureId, String camposTituloExpediente,
			Date fechaRegistro, String usuarioRegistro, Direcciones direcciones, Areas areas) {

		this.idProcedimiento = idProcedimiento;
		this.direcciones = direcciones;
		this.areas = areas;
		this.codProcedureId = codProcedureId;
		this.camposTituloExpediente = camposTituloExpediente;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;

	}

	public Procedimientos(Integer idProcedimiento, String codProcedureId, String camposTituloExpediente,
			Date fechaRegistro, String usuarioRegistro, Direcciones direcciones, Areas areas, String descripcionEs,
			String descripcionEu, String inspeccionable) {

		this.idProcedimiento = idProcedimiento;
		this.direcciones = direcciones;
		this.areas = areas;
		this.codProcedureId = codProcedureId;
		this.camposTituloExpediente = camposTituloExpediente;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;
		this.inspeccionable = inspeccionable;
	}

	public String getDescripcionEsLabel() {
		if (descripcionEs != null) {
			StringBuilder builder = new StringBuilder();
			builder.append("(").append(this.codProcedureId).append(") ").append(descripcionEs);
			return builder.toString();
		}
		return descripcionEs;
	}

	public String getDescripcionEuLabel() {
		if (descripcionEu != null) {
			StringBuilder builder = new StringBuilder();
			builder.append("(").append(this.codProcedureId).append(") ").append(descripcionEu);
			return builder.toString();
		}
		return descripcionEu;
	}

	/**
	 * Method 'getIdProcedimiento'.
	 *
	 * @return Integer
	 */

	public Integer getIdProcedimiento() {
		return this.idProcedimiento;
	}

	/**
	 * Method 'setIdProcedimiento'.
	 *
	 * @param idProcedimiento
	 *            Integer
	 * @return
	 */

	public void setIdProcedimiento(Integer idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}

	/**
	 * Method 'getDirecciones'.
	 *
	 * @return Direcciones
	 */
	@JsonIgnore

	public Direcciones getDirecciones() {
		return this.direcciones;
	}

	/**
	 * Method 'setDirecciones'.
	 *
	 * @param direcciones
	 *            Direcciones
	 * @return
	 */

	public void setDirecciones(Direcciones direcciones) {
		this.direcciones = direcciones;
	}

	/**
	 * Method 'getAreas'.
	 *
	 * @return Areas
	 */
	@JsonIgnore

	public Areas getAreas() {
		return this.areas;
	}

	/**
	 * Method 'setAreas'.
	 *
	 * @param areas
	 *            Areas
	 * @return
	 */

	public void setAreas(Areas areas) {
		this.areas = areas;
	}

	/**
	 * Method 'getCodProcedureId'.
	 *
	 * @return String
	 */

	public String getCodProcedureId() {
		return this.codProcedureId;
	}

	/**
	 * Method 'setCodProcedureId'.
	 *
	 * @param codProcedureId
	 *            String
	 * @return
	 */

	public void setCodProcedureId(String codProcedureId) {
		this.codProcedureId = codProcedureId;
	}

	/**
	 * Method 'getCamposTituloExpediente'.
	 *
	 * @return String
	 */

	public String getCamposTituloExpediente() {
		return this.camposTituloExpediente;
	}

	/**
	 * Method 'setCamposTituloExpediente'.
	 *
	 * @param camposTituloExpediente
	 *            String
	 * @return
	 */

	public void setCamposTituloExpediente(String camposTituloExpediente) {
		this.camposTituloExpediente = camposTituloExpediente;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	public String getDescripcionEs() {
		return descripcionEs;
	}

	public void setDescripcionEs(String descripcionEs) {
		this.descripcionEs = descripcionEs;
	}

	public String getDescripcionEu() {
		return descripcionEu;
	}

	public void setDescripcionEu(String descripcionEu) {
		this.descripcionEu = descripcionEu;
	}

	public String getInspeccionable() {
		return inspeccionable;
	}

	public void setInspeccionable(String inspeccionable) {
		this.inspeccionable = inspeccionable;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idProcedimiento: ").append(this.idProcedimiento).append(" ]");
		result.append(", [ codProcedureId: ").append(this.codProcedureId).append(" ]");
		result.append(", [ camposTituloExpediente: ").append(this.camposTituloExpediente).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

	public String getTituloProcedimientoCompletoEs() {
		return this.codProcedureId + " - " + this.descripcionEs;
	}

	public String getTituloProcedimientoCompletoEu() {
		return this.codProcedureId + " - " + this.descripcionEu;
	}

	public Integer getTipoDenuncia() {
		return tipoDenuncia;
	}

	public void setTipoDenuncia(Integer tipoDenuncia) {
		this.tipoDenuncia = tipoDenuncia;
	}

}
