package com.ejie.ab78.model.procedimientos;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Direcciones implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDireccion;
	private Departamentos departamentos;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<Procedimientos> procedimientoses = new ArrayList<Procedimientos>();
	private List<Areas> areases = new ArrayList<Areas>();

	/**
	 * Method 'Direcciones'.
	 */
	public Direcciones() {
	}

	/**
	 * Method 'Direcciones'.
	 * 
	 * @param idDireccion
	 *            Integer
	 */
	public Direcciones(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	/**
	 * Method 'Direcciones'.
	 * 
	 * @param idDireccion
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param departamentos
	 *            Departamentos
	 */
	public Direcciones(Integer idDireccion, String descripcionCastellano, String descripcionEuskera, Date fechaRegistro,
			String usuarioRegistro, Departamentos departamentos) {
		this.idDireccion = idDireccion;
		this.departamentos = departamentos;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'Direcciones'.
	 * 
	 * @param idDireccion
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param departamentos
	 *            Departamentos
	 * @param procedimientoses
	 *            List<Procedimientos>
	 * @param areases
	 *            List<Areas>
	 */
	public Direcciones(Integer idDireccion, String descripcionCastellano, String descripcionEuskera, Date fechaRegistro,
			String usuarioRegistro, Departamentos departamentos, List<Procedimientos> procedimientoses,
			List<Areas> areases) {

		this.idDireccion = idDireccion;
		this.departamentos = departamentos;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.procedimientoses = procedimientoses;
		this.areases = areases;
	}

	/**
	 * Method 'getIdDireccion'.
	 *
	 * @return Integer
	 */

	public Integer getIdDireccion() {
		return this.idDireccion;
	}

	/**
	 * Method 'setIdDireccion'.
	 *
	 * @param idDireccion
	 *            Integer
	 * @return
	 */

	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	/**
	 * Method 'getDepartamentos'.
	 *
	 * @return Departamentos
	 */

	public Departamentos getDepartamentos() {
		return this.departamentos;
	}

	/**
	 * Method 'setDepartamentos'.
	 *
	 * @param departamentos
	 *            Departamentos
	 * @return
	 */

	public void setDepartamentos(Departamentos departamentos) {
		this.departamentos = departamentos;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getProcedimientoses'.
	 *
	 * @return List
	 */
	public List<Procedimientos> getProcedimientoses() {
		return this.procedimientoses;
	}

	/**
	 * Method 'setProcedimientoses'.
	 *
	 * @param procedimientoses
	 *            List
	 * @return
	 */
	public void setProcedimientoses(List<Procedimientos> procedimientoses) {
		this.procedimientoses = procedimientoses;
	}

	/**
	 * Method 'getAreases'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Areas> getAreases() {
		return this.areases;
	}

	/**
	 * Method 'setAreases'.
	 *
	 * @param areases
	 *            List
	 * @return
	 */
	public void setAreases(List<Areas> areases) {
		this.areases = areases;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idDireccion: ").append(this.idDireccion).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
