package com.ejie.ab78.model.procedimientos;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Departamentos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDepartamento;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<Direcciones> direccioneses = new ArrayList<Direcciones>();

	/**
	 * Method 'Departamentos'.
	 */
	public Departamentos() {
	}

	/**
	 * Method 'Departamentos'.
	 * 
	 * @param idDepartamento
	 *            Integer
	 */
	public Departamentos(Integer idDepartamento) {
		this.idDepartamento = idDepartamento;
	}

	/**
	 * Method 'Departamentos'.
	 * 
	 * @param idDepartamento
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 */
	public Departamentos(Integer idDepartamento, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro) {
		this.idDepartamento = idDepartamento;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'Departamentos'.
	 * 
	 * @param idDepartamento
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param direccioneses
	 *            List<Direcciones>
	 */
	public Departamentos(Integer idDepartamento, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro, List<Direcciones> direccioneses) {

		this.idDepartamento = idDepartamento;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.direccioneses = direccioneses;
	}

	/**
	 * Method 'getIdDepartamento'.
	 *
	 * @return Integer
	 */

	public Integer getIdDepartamento() {
		return this.idDepartamento;
	}

	/**
	 * Method 'setIdDepartamento'.
	 *
	 * @param idDepartamento
	 *            Integer
	 * @return
	 */

	public void setIdDepartamento(Integer idDepartamento) {
		this.idDepartamento = idDepartamento;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getDireccioneses'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Direcciones> getDireccioneses() {
		return this.direccioneses;
	}

	/**
	 * Method 'setDireccioneses'.
	 *
	 * @param direccioneses
	 *            List
	 * @return
	 */
	public void setDireccioneses(List<Direcciones> direccioneses) {
		this.direccioneses = direccioneses;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idDepartamento: ").append(this.idDepartamento).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
