package com.ejie.ab78.model.procedimientos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompareExpedienteSection implements Comparable<CompareExpedienteSection> {

	private Integer idSection;
	private String nameSection;
	private Boolean isNewElement = false;
	private Integer priority;

	private String tipoSection;

	private List<FieldExpedienteCompare> listFields;

	public CompareExpedienteSection(String tipoSeccion, Integer priority) {
		this.setTipoSection(tipoSeccion);
		this.setPriority(priority);
		this.setListFields(new ArrayList<FieldExpedienteCompare>());
	}

	public String getTipoSection() {
		return tipoSection;
	}

	public void setTipoSection(String tipoSection) {
		this.tipoSection = tipoSection;
	}

	public List<FieldExpedienteCompare> getListFields() {
		return listFields;
	}

	public void setListFields(List<FieldExpedienteCompare> listCompares) {
		this.listFields = listCompares;
	}

	public boolean isHasChanges() {
		boolean hasChanges = false;
		for (Iterator<FieldExpedienteCompare> iterator = listFields.iterator(); iterator.hasNext() && !hasChanges;) {
			FieldExpedienteCompare field = iterator.next();
			hasChanges = field.isHasChanges();
		}
		return hasChanges;
	}

	public Integer getIdSection() {
		return idSection;
	}

	public void setIdSection(Integer idSection) {
		this.idSection = idSection;
	}

	public String getNameSection() {
		return nameSection;
	}

	public void setNameSection(String nameSection) {
		this.nameSection = nameSection;
	}

	public boolean isNewElement() {
		return isNewElement;
	}

	public void setNewElement(boolean isNewElement) {
		this.isNewElement = isNewElement;
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	@Override
	public int compareTo(CompareExpedienteSection o) {
		return priority - o.getPriority();
	}
}
