package com.ejie.ab78.model.procedimientos;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Areas implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idArea;
	private Direcciones direcciones;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<Procedimientos> procedimientoses = new ArrayList<Procedimientos>();

	/**
	 * Method 'Areas'.
	 */
	public Areas() {
	}

	/**
	 * Method 'Areas'.
	 * 
	 * @param idArea
	 *            Integer
	 */
	public Areas(Integer idArea) {
		this.idArea = idArea;
	}

	/**
	 * Method 'Areas'.
	 * 
	 * @param idArea
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param direcciones
	 *            Direcciones
	 */
	public Areas(Integer idArea, String descripcionCastellano, String descripcionEuskera, Date fechaRegistro,
			String usuarioRegistro, Direcciones direcciones) {
		this.idArea = idArea;
		this.direcciones = direcciones;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'Areas'.
	 * 
	 * @param idArea
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param direcciones
	 *            Direcciones
	 * @param procedimientoses
	 *            List<Procedimientos>
	 */
	public Areas(Integer idArea, String descripcionCastellano, String descripcionEuskera, Date fechaRegistro,
			String usuarioRegistro, Direcciones direcciones, List<Procedimientos> procedimientoses) {

		this.idArea = idArea;
		this.direcciones = direcciones;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.procedimientoses = procedimientoses;
	}

	/**
	 * Method 'getIdArea'.
	 *
	 * @return Integer
	 */

	public Integer getIdArea() {
		return this.idArea;
	}

	/**
	 * Method 'setIdArea'.
	 *
	 * @param idArea
	 *            Integer
	 * @return
	 */

	public void setIdArea(Integer idArea) {
		this.idArea = idArea;
	}

	/**
	 * Method 'getDirecciones'.
	 *
	 * @return Direcciones
	 */
	@JsonIgnore

	public Direcciones getDirecciones() {
		return this.direcciones;
	}

	/**
	 * Method 'setDirecciones'.
	 *
	 * @param direcciones
	 *            Direcciones
	 * @return
	 */

	public void setDirecciones(Direcciones direcciones) {
		this.direcciones = direcciones;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getProcedimientoses'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Procedimientos> getProcedimientoses() {
		return this.procedimientoses;
	}

	/**
	 * Method 'setProcedimientoses'.
	 *
	 * @param procedimientoses
	 *            List
	 * @return
	 */
	public void setProcedimientoses(List<Procedimientos> procedimientoses) {
		this.procedimientoses = procedimientoses;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idArea: ").append(this.idArea).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
