package com.ejie.ab78.model.plantillas;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * TiposPlantilla  
 * 
 *  
 */

public class TiposPlantilla implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idTipoPlantilla;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private String taskId;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private List<Plantillas> plantillases = new ArrayList<Plantillas>();

	/**
	 * Method 'TiposPlantilla'.
	 */
	public TiposPlantilla() {
	}

	/**
	 * Method 'TiposPlantilla'.
	 * 
	 * @param idTipoPlantilla
	 *            Long
	 */
	public TiposPlantilla(Long idTipoPlantilla) {
		this.idTipoPlantilla = idTipoPlantilla;
	}

	/**
	 * Method 'TiposPlantilla'.
	 * 
	 * @param idTipoPlantilla
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 */
	public TiposPlantilla(Long idTipoPlantilla, String descripcionCastellano, String descripcionEuskera, String taskId,
			Date fechaRegistro, String usuarioRegistro) {
		this.idTipoPlantilla = idTipoPlantilla;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.taskId = taskId;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'TiposPlantilla'.
	 * 
	 * @param idTipoPlantilla
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param plantillases
	 *            List<Plantillas>
	 */
	public TiposPlantilla(Long idTipoPlantilla, String descripcionCastellano, String descripcionEuskera,
			Date fechaRegistro, String usuarioRegistro, List<Plantillas> plantillases) {

		this.idTipoPlantilla = idTipoPlantilla;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.plantillases = plantillases;
	}

	/**
	 * Method 'getIdTipoPlantilla'.
	 *
	 * @return Long
	 */

	public Long getIdTipoPlantilla() {
		return this.idTipoPlantilla;
	}

	/**
	 * Method 'setIdTipoPlantilla'.
	 *
	 * @param idTipoPlantilla
	 *            Long
	 * @return
	 */

	public void setIdTipoPlantilla(Long idTipoPlantilla) {
		this.idTipoPlantilla = idTipoPlantilla;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getPlantillases'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Plantillas> getPlantillases() {
		return this.plantillases;
	}

	/**
	 * Method 'setPlantillases'.
	 *
	 * @param plantillases
	 *            List
	 * @return
	 */
	public void setPlantillases(List<Plantillas> plantillases) {
		this.plantillases = plantillases;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoPlantilla: ").append(this.idTipoPlantilla).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append("}");
		return result.toString();
	}

}
