package com.ejie.ab78.model.plantillas;

import java.util.Date;

import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Plantillas  
 * 
 *  
 */

public class Plantillas implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idPlantilla;
	private TiposPlantilla tiposPlantilla;
	private Procedimientos procedimientos;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private String observaciones;
	private Integer Origen;

	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;

	private String campos;
	private String multicomboRemoto;
	private Integer tienePlantilla;

	private Documentos documento;

	private RelExpPla relExpPla;
	private String rutaDocumento;

	/**
	 * Method 'Plantillas'.
	 */
	public Plantillas() {
	}

	/**
	 * Method 'Plantillas'.
	 * 
	 * @param idPlantilla
	 *            Integer
	 */
	public Plantillas(Integer idPlantilla) {
		this.idPlantilla = idPlantilla;
	}

	/**
	 * Method 'Plantillas'.
	 * 
	 * @param idPlantilla
	 *            Integer
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param observaciones
	 *            String
	 * @param docPlantilla
	 *            Blob
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @param procedimientos
	 *            Procedimientos
	 */
	public Plantillas(Integer idPlantilla, String descripcionCastellano, String descripcionEuskera,
			String observaciones, Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion,
			String usuarioUltmodificacion, Documentos documento, RelExpPla relExpPla, TiposPlantilla tiposPlantilla,
			Procedimientos procedimientos) {

		this.idPlantilla = idPlantilla;
		this.tiposPlantilla = tiposPlantilla;
		this.procedimientos = procedimientos;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.observaciones = observaciones;

		this.documento = documento;
		this.relExpPla = relExpPla;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;

	}

	/**
	 * Method 'getIdPlantilla'.
	 *
	 * @return Integer
	 */

	public Integer getIdPlantilla() {
		return this.idPlantilla;
	}

	/**
	 * Method 'setIdPlantilla'.
	 *
	 * @param idPlantilla
	 *            Integer
	 * @return
	 */

	public void setIdPlantilla(Integer idPlantilla) {
		this.idPlantilla = idPlantilla;
	}

	/**
	 * @return the relExpPla
	 */
	public RelExpPla getRelExpPla() {
		return relExpPla;
	}

	/**
	 * @param relExpPla
	 *            the relExpPla to set
	 */
	public void setRelExpPla(RelExpPla relExpPla) {
		this.relExpPla = relExpPla;
	}

	/**
	 * Method 'getTiposPlantilla'.
	 *
	 * @return TiposPlantilla
	 */

	public TiposPlantilla getTiposPlantilla() {
		return this.tiposPlantilla;
	}

	/**
	 * Method 'setTiposPlantilla'.
	 *
	 * @param tiposPlantilla
	 *            TiposPlantilla
	 * @return
	 */

	public void setTiposPlantilla(TiposPlantilla tiposPlantilla) {
		this.tiposPlantilla = tiposPlantilla;
	}

	/**
	 * Method 'getProcedimientos'.
	 *
	 * @return Procedimientos
	 */

	public Procedimientos getProcedimientos() {
		return this.procedimientos;
	}

	/**
	 * Method 'setProcedimientos'.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return
	 */

	public void setProcedimientos(Procedimientos procedimientos) {
		this.procedimientos = procedimientos;
	}

	/**
	 * Method 'getDescripcionCastellano'.
	 *
	 * @return String
	 */

	public String getDescripcionCastellano() {
		return this.descripcionCastellano;
	}

	/**
	 * Method 'setDescripcionCastellano'.
	 *
	 * @param descripcionCastellano
	 *            String
	 * @return
	 */

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * Method 'getDescripcionEuskera'.
	 *
	 * @return String
	 */

	public String getDescripcionEuskera() {
		return this.descripcionEuskera;
	}

	/**
	 * Method 'setDescripcionEuskera'.
	 *
	 * @param descripcionEuskera
	 *            String
	 * @return
	 */

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * Method 'getObservaciones'.
	 *
	 * @return String
	 */

	public String getObservaciones() {
		return this.observaciones;
	}

	/**
	 * Method 'setObservaciones'.
	 *
	 * @param observaciones
	 *            String
	 * @return
	 */

	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	public Integer getOrigen() {
		return Origen;
	}

	public void setOrigen(Integer origen) {
		Origen = origen;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * @return the campos
	 */
	public String getCampos() {
		return campos;
	}

	/**
	 * @param campos
	 *            the campos to set
	 */
	public void setCampos(String campos) {
		this.campos = campos;
	}

	public String getMulticomboRemoto() {
		return multicomboRemoto;
	}

	public void setMulticomboRemoto(String multicomboRemoto) {
		this.multicomboRemoto = multicomboRemoto;
	}

	/**
	 * @return the tienePlantilla
	 */
	public Integer getTienePlantilla() {
		return tienePlantilla;
	}

	/**
	 * @param tienePlantilla
	 *            the tienePlantilla to set
	 */
	public void setTienePlantilla(Integer tienePlantilla) {
		this.tienePlantilla = tienePlantilla;
	}

	/**
	 * @return the documento
	 */
	public Documentos getDocumento() {
		return documento;
	}

	/**
	 * @param documento
	 *            the documento to set
	 */
	public void setDocumento(Documentos documento) {
		this.documento = documento;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Plantillas [idPlantilla=" + idPlantilla + ", tiposPlantilla=" + tiposPlantilla + ", procedimientos="
				+ procedimientos + ", descripcionCastellano=" + descripcionCastellano + ", descripcionEuskera="
				+ descripcionEuskera + ", observaciones=" + observaciones + ", fechaRegistro=" + fechaRegistro
				+ ", usuarioRegistro=" + usuarioRegistro + ", fechaUltmodificacion=" + fechaUltmodificacion
				+ ", usuarioUltmodificacion=" + usuarioUltmodificacion + ", campos=" + campos + ", multicomboRemoto="
				+ multicomboRemoto + ", tienePlantilla=" + tienePlantilla + ", documento=" + documento + ", relExpPla="
				+ relExpPla + "]";
	}

	public String getRutaDocumento() {
		return rutaDocumento;
	}

	public void setRutaDocumento(String rutaDocumento) {
		this.rutaDocumento = rutaDocumento;
	}

}
