package com.ejie.ab78.model.plantillas;

import java.sql.Blob;
import java.util.Date;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Documentos  
 * 
 *  
 */

public class Documentos implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDocumento;
	private String nombreDocumento;
	private String nombreArchivo;
	private Blob archivo;
	private String observaciones;

	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private Integer idioma;

	/**
	 * Method 'Documentos'.
	 */
	public Documentos() {
	}

	/**
	 * Method 'Documentos'.
	 * 
	 * @param idDocumento
	 *            Integer
	 */
	public Documentos(Integer idDocumento) {
		this.idDocumento = idDocumento;
	}

	/**
	 * Method 'Documentos'.
	 * 
	 * @param idDocumento
	 *            Integer
	 * @param nombreDocumento
	 *            String
	 * @param nombreArchivo
	 *            String
	 * @param archivo
	 *            Blob
	 * @param observaciones
	 *            String
	 * @param tareaId
	 *            String
	 * @param proceedingId
	 *            String
	 * @param taskType
	 *            String
	 * @param title
	 *            String
	 * @param author
	 *            String
	 * @param documentroleId
	 *            String
	 * @param documentroleNameCas
	 *            String
	 * @param documentroleNameEus
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Documentos(Integer idDocumento, String nombreDocumento, String nombreArchivo, Blob archivo,
			String observaciones, Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion,
			String usuarioUltmodificacion) {

		this.idDocumento = idDocumento;
		this.nombreDocumento = nombreDocumento;
		this.nombreArchivo = nombreArchivo;
		this.archivo = archivo;
		this.observaciones = observaciones;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdDocumento'.
	 *
	 * @return Integer
	 */

	public Integer getIdDocumento() {
		return this.idDocumento;
	}

	/**
	 * Method 'setIdDocumento'.
	 *
	 * @param idDocumento
	 *            Integer
	 * @return
	 */

	public void setIdDocumento(Integer idDocumento) {
		this.idDocumento = idDocumento;
	}

	/**
	 * Method 'getNombreDocumento'.
	 *
	 * @return String
	 */

	public String getNombreDocumento() {
		return this.nombreDocumento;
	}

	/**
	 * Method 'setNombreDocumento'.
	 *
	 * @param nombreDocumento
	 *            String
	 * @return
	 */

	public void setNombreDocumento(String nombreDocumento) {
		this.nombreDocumento = nombreDocumento;
	}

	/**
	 * Method 'getNombreArchivo'.
	 *
	 * @return String
	 */

	public String getNombreArchivo() {
		return this.nombreArchivo;
	}

	/**
	 * Method 'setNombreArchivo'.
	 *
	 * @param nombreArchivo
	 *            String
	 * @return
	 */

	public void setNombreArchivo(String nombreArchivo) {
		this.nombreArchivo = nombreArchivo;
	}

	/**
	 * Method 'getArchivo'.
	 *
	 * @return Blob
	 */
	@JsonIgnore

	public Blob getArchivo() {
		return this.archivo;
	}

	/**
	 * Method 'setArchivo'.
	 *
	 * @param archivo
	 *            Blob
	 * @return
	 */

	public void setArchivo(Blob archivo) {
		this.archivo = archivo;
	}

	/**
	 * Method 'getObservaciones'.
	 *
	 * @return String
	 */

	public String getObservaciones() {
		return this.observaciones;
	}

	/**
	 * Method 'setObservaciones'.
	 *
	 * @param observaciones
	 *            String
	 * @return
	 */

	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	@Override
	public String toString() {
		return "Documentos [idDocumento=" + idDocumento + ", nombreDocumento=" + nombreDocumento + ", nombreArchivo="
				+ nombreArchivo + ", archivo=" + archivo + ", observaciones=" + observaciones + ", fechaRegistro="
				+ fechaRegistro + ", usuarioRegistro=" + usuarioRegistro + ", fechaUltmodificacion="
				+ fechaUltmodificacion + ", usuarioUltmodificacion=" + usuarioUltmodificacion + "]";
	}

	public Integer getIdioma() {
		return idioma;
	}

	public void setIdioma(Integer idioma) {
		this.idioma = idioma;
	}

}
