package com.ejie.ab78.model.maestros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * TipoReclamacion  
 * 
 *  
 */

public class TipoReclamacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idTipoReclamacion;
	private String descTipoEs;
	private String descTipoEu;
	private Integer baja;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private List<Denuncia> denuncias = new ArrayList<Denuncia>();
	private Long idProcedimiento;

	/**
	 * Method 'TipoReclamacion'.
	 */
	public TipoReclamacion() {
	}

	/**
	 * Method 'TipoReclamacion'.
	 * 
	 * @param idTipoReclamacion
	 *            Long
	 */
	public TipoReclamacion(Long idTipoReclamacion) {
		this.idTipoReclamacion = idTipoReclamacion;
	}

	/**
	 * Method 'TipoReclamacion'.
	 * 
	 * @param idTipoReclamacion
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public TipoReclamacion(Long idTipoReclamacion, String descTipoEs, String descTipoEu, Integer baja,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {
		this.idTipoReclamacion = idTipoReclamacion;
		this.descTipoEs = descTipoEs;
		this.descTipoEu = descTipoEu;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'TipoReclamacion'.
	 * 
	 * @param idTipoReclamacion
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param denuncias
	 *            List<Denuncia>
	 */
	public TipoReclamacion(Long idTipoReclamacion, String descTipoEs, String descTipoEu, Integer baja,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			List<Denuncia> denuncias) {

		this.idTipoReclamacion = idTipoReclamacion;
		this.descTipoEs = descTipoEs;
		this.descTipoEu = descTipoEu;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.denuncias = denuncias;
	}

	/**
	 * Method 'getIdTipoReclamacion'.
	 *
	 * @return Long
	 */

	public Long getIdTipoReclamacion() {
		return this.idTipoReclamacion;
	}

	/**
	 * Method 'setIdTipoReclamacion'.
	 *
	 * @param idTipoReclamacion
	 *            Long
	 * @return
	 */

	public void setIdTipoReclamacion(Long idTipoReclamacion) {
		this.idTipoReclamacion = idTipoReclamacion;
	}

	/**
	 * Method 'getDescTipoEs'.
	 *
	 * @return String
	 */

	public String getDescTipoEs() {
		return this.descTipoEs;
	}

	/**
	 * Method 'setDescTipoEs'.
	 *
	 * @param descTipoEs
	 *            String
	 * @return
	 */

	public void setDescTipoEs(String descTipoEs) {
		this.descTipoEs = descTipoEs;
	}

	/**
	 * Method 'getDescTipoEu'.
	 *
	 * @return String
	 */

	public String getDescTipoEu() {
		return this.descTipoEu;
	}

	/**
	 * Method 'setDescTipoEu'.
	 *
	 * @param descTipoEu
	 *            String
	 * @return
	 */

	public void setDescTipoEu(String descTipoEu) {
		this.descTipoEu = descTipoEu;
	}

	/**
	 * Method 'getBaja'.
	 *
	 * @return Integer
	 */

	public Integer getBaja() {
		return this.baja;
	}

	/**
	 * Method 'setBaja'.
	 *
	 * @param baja
	 *            Integer
	 * @return
	 */

	public void setBaja(Integer baja) {
		this.baja = baja;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getAb7801s00s'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Denuncia> getAb7801s00s() {
		return this.denuncias;
	}

	/**
	 * Method 'setAb7801s00s'.
	 *
	 * @param denuncias
	 *            List
	 * @return
	 */
	public void setAb7801s00s(List<Denuncia> denuncias) {
		this.denuncias = denuncias;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoReclamacion: ").append(this.idTipoReclamacion).append(" ]");
		result.append(", [ descTipoEs: ").append(this.descTipoEs).append(" ]");
		result.append(", [ descTipoEu: ").append(this.descTipoEu).append(" ]");
		result.append(", [ baja: ").append(this.baja).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public Long getIdProcedimiento() {
		return idProcedimiento;
	}

	public void setIdProcedimiento(Long idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}
}
