package com.ejie.ab78.model.maestros;

import java.util.Date;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.ab78.comun.Constantes;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Ab6311s00  
 * 
 *  
 */

public class TipoEstablecimiento implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idTipoEstablecimiento;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private Integer baja;
	private String ordenacion;
	private String descOrdenacion;
	private String tipificacion;
	private String descTipificacion;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private String procedimientoLeyEs;
	private String procedimientoLeyEu;
	private String procedimientoDecretoEs;
	private String procedimientoDecretoEu;

	public TipoEstablecimiento() {
	}

	public TipoEstablecimiento(String idTipoEstablecimiento) {
		this.idTipoEstablecimiento = idTipoEstablecimiento;
	}

	public TipoEstablecimiento(String idTipoEstablecimiento, String descripcionCastellano, Integer baja, String descripcionEuskera, String ordenacion, String tipificacion,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			String procedimientoLeyEs, String procedimientoLeyEu, String procedimientoDecretoEs,
			String procedimientoDecretoEu) {
		this.idTipoEstablecimiento = idTipoEstablecimiento;
		this.descripcionCastellano = descripcionCastellano;
		this.baja = baja;
		this.descripcionEuskera = descripcionEuskera;
		this.ordenacion = ordenacion;
		this.tipificacion = tipificacion;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.procedimientoLeyEs = procedimientoLeyEs;
		this.procedimientoLeyEu = procedimientoLeyEu;
		this.procedimientoDecretoEs = procedimientoDecretoEs;
		this.procedimientoDecretoEu = procedimientoDecretoEu;
	}

	public TipoEstablecimiento(String idTipoEstablecimiento, String descripcionCastellano, Integer baja, String descripcionEuskera, String ordenacion, String tipificacion,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {

		this.idTipoEstablecimiento = idTipoEstablecimiento;
		this.descripcionCastellano = descripcionCastellano;
		this.baja = baja;
		this.descripcionEuskera = descripcionEuskera;
		this.ordenacion = ordenacion;
		this.tipificacion = tipificacion;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public String getIdTipoEstablecimiento() {
		return this.idTipoEstablecimiento;
	}

	public void setIdTipoEstablecimiento(String idTipoEstablecimiento) {
		this.idTipoEstablecimiento = idTipoEstablecimiento;
	}

	public Integer getBaja() {
		return this.baja;
	}

	public void setBaja(Integer baja) {
		this.baja = baja;
	}

	public String getDescripcionCastellano() {
		return descripcionCastellano;
	}

	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	public String getDescripcionEuskera() {
		return descripcionEuskera;
	}

	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	public String getOrdenacion() {
		return this.ordenacion;
	}

	public void setOrdenacion(String ordenacion) {
		this.ordenacion = ordenacion;
	}

	public String getTipificacion() {
		return this.tipificacion;
	}

	public void setTipificacion(String tipificacion) {
		this.tipificacion = tipificacion;
	}


	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public String getProcedimientoLeyEs() {
		return procedimientoLeyEs;
	}

	public void setProcedimientoLeyEs(String procedimientoLeyEs) {
		this.procedimientoLeyEs = procedimientoLeyEs;
	}

	public String getProcedimientoLeyEu() {
		return procedimientoLeyEu;
	}

	public void setProcedimientoLeyEu(String procedimientoLeyEu) {
		this.procedimientoLeyEu = procedimientoLeyEu;
	}

	public String getProcedimientoDecretoEs() {
		return procedimientoDecretoEs;
	}

	public void setProcedimientoDecretoEs(String procedimientoDecretoEs) {
		this.procedimientoDecretoEs = procedimientoDecretoEs;
	}

	public String getProcedimientoDecretoEu() {
		return procedimientoDecretoEu;
	}

	public void setProcedimientoDecretoEu(String procedimientoDecretoEu) {
		this.procedimientoDecretoEu = procedimientoDecretoEu;
	}

	public String getDescOrdenacion() {
		return descOrdenacion;
	}

	public void setDescOrdenacion(String descOrdenacion) {
		this.descOrdenacion = descOrdenacion;
	}

	public String getDescTipificacion() {
		return descTipificacion;
	}

	public void setDescTipificacion(String descTipificacion) {
		this.descTipificacion = descTipificacion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idTipoEstablecimiento: ").append(this.idTipoEstablecimiento).append(" ]");
		result.append(", [ descripcionCastellano: ").append(this.descripcionCastellano).append(" ]");
		result.append(", [ baja: ").append(this.baja).append(" ]");
		result.append(", [ descripcionEuskera: ").append(this.descripcionEuskera).append(" ]");
		result.append(", [ ordenacion: ").append(this.ordenacion).append(" ]");
		result.append(", [ tipificacion: ").append(this.tipificacion).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public String getDescripcionDecorator() {
		if (LocaleContextHolder.getLocale().getLanguage().equalsIgnoreCase(Constantes.CASTELLANO)) {
			return this.descripcionCastellano;
		} else {
			return this.descripcionEuskera;
		}
	}
}
