package com.ejie.ab78.model.maestros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Producto  
 * 
 *  
 */

public class Motivo implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idMotivo;
	private String descMotivoEs;
	private String descMotivoEu;
	private Integer baja;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private List<Denuncia> denuncias = new ArrayList<Denuncia>();
	private Long idProcedimiento;

	/**
	 * Method 'RelacionMotivoDen'.
	 */
	public Motivo() {
	}

	/**
	 * Method 'RelacionMotivoDen'.
	 * 
	 * @param idMotivo
	 *            Long
	 */
	public Motivo(Long idMotivo) {
		this.idMotivo = idMotivo;
	}

	/**
	 * Method 'RelacionMotivoDen'.
	 * 
	 * @param idMotivo
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Motivo(Long idMotivo, String descTipoEs, String descTipoEu, Integer baja, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {
		this.idMotivo = idMotivo;
		this.descMotivoEs = descTipoEs;
		this.descMotivoEu = descTipoEu;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'RelacionMotivoDen'.
	 * 
	 * @param idMotivo
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param denuncias
	 *            List<Denuncia>
	 */
	public Motivo(Long idMotivo, String descTipoEs, String descTipoEu, Integer baja, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			List<Denuncia> denuncias) {

		this.idMotivo = idMotivo;
		this.descMotivoEs = descTipoEs;
		this.descMotivoEu = descTipoEu;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.denuncias = denuncias;
	}

	/**
	 * Method 'getIdMotivo'.
	 *
	 * @return Long
	 */

	public Long getIdMotivo() {
		return this.idMotivo;
	}

	/**
	 * Method 'setIdMotivo'.
	 *
	 * @param idProducto
	 *            Long
	 * @return
	 */

	public void setIdMotivo(Long idMotivo) {
		this.idMotivo = idMotivo;
	}

	/**
	 * Method 'getDescTipoEs'.
	 *
	 * @return String
	 */

	public String getDescMotivoEs() {
		return this.descMotivoEs;
	}

	/**
	 * Method 'setDescTipoEs'.
	 *
	 * @param descTipoEs
	 *            String
	 * @return
	 */

	public void setDescMotivoEs(String descMotivoEs) {
		this.descMotivoEs = descMotivoEs;
	}

	/**
	 * Method 'getDescTipoEu'.
	 *
	 * @return String
	 */

	public String getDescMotivoEu() {
		return this.descMotivoEu;
	}

	/**
	 * Method 'setDescTipoEu'.
	 *
	 * @param descTipoEu
	 *            String
	 * @return
	 */

	public void setDescMotivoEu(String descMotivoEu) {
		this.descMotivoEu = descMotivoEu;
	}

	/**
	 * Method 'getBaja'.
	 *
	 * @return Integer
	 */

	public Integer getBaja() {
		return this.baja;
	}

	/**
	 * Method 'setBaja'.
	 *
	 * @param baja
	 *            Integer
	 * @return
	 */

	public void setBaja(Integer baja) {
		this.baja = baja;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getAb7801s00s'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Denuncia> getAb7801s00s() {
		return this.denuncias;
	}

	/**
	 * Method 'setAb7801s00s'.
	 *
	 * @param denuncias
	 *            List
	 * @return
	 */
	public void setAb7801s00s(List<Denuncia> denuncias) {
		this.denuncias = denuncias;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idProducto: ").append(this.idMotivo).append(" ]");
		result.append(", [ descTipoEs: ").append(this.descMotivoEs).append(" ]");
		result.append(", [ descTipoEu: ").append(this.descMotivoEu).append(" ]");
		result.append(", [ baja: ").append(this.baja).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public Long getIdProcedimiento() {
		return idProcedimiento;
	}

	public void setIdProcedimiento(Long idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}

}
