package com.ejie.ab78.model.maestros;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Decision  
 * 
 *  
 */

public class Decision implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long idDecision;
	private String descTipoEs;
	private String descTipoEu;
	private Integer esNoFormal;
	private Integer baja;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private List<Denuncia> denuncias = new ArrayList<Denuncia>();
	private Long idProcedimiento;

	/**
	 * Method 'Decision'.
	 */
	public Decision() {
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param idDecision
	 *            Long
	 */
	public Decision(Long idDecision) {
		this.idDecision = idDecision;
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param idDecision
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Decision(Long idDecision, String descTipoEs, String descTipoEu, Integer baja, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {
		this.idDecision = idDecision;
		this.descTipoEs = descTipoEs;
		this.descTipoEu = descTipoEu;
		this.esNoFormal = 0;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param idDecision
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Decision(Long idDecision, String descTipoEs, String descTipoEu, Integer esNoformal, Integer baja,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {
		this.idDecision = idDecision;
		this.descTipoEs = descTipoEs;
		this.descTipoEu = descTipoEu;
		this.esNoFormal = esNoformal;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'Decision'.
	 * 
	 * @param idDecision
	 *            Long
	 * @param descTipoEs
	 *            String
	 * @param descTipoEu
	 *            String
	 * @param baja
	 *            Integer
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param denuncias
	 *            List<Denuncia>
	 */
	public Decision(Long idDecision, String descTipoEs, String descTipoEu, Integer baja, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			List<Denuncia> denuncias) {

		this.idDecision = idDecision;
		this.descTipoEs = descTipoEs;
		this.descTipoEu = descTipoEu;
		this.baja = baja;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.denuncias = denuncias;
	}

	/**
	 * Method 'getIdDecision'.
	 *
	 * @return Long
	 */

	public Long getIdDecision() {
		return this.idDecision;
	}

	/**
	 * Method 'setIdDecision'.
	 *
	 * @param idDecision
	 *            Long
	 * @return
	 */

	public void setIdDecision(Long idDecision) {
		this.idDecision = idDecision;
	}

	/**
	 * Method 'getDescTipoEs'.
	 *
	 * @return String
	 */

	public String getDescTipoEs() {
		return this.descTipoEs;
	}

	/**
	 * Method 'setDescTipoEs'.
	 *
	 * @param descTipoEs
	 *            String
	 * @return
	 */

	public void setDescTipoEs(String descTipoEs) {
		this.descTipoEs = descTipoEs;
	}

	/**
	 * Method 'getDescTipoEu'.
	 *
	 * @return String
	 */

	public String getDescTipoEu() {
		return this.descTipoEu;
	}

	/**
	 * Method 'setDescTipoEu'.
	 *
	 * @param descTipoEu
	 *            String
	 * @return
	 */

	public void setDescTipoEu(String descTipoEu) {
		this.descTipoEu = descTipoEu;
	}

	/**
	 * Method 'getBaja'.
	 *
	 * @return Integer
	 */

	public Integer getBaja() {
		return this.baja;
	}

	/**
	 * Method 'setBaja'.
	 *
	 * @param baja
	 *            Integer
	 * @return
	 */

	public void setBaja(Integer baja) {
		this.baja = baja;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public Integer getEsNoFormal() {
		return esNoFormal;
	}

	public void setEsNoFormal(Integer esNoFormal) {
		this.esNoFormal = esNoFormal;
	}

	/**
	 * Method 'getDenuncias'.
	 *
	 * @return List
	 */
	@JsonIgnore
	public List<Denuncia> getDenuncias() {
		return this.denuncias;
	}

	/**
	 * Method 'setDenuncias'.
	 *
	 * @param denuncias
	 *            List
	 * @return
	 */
	public void setDenuncias(List<Denuncia> denuncias) {
		this.denuncias = denuncias;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idDecision: ").append(this.idDecision).append(" ]");
		result.append(", [ descTipoEs: ").append(this.descTipoEs).append(" ]");
		result.append(", [ descTipoEu: ").append(this.descTipoEu).append(" ]");
		result.append(", [ baja: ").append(this.baja).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public Long getIdProcedimiento() {
		return idProcedimiento;
	}

	public void setIdProcedimiento(Long idProcedimiento) {
		this.idProcedimiento = idProcedimiento;
	}

}
