package com.ejie.ab78.model.listados;

import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Listados  
 * 
 *  
 */

public class Listados implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idListado;
	private String nombre;
	private Clob fichero;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private List<Parametros> parametros = new ArrayList<Parametros>();
	private Procedimientos procedimientos;
	private String nombreBusquedas;
	private byte[] ficheroArray;
	private String nombreFichero;
	private String resultado;
	private String rutaPIF;

	/**
	 * Method 'Listados'.
	 */
	public Listados() {
	}

	/**
	 * Method 'Listados'.
	 * 
	 * @param idListado
	 *            Integer
	 */
	public Listados(Integer idListado) {
		this.idListado = idListado;
	}

	/**
	 * Method 'Listados'.
	 * 
	 * @param idListado
	 *            Integer
	 * @param idProcedimiento
	 *            Integer
	 * @param nombre
	 *            String
	 * @param fichero
	 *            Clob
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public Listados(Integer idListado, String nombre, Clob fichero, Date fechaRegistro, String usuarioRegistro,
			Date fechaUltmodificacion, String usuarioUltmodificacion) {

		this.idListado = idListado;
		this.nombre = nombre;
		this.fichero = fichero;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdListado'.
	 *
	 * @return Integer
	 */

	public Integer getIdListado() {
		return this.idListado;
	}

	/**
	 * Method 'setIdListado'.
	 *
	 * @param idListado
	 *            Integer
	 * @return
	 */

	public void setIdListado(Integer idListado) {
		this.idListado = idListado;
	}

	/**
	 * Method 'getIdProcedimiento'.
	 *
	 * @return Integer
	 */

	/**
	 * Method 'getNombre'.
	 *
	 * @return String
	 */

	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Method 'setNombre'.
	 *
	 * @param nombre
	 *            String
	 * @return
	 */

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Method 'getFichero'.
	 *
	 * @return Clob
	 */
	@JsonIgnore

	public Clob getFichero() {
		return this.fichero;
	}

	/**
	 * Method 'setFichero'.
	 *
	 * @param fichero
	 *            Clob
	 * @return
	 */

	public void setFichero(Clob fichero) {
		this.fichero = fichero;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public List<Parametros> getParametros() {
		return parametros;
	}

	public void setParametros(List<Parametros> parametros) {
		this.parametros = parametros;
	}

	/**
	 * @return the procedimientos
	 */
	public Procedimientos getProcedimientos() {
		return procedimientos;
	}

	/**
	 * @param procedimientos
	 *            the procedimientos to set
	 */
	public void setProcedimientos(Procedimientos procedimientos) {
		this.procedimientos = procedimientos;
	}

	/**
	 * @return the nombreBusquedas
	 */
	public String getNombreBusquedas() {
		return nombreBusquedas;
	}

	/**
	 * @param nombreBusquedas
	 *            the nombreBusquedas to set
	 */
	public void setNombreBusquedas(String nombreBusquedas) {
		this.nombreBusquedas = nombreBusquedas;
	}

	/**
	 * @return the ficheroArray
	 */
	public byte[] getFicheroArray() {
		return ficheroArray;
	}

	/**
	 * @param ficheroArray
	 *            the ficheroArray to set
	 */
	public void setFicheroArray(byte[] ficheroArray) {
		this.ficheroArray = ficheroArray;
	}

	/**
	 * @return the nombreFichero
	 */
	public String getNombreFichero() {
		return nombreFichero;
	}

	/**
	 * @param nombreFichero
	 *            the nombreFichero to set
	 */
	public void setNombreFichero(String nombreFichero) {
		this.nombreFichero = nombreFichero;
	}

	public String getResultado() {
		return resultado;
	}

	public void setResultado(String resultado) {
		this.resultado = resultado;
	}

	public String getRutaPIF() {
		return rutaPIF;
	}

	public void setRutaPIF(String rutaPif) {
		this.rutaPIF = rutaPif;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idListado: ").append(this.idListado).append(" ]");
		result.append(", [ nombre: ").append(this.nombre).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}
}
