package com.ejie.ab78.model.expedientes;

import java.util.Date;

import com.ejie.ab78.comun.UtilDate;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Expedientes implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String tituloExpediente;
	private Integer idExpediente;
	private Integer idExpedienteOrigen;
	private Procedimientos procedimientos;
	private Long idTerritorioHistorico;
	private String folderId;
	private String folderNumber;
	private String titulo;
	private Date fechaRegistro;
	private String usuarioRegistro;

	private String fechaEntradaStr;
	private String fechaDocFormalStr;
	private String fechaUltAporStr;

	private Procedimientos procedimiento;

	private Date fechaEntrada;
	private Date fechaDocFormal;
	private Date fechaUltApor;
	private Date fechaCierre;

	private DatosTerceros datosTerceros;
	private String tipoEmpTer;

	private Boolean expedienteOficio;

	/**
	 * Method 'Expedientes'.
	 */
	public Expedientes() {
		super();
	}

	/**
	 * Method 'Expedientes'.
	 * 
	 * @param idExpediente
	 *            Integer
	 */
	public Expedientes(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	public Expedientes(String folderNumber) {

		this.folderNumber = folderNumber;
	}

	/**
	 * Method 'Expedientes'.
	 * 
	 * @param idExpediente
	 *            Integer
	 * @param idTerritorioHistorico
	 *            Long
	 * @param folderId
	 *            String
	 * @param folderNumber
	 *            String
	 * @param titulo
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param procedimientos
	 *            Procedimientos
	 * 
	 */
	public Expedientes(Integer idExpediente, Long idTerritorioHistorico, String folderId, String folderNumber,
			String titulo, Date fechaRegistro, String usuarioRegistro, Procedimientos procedimientos,
			Integer idExpedienteOrigen) {

		this.idExpediente = idExpediente;
		this.procedimientos = procedimientos;
		this.idTerritorioHistorico = idTerritorioHistorico;
		this.folderId = folderId;
		this.folderNumber = folderNumber;
		this.titulo = titulo;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.idExpedienteOrigen = idExpedienteOrigen;

	}

	public Expedientes(Integer idExpediente, Long idTerritorioHistorico, String folderId, String folderNumber,
			String titulo, Date fechaRegistro, String usuarioRegistro, Procedimientos procedimientos) {

		this.idExpediente = idExpediente;
		this.procedimientos = procedimientos;
		this.idTerritorioHistorico = idTerritorioHistorico;
		this.folderId = folderId;
		this.folderNumber = folderNumber;
		this.titulo = titulo;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;

	}

	public Expedientes(Integer idExpediente, String folderNumber, Date fechaEntrada, Date fechaDocFormal,
			Date fechaUltApor) {

		this.idExpediente = idExpediente;
		this.folderNumber = folderNumber;
		this.fechaEntrada = fechaEntrada;
		this.fechaDocFormal = fechaDocFormal;
		this.fechaUltApor = fechaUltApor;
	}

	public Expedientes(Integer idExpediente, String titulo) {
		super();
		this.idExpediente = idExpediente;
		this.titulo = titulo;
	}

	/**
	 * @return the fechaUltApor
	 */
	public Date getFechaUltApor() {
		return fechaUltApor;
	}

	/**
	 * @param fechaUltApor
	 *            the fechaUltApor to set
	 */
	public void setFechaUltApor(Date fechaUltApor) {
		this.fechaUltApor = fechaUltApor;
	}

	/**
	 * @return the fechaEntrada
	 */
	public Date getFechaEntrada() {
		return fechaEntrada;
	}

	/**
	 * @param fechaEntrada
	 *            the fechaEntrada to set
	 */
	public void setFechaEntrada(Date fechaEntrada) {
		this.fechaEntrada = fechaEntrada;
	}

	/**
	 * @return the fechaDocFormal
	 */
	public Date getFechaDocFormal() {
		return fechaDocFormal;
	}

	/**
	 * @param fechaDocFormal
	 *            the fechaDocFormal to set
	 */
	public void setFechaDocFormal(Date fechaDocFormal) {
		this.fechaDocFormal = fechaDocFormal;
	}

	/**
	 * 
	 * /**
	 * 
	 * @return the procedimiento
	 */
	public Procedimientos getProcedimiento() {
		return procedimiento;
	}

	/**
	 * @param procedimiento
	 *            the procedimiento to set
	 */
	public void setProcedimiento(Procedimientos procedimiento) {
		this.procedimiento = procedimiento;
	}

	/**
	 * @return the fechaEntradaStr
	 */
	public String getFechaEntradaStr() {
		return fechaEntradaStr;
	}

	/**
	 * @param fechaEntradaStr
	 *            the fechaEntradaStr to set
	 */
	public void setFechaEntradaStr(String fechaEntradaStr) {
		this.fechaEntradaStr = fechaEntradaStr;
	}

	/**
	 * @return the fechaDocFormalStr
	 */
	public String getFechaDocFormalStr() {
		return fechaDocFormalStr;
	}

	/**
	 * @param fechaDocFormalStr
	 *            the fechaDocFormalStr to set
	 */
	public void setFechaDocFormalStr(String fechaDocFormalStr) {
		this.fechaDocFormalStr = fechaDocFormalStr;
	}

	/**
	 * @return the fechaUltAporStr
	 */
	public String getFechaUltAporStr() {
		return fechaUltAporStr;
	}

	/**
	 * @param fechaUltAporStr
	 *            the fechaUltAporStr to set
	 */
	public void setFechaUltAporStr(String fechaUltAporStr) {
		this.fechaUltAporStr = fechaUltAporStr;
	}

	/**
	 * Method 'getIdExpediente'.
	 *
	 * @return Integer
	 */

	public Integer getIdExpediente() {
		return this.idExpediente;
	}

	/**
	 * Method 'setIdExpediente'.
	 *
	 * @param idExpediente
	 *            Integer
	 * @return
	 */

	public void setIdExpediente(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	public Integer getIdExpedienteOrigen() {
		return idExpedienteOrigen;
	}

	public void setIdExpedienteOrigen(Integer idExpedienteOrigen) {
		this.idExpedienteOrigen = idExpedienteOrigen;
	}

	/**
	 * Method 'getProcedimientos'.
	 *
	 * @return Procedimientos
	 */
	@JsonIgnore

	public Procedimientos getProcedimientos() {
		return this.procedimientos;
	}

	/**
	 * Method 'setProcedimientos'.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return
	 */

	public void setProcedimientos(Procedimientos procedimientos) {
		this.procedimientos = procedimientos;
	}

	/**
	 * Method 'getIdTerritorioHistorico'.
	 *
	 * @return Long
	 */

	public Long getIdTerritorioHistorico() {
		return this.idTerritorioHistorico;
	}

	/**
	 * Method 'setIdTerritorioHistorico'.
	 *
	 * @param idTerritorioHistorico
	 *            Long
	 * @return
	 */

	public void setIdTerritorioHistorico(Long idTerritorioHistorico) {
		this.idTerritorioHistorico = idTerritorioHistorico;
	}

	/**
	 * Method 'getFolderId'.
	 *
	 * @return String
	 */

	public String getFolderId() {
		return this.folderId;
	}

	/**
	 * Method 'setFolderId'.
	 *
	 * @param folderId
	 *            String
	 * @return
	 */

	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * Method 'getFolderNumber'.
	 *
	 * @return String
	 */

	public String getFolderNumber() {
		return this.folderNumber;
	}

	/**
	 * Method 'setFolderNumber'.
	 *
	 * @param folderNumber
	 *            String
	 * @return
	 */

	public void setFolderNumber(String folderNumber) {
		this.folderNumber = folderNumber;
	}

	/**
	 * Method 'getTitulo'.
	 *
	 * @return String
	 */

	public String getTitulo() {
		return this.titulo;
	}

	/**
	 * Method 'setTitulo'.
	 *
	 * @param titulo
	 *            String
	 * @return
	 */

	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaDocFormalHoraStr'.
	 *
	 * @return String
	 */

	public String getFechaDocFormalHoraStr() {
		return UtilDate.convertirEnFechaConHora(this.fechaDocFormal);
	}

	/**
	 * Method 'getFechaUltAporHoraStr'.
	 *
	 * @return String
	 */

	public String getFechaUltAporHoraStr() {
		return UtilDate.convertirEnFechaConHora(this.fechaUltApor);
	}

	/**
	 * Method 'getFechaUltAporHoraStr'.
	 *
	 * @return String
	 */

	public String getFechaEntradaHoraStr() {
		return UtilDate.convertirEnFechaConHora(this.fechaEntrada);
	}

	/**
	 * @return the datosTerceros
	 */
	public DatosTerceros getDatosTerceros() {
		return datosTerceros;
	}

	/**
	 * @param datosTerceros
	 *            the datosTerceros to set
	 */
	public void setDatosTerceros(DatosTerceros datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

	/**
	 * @return the terEmp
	 */
	public String getTerEmp() {
		if (null != this.datosTerceros && null != this.datosTerceros.getNombre()
				&& !"".equalsIgnoreCase(datosTerceros.getNombre())) {
			return datosTerceros.getDocumento() + " - " + datosTerceros.getNombre() + " " + datosTerceros.getApellido1()
					+ " " + datosTerceros.getApellido2();
		} else
			return "";
	}

	public String getComboLabel() {
		StringBuilder builder = new StringBuilder();

		if (folderNumber != null) {
			builder.append("(").append(folderNumber).append(") ");
		}
		/*
		 * if (procedimientos != null) {
		 * builder.append("(").append(procedimientos.getCodProcedureId()).
		 * append(") "); }
		 */
		builder.append(this.titulo);
		return builder.toString();
	}

	/**
	 * @return the tipoEmpTer
	 */
	public String getTipoEmpTer() {
		return tipoEmpTer;
	}

	/**
	 * @param tipoEmpTer
	 *            the tipoEmpTer to set
	 */
	public void setTipoEmpTer(String tipoEmpTer) {
		this.tipoEmpTer = tipoEmpTer;
	}

	public Date getFechaCierre() {
		return fechaCierre;
	}

	public void setFechaCierre(Date fechaCierre) {
		this.fechaCierre = fechaCierre;
	}

	public String getTituloExpediente() {
		return tituloExpediente;
	}

	public void setTituloExpediente(String tituloExpediente) {
		this.tituloExpediente = tituloExpediente;
	}

	public Boolean isExpedienteOficio() {
		return expedienteOficio;
	}

	public void setExpedienteOficio(Boolean expedienteOficio) {
		this.expedienteOficio = expedienteOficio;
	}

}
