package com.ejie.ab78.model.expedientes;

import java.util.Date;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.establecimientos.Establecimiento;

public class ExpedienteHistorico {
	private Long idExpHistorico;
	private Establecimiento establecimiento;
	private Denuncia denuncia;
	private String folderNumber;
	private String folderId;
	private String titulo;
	private Date fechaApertura;
	private String documentoTitular;
	private String documentoRepresentante;
	private String nombreProcedimiento;
	private String origen;
	private Date fechaRegistro;
	private String usuarioRegistro;

	public ExpedienteHistorico() {
	}

	public ExpedienteHistorico(Long idExpHistorico) {
		this.idExpHistorico = idExpHistorico;
	}

	public ExpedienteHistorico(Long idExpHistorico, Establecimiento establecimiento, Denuncia denuncia,
			String folderNumber, String folderId, String titulo, Date fechaApertura, String documentoTitular,
			String documentoRepresentante, String nombreProcedimiento, String origen, Date fechaRegistro,
			String usuarioRegistro) {
		this.idExpHistorico = idExpHistorico;
		this.establecimiento = establecimiento;
		this.denuncia = denuncia;
		this.folderNumber = folderNumber;
		this.folderId = folderId;
		this.titulo = titulo;
		this.fechaApertura = fechaApertura;
		this.documentoTitular = documentoTitular;
		this.documentoRepresentante = documentoRepresentante;
		this.nombreProcedimiento = nombreProcedimiento;
		this.origen = origen;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * @return the idExpHistorico
	 */
	public Long getIdExpHistorico() {
		return idExpHistorico;
	}

	/**
	 * @param idExpHistorico
	 *            the idExpHistorico to set
	 */
	public void setIdExpHistorico(Long idExpHistorico) {
		this.idExpHistorico = idExpHistorico;
	}

	/**
	 * @return the establecimiento
	 */
	public Establecimiento getEstablecimiento() {
		return this.establecimiento;
	}

	/**
	 * @param establecimiento
	 *            the establecimiento to set
	 */
	public void setEstablecimiento(Establecimiento establecimiento) {
		this.establecimiento = establecimiento;
	}

	/**
	 * @return the folderNumber
	 */
	public String getFolderNumber() {
		return folderNumber;
	}

	/**
	 * @param folderNumber
	 *            the folderNumber to set
	 */
	public void setFolderNumber(String folderNumber) {
		this.folderNumber = folderNumber;
	}

	/**
	 * @return the folderId
	 */
	public String getFolderId() {
		return folderId;
	}

	/**
	 * @param folderId
	 *            the folderId to set
	 */
	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * @return the titulo
	 */
	public String getTitulo() {
		return titulo;
	}

	/**
	 * @param titulo
	 *            the titulo to set
	 */
	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	/**
	 * @return the fechaApertura
	 */
	public Date getFechaApertura() {
		return fechaApertura;
	}

	/**
	 * @param fechaApertura
	 *            the fechaApertura to set
	 */
	public void setFechaApertura(Date fechaApertura) {
		this.fechaApertura = fechaApertura;
	}

	/**
	 * @return the documentoTitular
	 */
	public String getDocumentoTitular() {
		return documentoTitular;
	}

	/**
	 * @param documentoTitular
	 *            the documentoTitular to set
	 */
	public void setDocumentoTitular(String documentoTitular) {
		this.documentoTitular = documentoTitular;
	}

	/**
	 * @return the documentoRepresentante
	 */
	public String getDocumentoRepresentante() {
		return documentoRepresentante;
	}

	/**
	 * @param documentoRepresentante
	 *            the documentoRepresentante to set
	 */
	public void setDocumentoRepresentante(String documentoRepresentante) {
		this.documentoRepresentante = documentoRepresentante;
	}

	/**
	 * @return the nombreProcedimiento
	 */
	public String getNombreProcedimiento() {
		return nombreProcedimiento;
	}

	/**
	 * @param nombreProcedimiento
	 *            the nombreProcedimiento to set
	 */
	public void setNombreProcedimiento(String nombreProcedimiento) {
		this.nombreProcedimiento = nombreProcedimiento;
	}

	/**
	 * @return the origen
	 */
	public String getOrigen() {
		return origen;
	}

	/**
	 * @param origen
	 *            the origen to set
	 */
	public void setOrigen(String origen) {
		this.origen = origen;
	}

	/**
	 * @return the fechaRegistro
	 */
	public Date getFechaRegistro() {
		return fechaRegistro;
	}

	/**
	 * @param fechaRegistro
	 *            the fechaRegistro to set
	 */
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * @return the usuarioRegistro
	 */
	public String getUsuarioRegistro() {
		return usuarioRegistro;
	}

	/**
	 * @param usuarioRegistro
	 *            the usuarioRegistro to set
	 */
	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ExpedienteHistorico [idExpHistorico=" + idExpHistorico + ", establecimiento=" + establecimiento
				+ ", folderNumber=" + folderNumber + ", folderId=" + folderId + ", titulo=" + titulo
				+ ", fechaApertura=" + fechaApertura + ", documentoTitular=" + documentoTitular
				+ ", documentoRepresentante=" + documentoRepresentante + ", nombreProcedimiento=" + nombreProcedimiento
				+ ", origen=" + origen + ", fechaRegistro=" + fechaRegistro + ", usuarioRegistro=" + usuarioRegistro
				+ "]";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((documentoRepresentante == null) ? 0 : documentoRepresentante.hashCode());
		result = prime * result + ((documentoTitular == null) ? 0 : documentoTitular.hashCode());
		result = prime * result + ((establecimiento == null) ? 0 : establecimiento.hashCode());
		result = prime * result + ((fechaApertura == null) ? 0 : fechaApertura.hashCode());
		result = prime * result + ((fechaRegistro == null) ? 0 : fechaRegistro.hashCode());
		result = prime * result + ((folderId == null) ? 0 : folderId.hashCode());
		result = prime * result + ((folderNumber == null) ? 0 : folderNumber.hashCode());
		result = prime * result + ((idExpHistorico == null) ? 0 : idExpHistorico.hashCode());
		result = prime * result + ((nombreProcedimiento == null) ? 0 : nombreProcedimiento.hashCode());
		result = prime * result + ((origen == null) ? 0 : origen.hashCode());
		result = prime * result + ((titulo == null) ? 0 : titulo.hashCode());
		result = prime * result + ((usuarioRegistro == null) ? 0 : usuarioRegistro.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ExpedienteHistorico other = (ExpedienteHistorico) obj;
		if (documentoRepresentante == null) {
			if (other.documentoRepresentante != null)
				return false;
		} else if (!documentoRepresentante.equals(other.documentoRepresentante))
			return false;
		if (documentoTitular == null) {
			if (other.documentoTitular != null)
				return false;
		} else if (!documentoTitular.equals(other.documentoTitular))
			return false;
		if (establecimiento == null) {
			if (other.establecimiento != null)
				return false;
		} else if (!establecimiento.equals(other.establecimiento))
			return false;
		if (fechaApertura == null) {
			if (other.fechaApertura != null)
				return false;
		} else if (!fechaApertura.equals(other.fechaApertura))
			return false;
		if (fechaRegistro == null) {
			if (other.fechaRegistro != null)
				return false;
		} else if (!fechaRegistro.equals(other.fechaRegistro))
			return false;
		if (folderId == null) {
			if (other.folderId != null)
				return false;
		} else if (!folderId.equals(other.folderId))
			return false;
		if (folderNumber == null) {
			if (other.folderNumber != null)
				return false;
		} else if (!folderNumber.equals(other.folderNumber))
			return false;
		if (idExpHistorico == null) {
			if (other.idExpHistorico != null)
				return false;
		} else if (!idExpHistorico.equals(other.idExpHistorico))
			return false;
		if (nombreProcedimiento == null) {
			if (other.nombreProcedimiento != null)
				return false;
		} else if (!nombreProcedimiento.equals(other.nombreProcedimiento))
			return false;
		if (origen == null) {
			if (other.origen != null)
				return false;
		} else if (!origen.equals(other.origen))
			return false;
		if (titulo == null) {
			if (other.titulo != null)
				return false;
		} else if (!titulo.equals(other.titulo))
			return false;
		if (usuarioRegistro == null) {
			if (other.usuarioRegistro != null)
				return false;
		} else if (!usuarioRegistro.equals(other.usuarioRegistro))
			return false;
		return true;
	}

	public Denuncia getDenuncia() {
		return denuncia;
	}

	public void setDenuncia(Denuncia denuncia) {
		this.denuncia = denuncia;
	}

}
