package com.ejie.ab78.model.establecimientos;

import java.util.Date;

import com.ejie.ab78.model.maestros.TipoEstablecimiento;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Ab6301s00  
 * 
 *  
 */

public class Establecimiento implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idEstablecimiento;
	private TipoEstablecimiento tipoEstablecimiento;
	private String identificadorEstablecimiento;
	private String descrNombre;
	private String visibleweb;
	private String temporada;
	private String urlweb;
	private String idDefectos;
	private Integer numUnidadesAlojamiento;
	private String observaciones;
	private Date fechaApertura;
	private Date fechaBaja;
	private Date fechaInicierretemp;
	private Date fechaFincierretemp;
	private Date fechaVctoCierre;
	private Date fechaUltNotificacion;
	private Date fechaUltInspeccion;
	private Date fechaProInspeccion;
	private Date fechaUltActualizacion;
	private Date fechaClausura;
	private Date fechaUltReforma;
	private String eliminado;
	private String expedienteb29;
	private Long idPortalS41;
	private String urlPortalS41;
	private Date fechaControlS41;
	private String numInstalacionAnterior;
	private Date fechaInscripcion;
	private String numInstalacionWz;
	private String observaciones2;
	private String notasMigracion;
	private String agrupacion;
	private String refCatastral;
	private String obsSegrespcivil;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private String telefonoPromo;

	private String tipoBusqueda;

	private Integer incluirSucursales; // dato para busqueda
	private String CIE; // dato para busqueda
	private Date aperturaDesde; // dato para busqueda
	private Date aperturaHasta; // dato para busqueda
	private Date ultimaInspeccionDesde; // dato para busqueda
	private Date ultimaInspeccionHasta; // dato para busqueda
	private Date ultimaModificacionDesde; // dato para busqueda
	private Date ultimaModificacionHasta; // dato para busqueda
	private String correoElectronico; // dato para busqueda
	private String telefono; // dato para busqueda
	private String correoElectronicoBusqueda; // dato para busqueda
	private String telefonoBusqueda; // dato para busqueda
	private Integer mostrar; // dato para busqueda
	private Integer pais; // dato para Detalle
	private DatosTerceros datosTerceros;
	private DatosDirecciones datosDirecciones;

	private String idExpediente;
	private String tipoRegistro;
	private String idEstablecimientoPadre;
	private String identificadorSolicitud;

	private String autocompleteEstablecimiento;

	private String periodoPuentes;
	private String periodoVacaciones;
	private String periodoVerano;
	private String sinPeriodoPref;
	private String modifEsencial;

	private int usoResidentes;
	private int usoTuristico;

	private boolean onlyTitularIfExists;

	private String direccionCompuesta;

	private Boolean onlyTerActivos = false;

	private String tipoEstSignaturaFilter;
	private String zonaSignaturaFilter;
	private String correlativoSignaturaFilter;
	private String idestabSolic;
	private String thActividad;
	private String canModIdestabSolic;

	/**
	 * Method 'Ab6301s00'.
	 */
	public Establecimiento() {
	}

	/**
	 * Method 'Ab6301s00'.
	 * 
	 * @param idEstablecimiento
	 *            Integer
	 */
	public Establecimiento(Integer idEstablecimiento) {
		this.idEstablecimiento = idEstablecimiento;
	}

	/**
	 * Method 'Ab6301s00'.
	 * 
	 * @param idEstablecimiento
	 *            Integer
	 * @param identificadorEstablecimiento
	 *            String
	 * @param descNombre
	 *            String
	 * @param visibleweb
	 *            String
	 * @param temporada
	 *            String
	 * @param urlweb
	 *            String
	 * @param idDefectos
	 *            String
	 * @param numUnidadesAlojamiento
	 *            Integer
	 * @param observaciones
	 *            String
	 * @param fechaApertura
	 *            Date
	 * @param fechaBaja
	 *            Date
	 * @param fechaInicierretemp
	 *            Date
	 * @param fechaFincierretemp
	 *            Date
	 * @param fechaVctoCierre
	 *            Date
	 * @param fechaUltNotificacion
	 *            Date
	 * @param fechaUltInspeccion
	 *            Date
	 * @param fechaProInspeccion
	 *            Date
	 * @param fechaUltActualizacion
	 *            Date
	 * @param fechaClausura
	 *            Date
	 * @param fechaUltReforma
	 *            Date
	 * @param eliminado
	 *            String
	 * @param expedienteb29
	 *            String
	 * @param idPortalS41
	 *            Long
	 * @param urlPortalS41
	 *            String
	 * @param fechaControlS41
	 *            Date
	 * @param numInstalacionAnterior
	 *            String
	 * @param fechaInscripcion
	 *            Date
	 * @param numInstalacionWz
	 *            String
	 * @param observaciones2
	 *            String
	 * @param notasMigracion
	 *            String
	 * @param agrupacion
	 *            String
	 * @param refCatastral
	 *            String
	 * @param obsSegrespcivil
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param recurso
	 *            Ab6300s00
	 * @param tipoEstablecimiento
	 *            Ab6311s00
	 * @param grupo
	 *            Ab6312s00
	 * @param categoria
	 *            Ab6313s00
	 * @param especialidad
	 *            Ab6315s00
	 * @param modalidad
	 *            Ab6314s00
	 * @param establecimientoData
	 *            Ab6321s00
	 * @param agenciaData
	 *            Ab6335s00
	 */
	public Establecimiento(Integer idEstablecimiento, String identificadorEstablecimiento, String descNombre,
			String visibleweb, String temporada, String urlweb, String idDefectos, Integer numUnidadesAlojamiento,
			String observaciones, Date fechaApertura, Date fechaBaja, Date fechaInicierretemp, Date fechaFincierretemp,
			Date fechaVctoCierre, Date fechaUltNotificacion, Date fechaUltInspeccion, Date fechaProInspeccion,
			Date fechaUltActualizacion, Date fechaClausura, Date fechaUltReforma, String eliminado,
			String expedienteb29, Long idPortalS41, String urlPortalS41, Date fechaControlS41,
			String numInstalacionAnterior, Date fechaInscripcion, String numInstalacionWz, String observaciones2,
			String notasMigracion, String agrupacion, String refCatastral, String obsSegrespcivil, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion, String telefono,
			String correoElectronico, String idExpediente, String idEstablecimientoPadre, String tipoRegistro,
			String identificadorSolicitud, String periodoPuentes, String periodoVacaciones, String periodoVerano,
			String sinPeriodoPref, String telefonoPromo, String modifEsencial, DatosTerceros datosTerceros,
			DatosDirecciones datosDirecciones) {
		this.idEstablecimiento = idEstablecimiento;
		this.tipoEstablecimiento = tipoEstablecimiento;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.descrNombre = descNombre;
		this.visibleweb = visibleweb;
		this.temporada = temporada;
		this.urlweb = urlweb;
		this.idDefectos = idDefectos;
		this.numUnidadesAlojamiento = numUnidadesAlojamiento;
		this.observaciones = observaciones;
		this.fechaApertura = fechaApertura;
		this.fechaBaja = fechaBaja;
		this.fechaInicierretemp = fechaInicierretemp;
		this.fechaFincierretemp = fechaFincierretemp;
		this.fechaVctoCierre = fechaVctoCierre;
		this.fechaUltNotificacion = fechaUltNotificacion;
		this.fechaUltInspeccion = fechaUltInspeccion;
		this.fechaProInspeccion = fechaProInspeccion;
		this.fechaUltActualizacion = fechaUltActualizacion;
		this.fechaClausura = fechaClausura;
		this.fechaUltReforma = fechaUltReforma;
		this.eliminado = eliminado;
		this.expedienteb29 = expedienteb29;
		this.idPortalS41 = idPortalS41;
		this.urlPortalS41 = urlPortalS41;
		this.fechaControlS41 = fechaControlS41;
		this.numInstalacionAnterior = numInstalacionAnterior;
		this.fechaInscripcion = fechaInscripcion;
		this.numInstalacionWz = numInstalacionWz;
		this.observaciones2 = observaciones2;
		this.notasMigracion = notasMigracion;
		this.agrupacion = agrupacion;
		this.refCatastral = refCatastral;
		this.obsSegrespcivil = obsSegrespcivil;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.telefono = telefono;
		this.correoElectronico = correoElectronico;
		this.datosTerceros = datosTerceros;
		this.datosDirecciones = datosDirecciones;
		this.idExpediente = idExpediente;
		this.tipoRegistro = tipoRegistro;
		this.idEstablecimientoPadre = idEstablecimientoPadre;
		this.identificadorSolicitud = identificadorSolicitud;
		this.periodoPuentes = periodoPuentes;
		this.periodoVacaciones = periodoVacaciones;
		this.periodoVerano = periodoVerano;
		this.sinPeriodoPref = sinPeriodoPref;
		this.modifEsencial = modifEsencial;
		this.telefonoPromo = telefonoPromo;
		if (identificadorEstablecimiento != null) {
			this.autocompleteEstablecimiento = identificadorEstablecimiento.toUpperCase() + " - " + descNombre;
		}

		/*
		 * if (datosDirecciones != null) { String direccionAux = ""; if
		 * (datosDirecciones.getDireccion() != null) { direccionAux =
		 * datosDirecciones.getDireccion(); }
		 * 
		 * if (datosDirecciones.getNumero() != null) { if
		 * (!"".equals(direccionAux)) { direccionAux = direccionAux + " " +
		 * datosDirecciones.getNumero(); } else { direccionAux =
		 * datosDirecciones.getNumero(); } }
		 * 
		 * if (datosDirecciones.getEscalera() != null) { if
		 * (!"".equals(direccionAux)) { direccionAux = direccionAux + ", " +
		 * datosDirecciones.getEscalera(); } else { direccionAux =
		 * datosDirecciones.getEscalera(); } }
		 * 
		 * if (datosDirecciones.getPiso() != null) { if
		 * (!"".equals(direccionAux)) { direccionAux = direccionAux + ", " +
		 * datosDirecciones.getPiso(); } else { direccionAux =
		 * datosDirecciones.getPiso(); } }
		 * 
		 * if (datosDirecciones.getLetra() != null) { if
		 * (!"".equals(direccionAux)) { direccionAux = direccionAux + ", " +
		 * datosDirecciones.getLetra(); } else { direccionAux =
		 * datosDirecciones.getLetra(); } }
		 * 
		 * if (datosDirecciones.getMunicipiodso() != null) { if
		 * (!"".equals(direccionAux)) { direccionAux = direccionAux + " (" +
		 * datosDirecciones.getMunicipiodso() + ")"; } else { direccionAux =
		 * datosDirecciones.getMunicipiodso(); } }
		 * 
		 * this.direccionCompuesta = direccionAux; }
		 */

		/*
		 * this.direccionCompuesta = datosDirecciones.getDireccion() + " " +
		 * datosDirecciones.getNumero() + ", " + datosDirecciones.getEscalera()
		 * + ", " + datosDirecciones.getLetra() + " (" +
		 * datosDirecciones.getMunicipiodso() + ")";
		 */
	}

	/**
	 * Method 'Ab6301s00'.
	 * 
	 * @param idEstablecimiento
	 *            Integer
	 * @param identificadorEstablecimiento
	 *            String
	 * @param descNombre
	 *            String
	 * @param visibleweb
	 *            String
	 * @param temporada
	 *            String
	 * @param urlweb
	 *            String
	 * @param idDefectos
	 *            String
	 * @param numUnidadesAlojamiento
	 *            Integer
	 * @param observaciones
	 *            String
	 * @param fechaApertura
	 *            Date
	 * @param fechaBaja
	 *            Date
	 * @param fechaInicierretemp
	 *            Date
	 * @param fechaFincierretemp
	 *            Date
	 * @param fechaVctoCierre
	 *            Date
	 * @param fechaUltNotificacion
	 *            Date
	 * @param fechaUltInspeccion
	 *            Date
	 * @param fechaProInspeccion
	 *            Date
	 * @param fechaUltActualizacion
	 *            Date
	 * @param fechaClausura
	 *            Date
	 * @param fechaUltReforma
	 *            Date
	 * @param eliminado
	 *            String
	 * @param expedienteb29
	 *            String
	 * @param idPortalS41
	 *            Long
	 * @param urlPortalS41
	 *            String
	 * @param fechaControlS41
	 *            Date
	 * @param numInstalacionAnterior
	 *            String
	 * @param fechaInscripcion
	 *            Date
	 * @param numInstalacionWz
	 *            String
	 * @param observaciones2
	 *            String
	 * @param notasMigracion
	 *            String
	 * @param agrupacion
	 *            String
	 * @param refCatastral
	 *            String
	 * @param obsSegrespcivil
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param recurso
	 *            Ab6300s00
	 * @param tipoEstablecimiento
	 *            Ab6311s00
	 * @param grupo
	 *            Ab6312s00
	 * @param categoria
	 *            Ab6313s00
	 * @param especialidad
	 *            Ab6315s00
	 * @param modalidad
	 *            Ab6314s00
	 * @param establecimientoData
	 *            Ab6321s00
	 * @param agenciaData
	 *            Ab6335s00
	 * @param listDireccionEstablecimiento
	 *            List<Ab6340s00>
	 * @param listTercerosEstablecimiento
	 *            List<Ab6339s00>
	 * @param listDispensaEstablecimiento
	 *            List<Ab6320s00>
	 */
	public Establecimiento(Integer idEstablecimiento, String identificadorEstablecimiento, String descNombre,
			String visibleweb, String temporada, String urlweb, String idDefectos, Integer numUnidadesAlojamiento,
			String observaciones, Date fechaApertura, Date fechaBaja, Date fechaInicierretemp, Date fechaFincierretemp,
			Date fechaVctoCierre, Date fechaUltNotificacion, Date fechaUltInspeccion, Date fechaProInspeccion,
			Date fechaUltActualizacion, Date fechaClausura, Date fechaUltReforma, String eliminado,
			String expedienteb29, Long idPortalS41, String urlPortalS41, Date fechaControlS41,
			String numInstalacionAnterior, Date fechaInscripcion, String numInstalacionWz, String observaciones2,
			String notasMigracion, String agrupacion, String refCatastral, String obsSegrespcivil, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			TipoEstablecimiento tipoEstablecimiento) {

		this.idEstablecimiento = idEstablecimiento;
		this.tipoEstablecimiento = tipoEstablecimiento;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.descrNombre = descNombre;
		this.visibleweb = visibleweb;
		this.temporada = temporada;
		this.urlweb = urlweb;
		this.idDefectos = idDefectos;
		this.numUnidadesAlojamiento = numUnidadesAlojamiento;
		this.observaciones = observaciones;
		this.fechaApertura = fechaApertura;
		this.fechaBaja = fechaBaja;
		this.fechaInicierretemp = fechaInicierretemp;
		this.fechaFincierretemp = fechaFincierretemp;
		this.fechaVctoCierre = fechaVctoCierre;
		this.fechaUltNotificacion = fechaUltNotificacion;
		this.fechaUltInspeccion = fechaUltInspeccion;
		this.fechaProInspeccion = fechaProInspeccion;
		this.fechaUltActualizacion = fechaUltActualizacion;
		this.fechaClausura = fechaClausura;
		this.fechaUltReforma = fechaUltReforma;
		this.eliminado = eliminado;
		this.expedienteb29 = expedienteb29;
		this.idPortalS41 = idPortalS41;
		this.urlPortalS41 = urlPortalS41;
		this.fechaControlS41 = fechaControlS41;
		this.numInstalacionAnterior = numInstalacionAnterior;
		this.fechaInscripcion = fechaInscripcion;
		this.numInstalacionWz = numInstalacionWz;
		this.observaciones2 = observaciones2;
		this.notasMigracion = notasMigracion;
		this.agrupacion = agrupacion;
		this.refCatastral = refCatastral;
		this.obsSegrespcivil = obsSegrespcivil;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdEstablecimiento'.
	 *
	 * @return Integer
	 */

	public Integer getIdEstablecimiento() {
		return this.idEstablecimiento;
	}

	/**
	 * Method 'setIdEstablecimiento'.
	 *
	 * @param idEstablecimiento
	 *            Integer
	 * @return
	 */

	public void setIdEstablecimiento(Integer idEstablecimiento) {
		this.idEstablecimiento = idEstablecimiento;
	}

	/**
	 * Method 'getAb6311s00'.
	 *
	 * @return Ab6311s00
	 */

	public TipoEstablecimiento getTipoEstablecimiento() {
		return this.tipoEstablecimiento;
	}

	/**
	 * Method 'setAb6311s00'.
	 *
	 * @param tipoEstablecimiento
	 *            Ab6311s00
	 * @return
	 */

	public void setTipoEstablecimiento(TipoEstablecimiento tipoEstablecimiento) {
		this.tipoEstablecimiento = tipoEstablecimiento;
	}

	/**
	 * Method 'getIdentificadorEstablecimiento'.
	 *
	 * @return String
	 */

	public String getIdentificadorEstablecimiento() {
		return this.identificadorEstablecimiento;
	}

	/**
	 * Method 'setIdentificadorEstablecimiento'.
	 *
	 * @param identificadorEstablecimiento
	 *            String
	 * @return
	 */

	public void setIdentificadorEstablecimiento(String identificadorEstablecimiento) {
		this.identificadorEstablecimiento = identificadorEstablecimiento;
	}

	/**
	 * Method 'getDescNombre'.
	 *
	 * @return String
	 */

	public String getDescrNombre() {
		return this.descrNombre;
	}

	/**
	 * Method 'setDescNombre'.
	 *
	 * @param descNombre
	 *            String
	 * @return
	 */

	public void setDescrNombre(String descNombre) {
		this.descrNombre = descNombre;
	}

	/**
	 * Method 'getVisibleweb'.
	 *
	 * @return String
	 */

	public String getVisibleweb() {
		return this.visibleweb;
	}

	/**
	 * Method 'setVisibleweb'.
	 *
	 * @param visibleweb
	 *            String
	 * @return
	 */

	public void setVisibleweb(String visibleweb) {
		this.visibleweb = visibleweb;
	}

	/**
	 * Method 'getTemporada'.
	 *
	 * @return String
	 */

	public String getTemporada() {
		return this.temporada;
	}

	/**
	 * Method 'setTemporada'.
	 *
	 * @param temporada
	 *            String
	 * @return
	 */

	public void setTemporada(String temporada) {
		this.temporada = temporada;
	}

	/**
	 * Method 'getUrlweb'.
	 *
	 * @return String
	 */

	public String getUrlweb() {
		return this.urlweb;
	}

	/**
	 * Method 'setUrlweb'.
	 *
	 * @param urlweb
	 *            String
	 * @return
	 */

	public void setUrlweb(String urlweb) {
		this.urlweb = urlweb;
	}

	/**
	 * Method 'getIdDefectos'.
	 *
	 * @return String
	 */

	public String getIdDefectos() {
		return this.idDefectos;
	}

	/**
	 * Method 'setIdDefectos'.
	 *
	 * @param idDefectos
	 *            String
	 * @return
	 */

	public void setIdDefectos(String idDefectos) {
		this.idDefectos = idDefectos;
	}

	/**
	 * Method 'getNumUnidadesAlojamiento'.
	 *
	 * @return Integer
	 */

	public Integer getNumUnidadesAlojamiento() {
		return this.numUnidadesAlojamiento;
	}

	/**
	 * Method 'setNumUnidadesAlojamiento'.
	 *
	 * @param numUnidadesAlojamiento
	 *            Integer
	 * @return
	 */

	public void setNumUnidadesAlojamiento(Integer numUnidadesAlojamiento) {
		this.numUnidadesAlojamiento = numUnidadesAlojamiento;
	}

	/**
	 * Method 'getObservaciones'.
	 *
	 * @return String
	 */

	public String getObservaciones() {
		return this.observaciones;
	}

	/**
	 * Method 'setObservaciones'.
	 *
	 * @param observaciones
	 *            String
	 * @return
	 */

	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	/**
	 * Method 'getFechaApertura'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaApertura() {
		return this.fechaApertura;
	}

	/**
	 * Method 'setFechaApertura'.
	 *
	 * @param fechaApertura
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaApertura(Date fechaApertura) {
		this.fechaApertura = fechaApertura;
	}

	/**
	 * Method 'getFechaBaja'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaBaja() {
		return this.fechaBaja;
	}

	/**
	 * Method 'setFechaBaja'.
	 *
	 * @param fechaBaja
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaBaja(Date fechaBaja) {
		this.fechaBaja = fechaBaja;
	}

	/**
	 * Method 'getFechaInicierretemp'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaInicierretemp() {
		return this.fechaInicierretemp;
	}

	/**
	 * Method 'setFechaInicierretemp'.
	 *
	 * @param fechaInicierretemp
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaInicierretemp(Date fechaInicierretemp) {
		this.fechaInicierretemp = fechaInicierretemp;
	}

	/**
	 * Method 'getFechaFincierretemp'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaFincierretemp() {
		return this.fechaFincierretemp;
	}

	/**
	 * Method 'setFechaFincierretemp'.
	 *
	 * @param fechaFincierretemp
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaFincierretemp(Date fechaFincierretemp) {
		this.fechaFincierretemp = fechaFincierretemp;
	}

	/**
	 * Method 'getFechaVctoCierre'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaVctoCierre() {
		return this.fechaVctoCierre;
	}

	/**
	 * Method 'setFechaVctoCierre'.
	 *
	 * @param fechaVctoCierre
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaVctoCierre(Date fechaVctoCierre) {
		this.fechaVctoCierre = fechaVctoCierre;
	}

	/**
	 * Method 'getFechaUltNotificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltNotificacion() {
		return this.fechaUltNotificacion;
	}

	/**
	 * Method 'setFechaUltNotificacion'.
	 *
	 * @param fechaUltNotificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltNotificacion(Date fechaUltNotificacion) {
		this.fechaUltNotificacion = fechaUltNotificacion;
	}

	/**
	 * Method 'getFechaUltInspeccion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltInspeccion() {
		return this.fechaUltInspeccion;
	}

	/**
	 * Method 'setFechaUltInspeccion'.
	 *
	 * @param fechaUltInspeccion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltInspeccion(Date fechaUltInspeccion) {
		this.fechaUltInspeccion = fechaUltInspeccion;
	}

	/**
	 * Method 'getFechaProInspeccion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaProInspeccion() {
		return this.fechaProInspeccion;
	}

	/**
	 * Method 'setFechaProInspeccion'.
	 *
	 * @param fechaProInspeccion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaProInspeccion(Date fechaProInspeccion) {
		this.fechaProInspeccion = fechaProInspeccion;
	}

	/**
	 * Method 'getFechaUltActualizacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltActualizacion() {
		return this.fechaUltActualizacion;
	}

	/**
	 * Method 'setFechaUltActualizacion'.
	 *
	 * @param fechaUltActualizacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltActualizacion(Date fechaUltActualizacion) {
		this.fechaUltActualizacion = fechaUltActualizacion;
	}

	/**
	 * Method 'getFechaClausura'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaClausura() {
		return this.fechaClausura;
	}

	/**
	 * Method 'setFechaClausura'.
	 *
	 * @param fechaClausura
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaClausura(Date fechaClausura) {
		this.fechaClausura = fechaClausura;
	}

	/**
	 * Method 'getFechaUltReforma'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltReforma() {
		return this.fechaUltReforma;
	}

	/**
	 * Method 'setFechaUltReforma'.
	 *
	 * @param fechaUltReforma
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltReforma(Date fechaUltReforma) {
		this.fechaUltReforma = fechaUltReforma;
	}

	/**
	 * Method 'getEliminado'.
	 *
	 * @return String
	 */

	public String getEliminado() {
		return this.eliminado;
	}

	/**
	 * Method 'setEliminado'.
	 *
	 * @param eliminado
	 *            String
	 * @return
	 */

	public void setEliminado(String eliminado) {
		this.eliminado = eliminado;
	}

	/**
	 * Method 'getExpedienteb29'.
	 *
	 * @return String
	 */

	public String getExpedienteb29() {
		return this.expedienteb29;
	}

	/**
	 * Method 'setExpedienteb29'.
	 *
	 * @param expedienteb29
	 *            String
	 * @return
	 */

	public void setExpedienteb29(String expedienteb29) {
		this.expedienteb29 = expedienteb29;
	}

	/**
	 * Method 'getIdPortalS41'.
	 *
	 * @return Long
	 */

	public Long getIdPortalS41() {
		return this.idPortalS41;
	}

	/**
	 * Method 'setIdPortalS41'.
	 *
	 * @param idPortalS41
	 *            Long
	 * @return
	 */

	public void setIdPortalS41(Long idPortalS41) {
		this.idPortalS41 = idPortalS41;
	}

	/**
	 * Method 'getUrlPortalS41'.
	 *
	 * @return String
	 */

	public String getUrlPortalS41() {
		return this.urlPortalS41;
	}

	/**
	 * Method 'setUrlPortalS41'.
	 *
	 * @param urlPortalS41
	 *            String
	 * @return
	 */

	public void setUrlPortalS41(String urlPortalS41) {
		this.urlPortalS41 = urlPortalS41;
	}

	/**
	 * Method 'getFechaControlS41'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaControlS41() {
		return this.fechaControlS41;
	}

	/**
	 * Method 'setFechaControlS41'.
	 *
	 * @param fechaControlS41
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaControlS41(Date fechaControlS41) {
		this.fechaControlS41 = fechaControlS41;
	}

	/**
	 * Method 'getNumInstalacionAnterior'.
	 *
	 * @return String
	 */

	public String getNumInstalacionAnterior() {
		return this.numInstalacionAnterior;
	}

	/**
	 * Method 'setNumInstalacionAnterior'.
	 *
	 * @param numInstalacionAnterior
	 *            String
	 * @return
	 */

	public void setNumInstalacionAnterior(String numInstalacionAnterior) {
		this.numInstalacionAnterior = numInstalacionAnterior;
	}

	/**
	 * Method 'getFechaInscripcion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaInscripcion() {
		return this.fechaInscripcion;
	}

	/**
	 * Method 'setFechaInscripcion'.
	 *
	 * @param fechaInscripcion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaInscripcion(Date fechaInscripcion) {
		this.fechaInscripcion = fechaInscripcion;
	}

	/**
	 * Method 'getNumInstalacionWz'.
	 *
	 * @return String
	 */

	public String getNumInstalacionWz() {
		return this.numInstalacionWz;
	}

	/**
	 * Method 'setNumInstalacionWz'.
	 *
	 * @param numInstalacionWz
	 *            String
	 * @return
	 */

	public void setNumInstalacionWz(String numInstalacionWz) {
		this.numInstalacionWz = numInstalacionWz;
	}

	/**
	 * Method 'getObservaciones2'.
	 *
	 * @return String
	 */

	public String getObservaciones2() {
		return this.observaciones2;
	}

	/**
	 * Method 'setObservaciones2'.
	 *
	 * @param observaciones2
	 *            String
	 * @return
	 */

	public void setObservaciones2(String observaciones2) {
		this.observaciones2 = observaciones2;
	}

	/**
	 * Method 'getNotasMigracion'.
	 *
	 * @return String
	 */

	public String getNotasMigracion() {
		return this.notasMigracion;
	}

	/**
	 * Method 'setNotasMigracion'.
	 *
	 * @param notasMigracion
	 *            String
	 * @return
	 */

	public void setNotasMigracion(String notasMigracion) {
		this.notasMigracion = notasMigracion;
	}

	/**
	 * Method 'getAgrupacion'.
	 *
	 * @return String
	 */

	public String getAgrupacion() {
		return this.agrupacion;
	}

	/**
	 * Method 'setAgrupacion'.
	 *
	 * @param agrupacion
	 *            String
	 * @return
	 */

	public void setAgrupacion(String agrupacion) {
		this.agrupacion = agrupacion;
	}

	/**
	 * Method 'getRefCatastral'.
	 *
	 * @return String
	 */

	public String getRefCatastral() {
		return this.refCatastral;
	}

	/**
	 * Method 'setRefCatastral'.
	 *
	 * @param refCatastral
	 *            String
	 * @return
	 */

	public void setRefCatastral(String refCatastral) {
		this.refCatastral = refCatastral;
	}

	/**
	 * Method 'getObsSegrespcivil'.
	 *
	 * @return String
	 */

	public String getObsSegrespcivil() {
		return this.obsSegrespcivil;
	}

	/**
	 * Method 'setObsSegrespcivil'.
	 *
	 * @param obsSegrespcivil
	 *            String
	 * @return
	 */

	public void setObsSegrespcivil(String obsSegrespcivil) {
		this.obsSegrespcivil = obsSegrespcivil;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public String getIdExpediente() {
		return idExpediente;
	}

	public void setIdExpediente(String idExpediente) {
		this.idExpediente = idExpediente;
	}

	public String getTipoBusqueda() {
		return tipoBusqueda;
	}

	public void setTipoBusqueda(String tipoBusqueda) {
		this.tipoBusqueda = tipoBusqueda;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idEstablecimiento: ").append(this.idEstablecimiento).append(" ]");
		result.append(", [ identificadorEstablecimiento: ").append(this.identificadorEstablecimiento).append(" ]");
		result.append(", [ descNombre: ").append(this.descrNombre).append(" ]");
		result.append(", [ visibleweb: ").append(this.visibleweb).append(" ]");
		result.append(", [ temporada: ").append(this.temporada).append(" ]");
		result.append(", [ urlweb: ").append(this.urlweb).append(" ]");
		result.append(", [ idDefectos: ").append(this.idDefectos).append(" ]");
		result.append(", [ numUnidadesAlojamiento: ").append(this.numUnidadesAlojamiento).append(" ]");
		result.append(", [ observaciones: ").append(this.observaciones).append(" ]");
		result.append(", [ fechaApertura: ").append(this.fechaApertura).append(" ]");
		result.append(", [ fechaBaja: ").append(this.fechaBaja).append(" ]");
		result.append(", [ fechaInicierretemp: ").append(this.fechaInicierretemp).append(" ]");
		result.append(", [ fechaFincierretemp: ").append(this.fechaFincierretemp).append(" ]");
		result.append(", [ fechaVctoCierre: ").append(this.fechaVctoCierre).append(" ]");
		result.append(", [ fechaUltNotificacion: ").append(this.fechaUltNotificacion).append(" ]");
		result.append(", [ fechaUltInspeccion: ").append(this.fechaUltInspeccion).append(" ]");
		result.append(", [ fechaProInspeccion: ").append(this.fechaProInspeccion).append(" ]");
		result.append(", [ fechaUltActualizacion: ").append(this.fechaUltActualizacion).append(" ]");
		result.append(", [ fechaClausura: ").append(this.fechaClausura).append(" ]");
		result.append(", [ fechaUltReforma: ").append(this.fechaUltReforma).append(" ]");
		result.append(", [ eliminado: ").append(this.eliminado).append(" ]");
		result.append(", [ expedienteb29: ").append(this.expedienteb29).append(" ]");
		result.append(", [ idPortalS41: ").append(this.idPortalS41).append(" ]");
		result.append(", [ urlPortalS41: ").append(this.urlPortalS41).append(" ]");
		result.append(", [ fechaControlS41: ").append(this.fechaControlS41).append(" ]");
		result.append(", [ numInstalacionAnterior: ").append(this.numInstalacionAnterior).append(" ]");
		result.append(", [ fechaInscripcion: ").append(this.fechaInscripcion).append(" ]");
		result.append(", [ numInstalacionWz: ").append(this.numInstalacionWz).append(" ]");
		result.append(", [ observaciones2: ").append(this.observaciones2).append(" ]");
		result.append(", [ notasMigracion: ").append(this.notasMigracion).append(" ]");
		result.append(", [ agrupacion: ").append(this.agrupacion).append(" ]");
		result.append(", [ refCatastral: ").append(this.refCatastral).append(" ]");
		result.append(", [ obsSegrespcivil: ").append(this.obsSegrespcivil).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public Integer getIncluirSucursales() {
		return incluirSucursales;
	}

	public void setIncluirSucursales(Integer incluirSucursales) {
		this.incluirSucursales = incluirSucursales;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUltimaInspeccionDesde() {
		return ultimaInspeccionDesde;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUltimaInspeccionDesde(Date ultimaInspeccionDesde) {
		this.ultimaInspeccionDesde = ultimaInspeccionDesde;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUltimaInspeccionHasta() {
		return ultimaInspeccionHasta;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUltimaInspeccionHasta(Date ultimaInspeccionHasta) {
		this.ultimaInspeccionHasta = ultimaInspeccionHasta;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUltimaModificacionDesde() {
		return ultimaModificacionDesde;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUltimaModificacionDesde(Date ultimaModificacionDesde) {
		this.ultimaModificacionDesde = ultimaModificacionDesde;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getUltimaModificacionHasta() {
		return ultimaModificacionHasta;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setUltimaModificacionHasta(Date ultimaModificacionHasta) {
		this.ultimaModificacionHasta = ultimaModificacionHasta;
	}

	public String getTelefono() {
		return telefono;
	}

	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	public String getCorreoElectronico() {
		return correoElectronico;
	}

	public void setCorreoElectronico(String correoElectronico) {
		this.correoElectronico = correoElectronico;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAperturaHasta() {
		return aperturaHasta;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAperturaHasta(Date aperturaHasta) {
		this.aperturaHasta = aperturaHasta;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getAperturaDesde() {
		return aperturaDesde;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setAperturaDesde(Date aperturaDesde) {
		this.aperturaDesde = aperturaDesde;
	}

	public String getCIE() {
		return CIE;
	}

	public void setCIE(String cIE) {
		CIE = cIE;
	}

	public Integer getMostrar() {
		return mostrar;
	}

	public void setMostrar(Integer mostrar) {
		this.mostrar = mostrar;
	}

	public Integer getPais() {
		return pais;
	}

	public void setPais(Integer pais) {
		this.pais = pais;
	}

	public DatosTerceros getDatosTerceros() {
		return datosTerceros;
	}

	public void setDatosTerceros(DatosTerceros datosTerceros) {
		this.datosTerceros = datosTerceros;
	}

	public String getCorreoElectronicoBusqueda() {
		return correoElectronicoBusqueda;
	}

	public void setCorreoElectronicoBusqueda(String correoElectronicoBusqueda) {
		this.correoElectronicoBusqueda = correoElectronicoBusqueda;
	}

	public String getTelefonoBusqueda() {
		return telefonoBusqueda;
	}

	public void setTelefonoBusqueda(String telefonoBusqueda) {
		this.telefonoBusqueda = telefonoBusqueda;
	}

	public DatosDirecciones getDatosDirecciones() {
		return datosDirecciones;
	}

	public void setDatosDirecciones(DatosDirecciones datosDirecciones) {
		this.datosDirecciones = datosDirecciones;
	}

	public String getTipoRegistro() {
		return tipoRegistro;
	}

	public void setTipoRegistro(String tipoRegistro) {
		this.tipoRegistro = tipoRegistro;
	}

	public String getIdEstablecimientoPadre() {
		return idEstablecimientoPadre;
	}

	public void setIdEstablecimientoPadre(String idEstablecimientoPadre) {
		this.idEstablecimientoPadre = idEstablecimientoPadre;
	}

	public String getIdentificadorSolicitud() {
		return identificadorSolicitud;
	}

	public void setIdentificadorSolicitud(String identificadorSolicitud) {
		this.identificadorSolicitud = identificadorSolicitud;
	}

	public String getAutocompleteEstablecimiento() {
		return autocompleteEstablecimiento;
	}

	public void setAutocompleteEstablecimiento(String autocompleteEstablecimiento) {
		this.autocompleteEstablecimiento = autocompleteEstablecimiento;
	}

	public String getPeriodoPuentes() {
		return periodoPuentes;
	}

	public void setPeriodoPuentes(String periodoPuentes) {
		this.periodoPuentes = periodoPuentes;
	}

	public String getPeriodoVacaciones() {
		return periodoVacaciones;
	}

	public void setPeriodoVacaciones(String periodoVacaciones) {
		this.periodoVacaciones = periodoVacaciones;
	}

	public String getPeriodoVerano() {
		return periodoVerano;
	}

	public void setPeriodoVerano(String periodoVerano) {
		this.periodoVerano = periodoVerano;
	}

	public String getSinPeriodoPref() {
		return sinPeriodoPref;
	}

	public void setSinPeriodoPref(String sinPeriodoPref) {
		this.sinPeriodoPref = sinPeriodoPref;
	}

	public String getTelefonoPromo() {
		return telefonoPromo;
	}

	public void setTelefonoPromo(String telefonoPromo) {
		this.telefonoPromo = telefonoPromo;
	}

	public boolean hasType() {
		return this.tipoEstablecimiento != null && this.tipoEstablecimiento.getIdTipoEstablecimiento() != null;
	}

	public boolean isType(String tipo) {
		return hasType() && this.tipoEstablecimiento.getIdTipoEstablecimiento().equalsIgnoreCase(tipo);
	}

	public int getUsoResidentes() {
		return usoResidentes;
	}

	public void setUsoResidentes(int usoResidentes) {
		this.usoResidentes = usoResidentes;
	}

	public int getUsoTuristico() {
		return usoTuristico;
	}

	public void setUsoTuristico(int usoTuristico) {
		this.usoTuristico = usoTuristico;
	}

	public String getModifEsencial() {
		return modifEsencial;
	}

	public void setModifEsencial(String modifEsencial) {
		this.modifEsencial = modifEsencial;
	}

	public String getDireccionCompuesta() {
		return direccionCompuesta;
	}

	public void setDireccionCompuesta(String direccionCompuesta) {
		this.direccionCompuesta = direccionCompuesta;
	}

	public Boolean istOnlyTerActivos() {
		return onlyTerActivos;
	}

	public void setOnlyTerActivos(Boolean onlyTerActivos) {
		this.onlyTerActivos = onlyTerActivos;
	}

	public boolean isOnlyTitularIfExists() {
		return onlyTitularIfExists;
	}

	public void setOnlyTitularIfExists(boolean onlyTitularIfExists) {
		this.onlyTitularIfExists = onlyTitularIfExists;
	}

	public String getTipoEstSignaturaFilter() {
		return tipoEstSignaturaFilter;
	}

	public void setTipoEstSignaturaFilter(String tipoEstSignaturaFilter) {
		this.tipoEstSignaturaFilter = tipoEstSignaturaFilter;
	}

	public String getZonaSignaturaFilter() {
		return zonaSignaturaFilter;
	}

	public void setZonaSignaturaFilter(String zonaSignaturaFilter) {
		this.zonaSignaturaFilter = zonaSignaturaFilter;
	}

	public String getCorrelativoSignaturaFilter() {
		return correlativoSignaturaFilter;
	}

	public void setCorrelativoSignaturaFilter(String correlativoSignaturaFilter) {
		this.correlativoSignaturaFilter = correlativoSignaturaFilter;
	}

	/**
	 * @return the idestabSolic
	 */
	public String getIdestabSolic() {
		return idestabSolic;
	}

	/**
	 * @param idestabSolic
	 *            the idestabSolic to set
	 */
	public void setIdestabSolic(String idestabSolic) {
		this.idestabSolic = idestabSolic;
	}

	/**
	 * @return the thActividad
	 */
	public String getThActividad() {
		return thActividad;
	}

	/**
	 * @param thActividad
	 *            the thActividad to set
	 */
	public void setThActividad(String thActividad) {
		this.thActividad = thActividad;
	}

	/**
	 * @return the canModIdestabSolic
	 */
	public String getCanModIdestabSolic() {
		return canModIdestabSolic;
	}

	/**
	 * @param canModIdestabSolic
	 *            the canModIdestabSolic to set
	 */
	public void setCanModIdestabSolic(String canModIdestabSolic) {
		this.canModIdestabSolic = canModIdestabSolic;
	}

}
