package com.ejie.ab78.model.denuncias;

import java.util.Date;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilDate;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class ExpedienteDenuncia implements java.io.Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Long idExpediente;
	private String folderId;
	private String folderNumber;
	private Integer idReclamacion;
	private Long numAnyo;
	private Long numReclamacion;
	private String numDenunciaFormateado;
	private Date fechaPresentacion;
	private String denunciante;
	private String nombreAfectados;
	private String nombreDenunciante;
	private String apellido1Denunciante;
	private String apellido2Denunciante;
	private String denunciado;
	private String nombreDenunciado;
	private String apellido1Denunciado;
	private String apellido2Denunciado;
	private String direccionDenunciado;
	private String codigoPostalDenunciado;
	private String idProvincia;
	private String provinciaDenunciado;
	private String municipioDenunciado;
	private String localidadDenunciado;

	private Integer idInspeccion;
	private String identificadorInspeccion;
	private String descDecisionES;
	private String descDecisionEU;

	private ExpedienteDenunciaFilter filter;

	/**
	 * Method 'ExpedienteDenuncia'.
	 */
	public ExpedienteDenuncia() {
	}

	public Long getIdExpediente() {
		return idExpediente;
	}

	public void setIdExpediente(Long idExpediente) {
		this.idExpediente = idExpediente;
	}

	public String getFolderId() {
		return folderId;
	}

	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	public String getFolderNumber() {
		return folderNumber;
	}

	public void setFolderNumber(String folderNumber) {
		this.folderNumber = folderNumber;
	}

	public Integer getIdReclamacion() {
		return idReclamacion;
	}

	public void setIdReclamacion(Integer idReclamacion) {
		this.idReclamacion = idReclamacion;
	}

	public Long getNumAnyo() {
		return numAnyo;
	}

	public void setNumAnyo(Long numAnyo) {
		this.numAnyo = numAnyo;
	}

	public Long getNumReclamacion() {
		return numReclamacion;
	}

	public void setNumReclamacion(Long numReclamacion) {
		this.numReclamacion = numReclamacion;
	}

	public String getNumDenunciaFormateado() {
		return numDenunciaFormateado;
	}

	public void setNumDenunciaFormateado(Long numAnyo, Long numReclamacion) {

		StringBuilder title = new StringBuilder();

		String strNumAnyo = numAnyo != null ? String.valueOf(numAnyo) : "";
		String strNumReclamacion = numReclamacion != null ? String.format("%05d", numReclamacion) : "";

		title.append(strNumAnyo).append("-");
		if (idExpediente != null && idExpediente > 0) {
			if (this.idProvincia != null) {
				title.append(Constantes.getMapaTTHH().get(this.idProvincia)).append("-");
			}
		}
		title.append(strNumReclamacion);
		this.numDenunciaFormateado = title.toString();
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public Date getFechaPresentacion() {
		return fechaPresentacion;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public void setFechaPresentacion(Date fechaPresentacion) {
		this.fechaPresentacion = fechaPresentacion;
	}

	public String getDenunciante() {
		return denunciante;
	}

	public void setDenunciante(String nombreDenunciante, String apellido1Denunciante, String apellido2Denunciante) {
		this.denunciante = nombreDenunciante + " " + apellido1Denunciante + " " + apellido2Denunciante;
	}

	public String getNombreDenunciante() {
		return nombreDenunciante;
	}

	public void setNombreDenunciante(String nombreDenunciante) {
		this.nombreDenunciante = nombreDenunciante;
	}

	public String getApellido1Denunciante() {
		return apellido1Denunciante;
	}

	public void setApellido1Denunciante(String apellido1Denunciante) {
		this.apellido1Denunciante = apellido1Denunciante;
	}

	public String getApellido2Denunciante() {
		return apellido2Denunciante;
	}

	public void setApellido2Denunciante(String apellido2Denunciante) {
		this.apellido2Denunciante = apellido2Denunciante;
	}

	public String getDenunciado() {
		return denunciado;
	}

	public void setDenunciado(String nombreDenunciado) {
		this.denunciado = nombreDenunciado;
	}

	public String getNombreDenunciado() {
		return nombreDenunciado;
	}

	public void setNombreDenunciado(String nombreDenunciado) {
		this.nombreDenunciado = nombreDenunciado;
	}

	public String getApellido1Denunciado() {
		return apellido1Denunciado;
	}

	public void setApellido1Denunciado(String apellido1Denunciado) {
		this.apellido1Denunciado = apellido1Denunciado;
	}

	public String getApellido2Denunciado() {
		return apellido2Denunciado;
	}

	public void setApellido2Denunciado(String apellido2Denunciado) {
		this.apellido2Denunciado = apellido2Denunciado;
	}

	public String getDireccionDenunciado() {
		return direccionDenunciado;
	}

	public void setDireccionDenunciado(String direccionDenunciado) {
		this.direccionDenunciado = direccionDenunciado;
	}

	public String getCodigoPostalDenunciado() {
		return codigoPostalDenunciado;
	}

	public void setCodigoPostalDenunciado(String codigoPostalDenunciado) {
		this.codigoPostalDenunciado = codigoPostalDenunciado;
	}

	public String getProvinciaDenunciado() {
		return provinciaDenunciado;
	}

	public void setProvinciaDenunciado(String provinciaDenunciado) {
		this.provinciaDenunciado = provinciaDenunciado;
	}

	public String getMunicipioDenunciado() {
		return municipioDenunciado;
	}

	public void setMunicipioDenunciado(String municipioDenunciado) {
		this.municipioDenunciado = municipioDenunciado;
	}

	public String getLocalidadDenunciado() {
		return localidadDenunciado;
	}

	public void setLocalidadDenunciado(String localidadDenunciado) {
		this.localidadDenunciado = localidadDenunciado;
	}

	public ExpedienteDenunciaFilter getFilter() {
		return filter;
	}

	public void setFilter(ExpedienteDenunciaFilter filter) {
		this.filter = filter;
	}

	public String getIdProvincia() {
		return idProvincia;
	}

	public void setIdProvincia(String idProvincia) {
		this.idProvincia = idProvincia;
	}

	public String getDenunciadoFormateado() {
		StringBuilder builder = new StringBuilder();
		if (nombreDenunciado != null && !"".equalsIgnoreCase(nombreDenunciado)) {
			builder.append(nombreDenunciado);
		}
		if (apellido1Denunciado != null && !"".equalsIgnoreCase(apellido1Denunciado)) {
			builder.append(" ").append(apellido1Denunciado);
		}
		if (apellido2Denunciado != null && !"".equalsIgnoreCase(apellido2Denunciado)) {
			builder.append(" ").append(apellido2Denunciado);
		}
		return builder.toString();
	}

	public String getFechaPresentacionFormateada() {
		if (fechaPresentacion == null) {
			return "";
		}
		return UtilDate.convertirEnFecha(fechaPresentacion);
	}

	public String getNombreAfectados() {
		return nombreAfectados;
	}

	public void setNombreAfectados(String nombreAfectados) {
		this.nombreAfectados = nombreAfectados;
	}

	public Integer getIdInspeccion() {
		return idInspeccion;
	}

	public void setIdInspeccion(Integer idInspeccion) {
		this.idInspeccion = idInspeccion;
	}

	public String getIdentificadorInspeccion() {
		return identificadorInspeccion;
	}

	public void setIdentificadorInspeccion(String identificadorInspeccion) {
		this.identificadorInspeccion = identificadorInspeccion;
	}

	public String getDescDecisionES() {
		return descDecisionES;
	}

	public void setDescDecisionES(String descDecisionES) {
		this.descDecisionES = descDecisionES;
	}

	public String getDescDecisionEU() {
		return descDecisionEU;
	}

	public void setDescDecisionEU(String descDecisionEU) {
		this.descDecisionEU = descDecisionEU;
	}

}
