package com.ejie.ab78.model.denuncias;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;

/**
 * DocumentoDenunciaNoFormal  
 * 
 *  
 */

public class DocumentoDenunciaNoFormal implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDocumento;
	private DenunciaNoFormal denunciaNoFormal;
	private String oid;
	private String nombre;
	private String descripcion;
	private Date fechaAlta;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;

	private byte[] blobArchivo;
	private String nombreArchivo;
	private String mimeType;
	private String rutaPif;

	/**
	 * Method 'DocumentoDenunciaNoFormal'.
	 */
	public DocumentoDenunciaNoFormal() {
	}

	/**
	 * Method 'DocumentoDenunciaNoFormal'.
	 * 
	 * @param idDocumento
	 *            Integer
	 */
	public DocumentoDenunciaNoFormal(Integer idDocumento) {
		this.idDocumento = idDocumento;
	}

	/**
	 * Method 'DocumentoDenunciaNoFormal'.
	 * 
	 * @param idDocumento
	 *            Integer
	 * @param oid
	 *            String
	 * @param nombre
	 *            String
	 * @param descripcion
	 *            String
	 * @param fechaAlta
	 *            Date
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 * @param denunciaNoFormal
	 *            DenunciaNoFormal
	 */
	public DocumentoDenunciaNoFormal(Integer idDocumento, String oid, String nombre, String descripcion, Date fechaAlta,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			DenunciaNoFormal denunciaNoFormal) {

		this.idDocumento = idDocumento;
		this.denunciaNoFormal = denunciaNoFormal;
		this.oid = oid;
		this.nombre = nombre;
		this.descripcion = descripcion;
		this.fechaAlta = fechaAlta;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdDocumento'.
	 *
	 * @return Integer
	 */

	public Integer getIdDocumento() {
		return this.idDocumento;
	}

	/**
	 * Method 'setIdDocumento'.
	 *
	 * @param idDocumento
	 *            Integer
	 * @return
	 */

	public void setIdDocumento(Integer idDocumento) {
		this.idDocumento = idDocumento;
	}

	/**
	 * Method 'getDenunciaNoFormal'.
	 *
	 * @return DenunciaNoFormal
	 */

	public DenunciaNoFormal getDenunciaNoFormal() {
		return this.denunciaNoFormal;
	}

	/**
	 * Method 'setDenunciaNoFormal'.
	 *
	 * @param denunciaNoFormal
	 *            DenunciaNoFormal
	 * @return
	 */

	public void setDenunciaNoFormal(DenunciaNoFormal denunciaNoFormal) {
		this.denunciaNoFormal = denunciaNoFormal;
	}

	/**
	 * Method 'getOid'.
	 *
	 * @return String
	 */

	public String getOid() {
		return this.oid;
	}

	/**
	 * Method 'setOid'.
	 *
	 * @param oid
	 *            String
	 * @return
	 */

	public void setOid(String oid) {
		this.oid = oid;
	}

	/**
	 * Method 'getNombre'.
	 *
	 * @return String
	 */

	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Method 'setNombre'.
	 *
	 * @param nombre
	 *            String
	 * @return
	 */

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Method 'getDescripcion'.
	 *
	 * @return String
	 */

	public String getDescripcion() {
		return this.descripcion;
	}

	/**
	 * Method 'setDescripcion'.
	 *
	 * @param descripcion
	 *            String
	 * @return
	 */

	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * Method 'getFechaAlta'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaAlta() {
		return this.fechaAlta;
	}

	/**
	 * Method 'setFechaAlta'.
	 *
	 * @param fechaAlta
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaAlta(Date fechaAlta) {
		this.fechaAlta = fechaAlta;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public byte[] getBlobArchivo() {
		return blobArchivo;
	}

	public void setBlobArchivo(byte[] blobArchivo) {
		this.blobArchivo = blobArchivo;
	}

	public String getRutaPif() {
		return rutaPif;
	}

	public void setRutaPif(String rutaPif) {
		this.rutaPif = rutaPif;
	}

	public String getNombreArchivo() {
		return nombreArchivo;
	}

	public void setNombreArchivo(String nombreArchivo) {
		this.nombreArchivo = nombreArchivo;
	}

	public String getMimeType() {
		return mimeType;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idDocumento: ").append(this.idDocumento).append(" ]");
		result.append(", [ oid: ").append(this.oid).append(" ]");
		result.append(", [ nombre: ").append(this.nombre).append(" ]");
		result.append(", [ descripcion: ").append(this.descripcion).append(" ]");
		result.append(", [ fechaAlta: ").append(this.fechaAlta).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

}
