package com.ejie.ab78.model.denuncias;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab78.model.InfoEstablecimiento;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.maestros.Decision;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * DenunciaNoFormal  
 * 
 *  
 */

public class DenunciaNoFormal implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idDenuncia;
	private String numDenuncia;
	private String idProvinciaTthh;
	private Date fechaPresentacion;
	private Integer idTerceroDenunciante;
	private DatosTerceros denunciante;
	private String nombreComercialDenunciado;
	private Integer idDireccionDenunciado;
	private DatosDirecciones direccionDenunciado;
	private String asuntoHechosDenuncia;
	private String descHechosDenuncia;

	private Decision decisionTomada;
	private String accionTomadaOtros;

	private Expedientes expediente;
	private Integer idExpediente;
	private String folderId;
	private String folderNumber;
	private String tituloExpediente;

	private Integer idInspeccion;
	private String identificadorInspeccion;

	private InfoEstablecimiento infoEstablecimiento;
	private String identificadorEstablecimiento;

	private String indEliminado;

	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;
	private List<IrregularidadDenuncia> irregularidadDenuncias = new ArrayList<IrregularidadDenuncia>();

	private Date fechaPresentacionDesde;
	private Date fechaPresentacionHasta;

	private String parteLetra;
	private String parteProv;
	private String parteSequencia;

	private List<String> checkIrregularidad = new ArrayList<String>();

	/**
	 * Method 'DenunciaNoFormal'.
	 */
	public DenunciaNoFormal() {
	}

	/**
	 * Method 'DenunciaNoFormal'.
	 * 
	 * @param idDenuncia
	 *            Integer
	 */
	public DenunciaNoFormal(Integer idDenuncia) {
		this.idDenuncia = idDenuncia;
	}

	/**
	 * Method 'DenunciaNoFormal'.
	 * 
	 * @param idDenuncia
	 *            Integer
	 * @param numDenuncia
	 *            String
	 * @param idProvinciaTthh
	 *            String
	 * @param fechaPresentacion
	 *            Date
	 * @param idTerceroDenunciante
	 *            Integer
	 * @param nombreComercialDenunciado
	 *            String
	 * @param idDireccionDenunciado
	 *            Integer
	 * @param asuntoHechosDenuncia
	 *            String
	 * @param descHechosDenuncia
	 *            String
	 * @param idExpediente
	 *            Integer
	 * @param folderNumber
	 *            String
	 * @param decisionTomada
	 *            String
	 * @param idInspeccion
	 *            Integer
	 * @param identificadorInspeccion
	 *            String
	 * @param identificadorEstablecimiento
	 *            String
	 * @param indEliminado
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public DenunciaNoFormal(Integer idDenuncia, String numDenuncia, String idProvinciaTthh, Date fechaPresentacion,
			Integer idTerceroDenunciante, String nombreComercialDenunciado, Integer idDireccionDenunciado,
			String asuntoHechosDenuncia, String descHechosDenuncia, String folderId, Decision accionTomada,
			String accionTomadaOtros, String identificadorInspeccion, String identificadorEstablecimiento,
			String indEliminado, Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion,
			String usuarioUltmodificacion) {
		this.idDenuncia = idDenuncia;
		this.numDenuncia = numDenuncia;
		this.idProvinciaTthh = idProvinciaTthh;
		this.fechaPresentacion = fechaPresentacion;
		this.idTerceroDenunciante = idTerceroDenunciante;
		this.nombreComercialDenunciado = nombreComercialDenunciado;
		this.idDireccionDenunciado = idDireccionDenunciado;
		this.asuntoHechosDenuncia = asuntoHechosDenuncia;
		this.descHechosDenuncia = descHechosDenuncia;
		this.folderId = folderId;

		this.decisionTomada = accionTomada;
		this.accionTomadaOtros = accionTomadaOtros;

		this.identificadorInspeccion = identificadorInspeccion;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.indEliminado = indEliminado;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'DenunciaNoFormal'.
	 * 
	 * @param idDenuncia
	 *            Integer
	 * @param numDenuncia
	 *            String
	 * @param idProvinciaTthh
	 *            String
	 * @param fechaPresentacion
	 *            Date
	 * @param idTerceroDenunciante
	 *            Integer
	 * @param nombreComercialDenunciado
	 *            String
	 * @param idDireccionDenunciado
	 *            Integer
	 * @param asuntoHechosDenuncia
	 *            String
	 * @param descHechosDenuncia
	 *            String
	 * @param idExpediente
	 *            Integer
	 * @param folderNumber
	 *            String
	 * @param decisionTomada
	 *            String
	 * @param idInspeccion
	 *            Integer
	 * @param identificadorInspeccion
	 *            String
	 * @param identificadorEstablecimiento
	 *            String
	 * @param indEliminado
	 *            String
	 * @param fechaRegistro
	 *            Date
	 * @param usuarioRegistro
	 *            String
	 * @param fechaUltmodificacion
	 *            Date
	 * @param usuarioUltmodificacion
	 *            String
	 */
	public DenunciaNoFormal(Integer idDenuncia, String numDenuncia, String idProvinciaTthh, Date fechaPresentacion,
			Integer idTerceroDenunciante, String nombreComercialDenunciado, DatosDirecciones direccionDenunciado,
			String asuntoHechosDenuncia, String descHechosDenuncia, Integer idExpediente, String folderNumber,
			String folderId, String tituloExp, Decision accionTomada, String accionTomadaOtros, Integer idInspeccion,
			String identificadorInspeccion, String identificadorEstablecimiento, String indEliminado,
			Date fechaRegistro, String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion) {
		this.idDenuncia = idDenuncia;
		this.numDenuncia = numDenuncia;
		this.idProvinciaTthh = idProvinciaTthh;
		this.fechaPresentacion = fechaPresentacion;
		this.idTerceroDenunciante = idTerceroDenunciante;
		this.nombreComercialDenunciado = nombreComercialDenunciado;
		this.direccionDenunciado = direccionDenunciado;
		this.asuntoHechosDenuncia = asuntoHechosDenuncia;
		this.descHechosDenuncia = descHechosDenuncia;
		this.idExpediente = idExpediente;
		this.folderNumber = folderNumber;
		this.folderId = folderId;
		this.tituloExpediente = tituloExp;
		this.decisionTomada = accionTomada;
		this.setAccionTomadaOtros(accionTomadaOtros);
		this.idInspeccion = idInspeccion;
		this.identificadorInspeccion = identificadorInspeccion;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.indEliminado = indEliminado;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	/**
	 * Method 'getIdDenuncia'.
	 *
	 * @return Integer
	 */

	public Integer getIdDenuncia() {
		return this.idDenuncia;
	}

	/**
	 * Method 'setIdDenuncia'.
	 *
	 * @param idDenuncia
	 *            Integer
	 * @return
	 */

	public void setIdDenuncia(Integer idDenuncia) {
		this.idDenuncia = idDenuncia;
	}

	/**
	 * Method 'getNumDenuncia'.
	 *
	 * @return String
	 */

	public String getNumDenuncia() {
		return this.numDenuncia;
	}

	/**
	 * Method 'setNumDenuncia'.
	 *
	 * @param numDenuncia
	 *            String
	 * @return
	 */

	public void setNumDenuncia(String numDenuncia) {
		this.numDenuncia = numDenuncia;
	}

	/**
	 * Method 'getIdProvinciaTthh'.
	 *
	 * @return String
	 */

	public String getIdProvinciaTthh() {
		return this.idProvinciaTthh;
	}

	/**
	 * Method 'setIdProvinciaTthh'.
	 *
	 * @param idProvinciaTthh
	 *            String
	 * @return
	 */

	public void setIdProvinciaTthh(String idProvinciaTthh) {
		this.idProvinciaTthh = idProvinciaTthh;
	}

	/**
	 * Method 'getFechaPresentacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPresentacion() {
		return this.fechaPresentacion;
	}

	/**
	 * Method 'setFechaPresentacion'.
	 *
	 * @param fechaPresentacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPresentacion(Date fechaPresentacion) {
		this.fechaPresentacion = fechaPresentacion;
	}

	/**
	 * Method 'getFechaPresentacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPresentacionDesde() {
		return this.fechaPresentacionDesde;
	}

	/**
	 * Method 'setFechaPresentacion'.
	 *
	 * @param fechaPresentacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPresentacionDesde(Date fechaPresentacionDesde) {
		this.fechaPresentacionDesde = fechaPresentacionDesde;
	}

	/**
	 * Method 'getFechaPresentacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPresentacionHasta() {
		return this.fechaPresentacionHasta;
	}

	/**
	 * Method 'setFechaPresentacion'.
	 *
	 * @param fechaPresentacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPresentacionHasta(Date fechaPresentacionHasta) {
		this.fechaPresentacionHasta = fechaPresentacionHasta;
	}

	public DatosTerceros getDenunciante() {
		return denunciante;
	}

	public void setDenunciante(DatosTerceros denunciante) {
		this.denunciante = denunciante;
	}

	/**
	 * Method 'getIdTerceroDenunciante'.
	 *
	 * @return Integer
	 */

	public Integer getIdTerceroDenunciante() {
		return this.idTerceroDenunciante;
	}

	/**
	 * Method 'setIdTerceroDenunciante'.
	 *
	 * @param idTerceroDenunciante
	 *            Integer
	 * @return
	 */

	public void setIdTerceroDenunciante(Integer idTerceroDenunciante) {
		this.idTerceroDenunciante = idTerceroDenunciante;
	}

	/**
	 * Method 'getNombreComercialDenunciado'.
	 *
	 * @return String
	 */

	public String getNombreComercialDenunciado() {
		return this.nombreComercialDenunciado;
	}

	/**
	 * Method 'setNombreComercialDenunciado'.
	 *
	 * @param nombreComercialDenunciado
	 *            String
	 * @return
	 */

	public void setNombreComercialDenunciado(String nombreComercialDenunciado) {
		this.nombreComercialDenunciado = nombreComercialDenunciado;
	}

	public DatosDirecciones getDireccionDenunciado() {
		return direccionDenunciado;
	}

	public void setDireccionDenunciado(DatosDirecciones direccionDenunciado) {
		this.direccionDenunciado = direccionDenunciado;
	}

	/**
	 * Method 'getIdDireccionDenunciado'.
	 *
	 * @return Integer
	 */

	public Integer getIdDireccionDenunciado() {
		return this.idDireccionDenunciado;
	}

	/**
	 * Method 'setIdDireccionDenunciado'.
	 *
	 * @param idDireccionDenunciado
	 *            Integer
	 * @return
	 */

	public void setIdDireccionDenunciado(Integer idDireccionDenunciado) {
		this.idDireccionDenunciado = idDireccionDenunciado;
	}

	/**
	 * Method 'getAsuntoHechosDenuncia'.
	 *
	 * @return String
	 */

	public String getAsuntoHechosDenuncia() {
		return this.asuntoHechosDenuncia;
	}

	/**
	 * Method 'setAsuntoHechosDenuncia'.
	 *
	 * @param asuntoHechosDenuncia
	 *            String
	 * @return
	 */

	public void setAsuntoHechosDenuncia(String asuntoHechosDenuncia) {
		this.asuntoHechosDenuncia = asuntoHechosDenuncia;
	}

	/**
	 * Method 'getDescHechosDenuncia'.
	 *
	 * @return String
	 */

	public String getDescHechosDenuncia() {
		return this.descHechosDenuncia;
	}

	/**
	 * Method 'setDescHechosDenuncia'.
	 *
	 * @param descHechosDenuncia
	 *            String
	 * @return
	 */

	public void setDescHechosDenuncia(String descHechosDenuncia) {
		this.descHechosDenuncia = descHechosDenuncia;
	}

	/**
	 * Method 'getIdExpediente'.
	 *
	 * @return Integer
	 */

	public Integer getIdExpediente() {
		return this.idExpediente;
	}

	/**
	 * Method 'setIdExpediente'.
	 *
	 * @param idExpediente
	 *            Integer
	 * @return
	 */

	public void setIdExpediente(Integer idExpediente) {
		this.idExpediente = idExpediente;
	}

	public String getFolderId() {
		return folderId;
	}

	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * Method 'getFolderNumber'.
	 *
	 * @return String
	 */

	public String getFolderNumber() {
		return this.folderNumber;
	}

	/**
	 * Method 'setFolderNumber'.
	 *
	 * @param folderNumber
	 *            String
	 * @return
	 */

	public void setFolderNumber(String folderNumber) {
		this.folderNumber = folderNumber;
	}

	/**
	 * Method 'getAccionTomada'.
	 *
	 * @return String
	 */

	public Decision getDecisionTomada() {
		return this.decisionTomada;
	}

	/**
	 * Method 'setAccionTomada'.
	 *
	 * @param decisionTomada
	 *            String
	 * @return
	 */

	public void setDecisionTomada(Decision accionTomada) {
		this.decisionTomada = accionTomada;
	}

	public String getAccionTomadaOtros() {
		return accionTomadaOtros;
	}

	public void setAccionTomadaOtros(String accionTomadaOtros) {
		this.accionTomadaOtros = accionTomadaOtros;
	}

	/**
	 * Method 'getIdInspeccion'.
	 *
	 * @return Integer
	 */

	public Integer getIdInspeccion() {
		return this.idInspeccion;
	}

	/**
	 * Method 'setIdInspeccion'.
	 *
	 * @param idInspeccion
	 *            Integer
	 * @return
	 */

	public void setIdInspeccion(Integer idInspeccion) {
		this.idInspeccion = idInspeccion;
	}

	/**
	 * Method 'getIdentificadorInspeccion'.
	 *
	 * @return String
	 */

	public String getIdentificadorInspeccion() {
		return this.identificadorInspeccion;
	}

	/**
	 * Method 'setIdentificadorInspeccion'.
	 *
	 * @param identificadorInspeccion
	 *            String
	 * @return
	 */

	public void setIdentificadorInspeccion(String identificadorInspeccion) {
		this.identificadorInspeccion = identificadorInspeccion;
	}

	/**
	 * Method 'getIdentificadorEstablecimiento'.
	 *
	 * @return String
	 */

	public String getIdentificadorEstablecimiento() {
		return this.identificadorEstablecimiento;
	}

	/**
	 * Method 'setIdentificadorEstablecimiento'.
	 *
	 * @param identificadorEstablecimiento
	 *            String
	 * @return
	 */

	public void setIdentificadorEstablecimiento(String identificadorEstablecimiento) {
		this.identificadorEstablecimiento = identificadorEstablecimiento;
	}

	/**
	 * Method 'getIndEliminado'.
	 *
	 * @return String
	 */

	public String getIndEliminado() {
		return this.indEliminado;
	}

	/**
	 * Method 'setIndEliminado'.
	 *
	 * @param indEliminado
	 *            String
	 * @return
	 */

	public void setIndEliminado(String indEliminado) {
		this.indEliminado = indEliminado;
	}

	/**
	 * Method 'getFechaRegistro'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	/**
	 * Method 'setFechaRegistro'.
	 *
	 * @param fechaRegistro
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	/**
	 * Method 'getUsuarioRegistro'.
	 *
	 * @return String
	 */

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	/**
	 * Method 'setUsuarioRegistro'.
	 *
	 * @param usuarioRegistro
	 *            String
	 * @return
	 */

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	/**
	 * Method 'getFechaUltmodificacion'.
	 *
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	/**
	 * Method 'setFechaUltmodificacion'.
	 *
	 * @param fechaUltmodificacion
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	/**
	 * Method 'getUsuarioUltmodificacion'.
	 *
	 * @return String
	 */

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	/**
	 * Method 'setUsuarioUltmodificacion'.
	 *
	 * @param usuarioUltmodificacion
	 *            String
	 * @return
	 */

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public InfoEstablecimiento getInfoEstablecimiento() {
		return infoEstablecimiento;
	}

	public void setInfoEstablecimiento(InfoEstablecimiento infoEstablecimiento) {
		this.infoEstablecimiento = infoEstablecimiento;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idDenuncia: ").append(this.idDenuncia).append(" ]");
		result.append(", [ numDenuncia: ").append(this.numDenuncia).append(" ]");
		result.append(", [ idProvinciaTthh: ").append(this.idProvinciaTthh).append(" ]");
		result.append(", [ fechaPresentacion: ").append(this.fechaPresentacion).append(" ]");
		result.append(", [ idTerceroDenunciante: ").append(this.idTerceroDenunciante).append(" ]");
		result.append(", [ nombreComercialDenunciado: ").append(this.nombreComercialDenunciado).append(" ]");
		result.append(", [ idDireccionDenunciado: ").append(this.idDireccionDenunciado).append(" ]");
		result.append(", [ asuntoHechosDenuncia: ").append(this.asuntoHechosDenuncia).append(" ]");
		result.append(", [ descHechosDenuncia: ").append(this.descHechosDenuncia).append(" ]");
		result.append(", [ idExpediente: ").append(this.idExpediente).append(" ]");
		result.append(", [ folderNumber: ").append(this.folderNumber).append(" ]");
		result.append(", [ decisionTomada: ").append(this.decisionTomada).append(" ]");
		result.append(", [ idInspeccion: ").append(this.idInspeccion).append(" ]");
		result.append(", [ identificadorInspeccion: ").append(this.identificadorInspeccion).append(" ]");
		result.append(", [ identificadorEstablecimiento: ").append(this.identificadorEstablecimiento).append(" ]");
		result.append(", [ indEliminado: ").append(this.indEliminado).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public String getTituloExpediente() {
		return tituloExpediente;
	}

	public void setTituloExpediente(String tituloExpediente) {
		this.tituloExpediente = tituloExpediente;
	}

	public Expedientes getExpedientes() {
		return expediente;
	}

	public void setExpedientes(Expedientes expedientes) {
		this.expediente = expedientes;
	}

	public String getParteLetra() {
		return parteLetra;
	}

	public void setParteLetra(String parteLetra) {
		this.parteLetra = parteLetra;
	}

	public String getParteProv() {
		return parteProv;
	}

	public void setParteProv(String parteProv) {
		this.parteProv = parteProv;
	}

	public String getParteSequencia() {
		return parteSequencia;
	}

	public void setParteSequencia(String parteSequencia) {
		this.parteSequencia = parteSequencia;
	}

	public List<IrregularidadDenuncia> getIrregularidadDenuncias() {
		return irregularidadDenuncias;
	}

	public void setIrregularidadDenuncias(List<IrregularidadDenuncia> irregularidadDenuncias) {
		this.irregularidadDenuncias = irregularidadDenuncias;
	}

	public List<String> getCheckIrregularidad() {
		return checkIrregularidad;
	}

	public void setCheckIrregularidad(List<String> checkIrregularidad) {
		this.checkIrregularidad = checkIrregularidad;
	}

}
