package com.ejie.ab78.model.denuncias;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.maestros.Decision;
import com.ejie.ab78.model.maestros.Producto;
import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * Denuncia  
 * 
 *  
 */

public class Denuncia implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Integer idReclamacion;
	private TipoReclamacion tipoReclamacion;
	private Decision decision;
	private Producto producto;
	private TipoVenta tipoVenta;
	private Expedientes expediente;
	private Integer idDireccion;
	private Long numAnyo;
	private Integer numReclamacion;
	private String idProvinciaTthh;
	private Integer indConoceEstablecimiento;
	private String observacionesNoCensado;
	private Date fechaPresentacion;

	private Integer tipoInfraccion;
	private String numPaginaRec;
	private String descMotivosEs;
	private String descMotivosEu;
	private String asuntoHechos;
	private Date fechaHechos;
	private String idExpRel;

	private String descHechosEs;
	private String descHechosEu;
	private Integer indTipoReclamacion;
	private String tipoComercio;
	private String idTipoEstablecimiento;
//	private Integer idEstablecimiento;
//	private String identificadorEstablecimiento;
//	private String nombreComercial;
//	private String razonSocial;
//	private String documento;
	private String telefonoDenunciado;
	private Integer indIlegal;
	private Integer devolucion;
	private BigDecimal importeDevolucion;
	private Integer indemnizacion;
	private BigDecimal importeIndemnizacion;
	private String descPretensionesEs;
	private String descPretensionesEu;
	private Date fechaRegEntrada;
	private String numRegEntrada;
	private Date fechaRegSalida;
	private String numRegSalida;
	private String organismos;
	private Date fechaDecision;

	private String fundamentoDenunciaSolicitud;
	private String articuloInfrigidoEs;
	private String articuloInfrigidoEu;
	private String normaInfrigidaEs;
	private String normaInfrigidaEu;
	private String observacionesDecisionEs;
	private String observacionesDecisionEu;
	private String indEliminado;
	private Date fechaRegistro;
	private String usuarioRegistro;
	private Date fechaUltmodificacion;
	private String usuarioUltmodificacion;

	private Integer idInspeccion;
	private String identificadorInspeccion;

	private Integer idDireccionDenunciado;

	private DatosDirecciones direccionDenunciado;

	private String numDenunciaFormateado;

	private String[] subtipoParticipacion;
	private Integer telefonoDenuncianteNf;

	// NO FORMAL
	private List<IrregularidadDenuncia> irregularidadDenuncias = new ArrayList<IrregularidadDenuncia>();
	private List<String> checkIrregularidad = new ArrayList<String>();

	public Denuncia() {
	}

	public Denuncia(Integer idReclamacion) {
		this.idReclamacion = idReclamacion;
	}

	public Denuncia(Integer idReclamacion, Expedientes expediente, Integer idDireccion, Long numAnyo,
			Integer numReclamacion, String idProvinciaTthh, Integer indConoceEstablecimiento,
			String observacionesNoCensado, Date fechaPresentacion, Integer tipoInfraccion, String numPaginaRec,
			String descMotivosEs, String descMotivosEu, String asuntoHechos, Date fechaHechos, String descHechosEs,
			String descHechosEu, Integer indTipoReclamacion, String tipoComercio, String idTipoEstablecimiento,
			String l, Integer indIlegal, Integer devolucion, BigDecimal importeDevolucion,
			Integer indemnizacion, BigDecimal importeIndemnizacion, String descPretensionesEs,
			String descPretensionesEu, Date fechaRegEntrada, String numRegEntrada, Date fechaRegSalida,
			String numRegSalida, String organismos, Date fechaDecision, String fundamentoDenunciaSolicitud,
			String articuloInfrigidoEs, String articuloInfrigidoEu, String normaInfrigidaEs, String normaInfrigidaEu,
			String observacionesDecisionEs, String observacionesDecisionEu, String indEliminado, Date fechaRegistro,
			String usuarioRegistro, Date fechaUltmodificacion, String usuarioUltmodificacion,
			Integer telefonoDenuncianteNf, TipoReclamacion tipoReclamacion, Decision decision, Producto producto,
			TipoVenta tipoVenta, Integer idInspeccion, String identificadorInspeccion, Integer idDireccionDenunciado,
			DatosDirecciones direccionDenunciado) {

		this.idReclamacion = idReclamacion;
		this.tipoReclamacion = tipoReclamacion;
		this.decision = decision;
		this.producto = producto;
		this.tipoVenta = tipoVenta;
		this.expediente = expediente;
		this.idDireccion = idDireccion;
		this.numAnyo = numAnyo;
		this.numReclamacion = numReclamacion;
		this.idProvinciaTthh = idProvinciaTthh;
		this.indConoceEstablecimiento = indConoceEstablecimiento;
		this.observacionesNoCensado = observacionesNoCensado;
		this.fechaPresentacion = fechaPresentacion;
		this.tipoInfraccion = tipoInfraccion;
		this.numPaginaRec = numPaginaRec;
		this.descMotivosEs = descMotivosEs;
		this.descMotivosEu = descMotivosEu;
		this.asuntoHechos = asuntoHechos;
		this.fechaHechos = fechaHechos;
		this.descHechosEs = descHechosEs;
		this.descHechosEu = descHechosEu;
		this.indTipoReclamacion = indTipoReclamacion;
		this.tipoComercio = tipoComercio;
		this.idTipoEstablecimiento = idTipoEstablecimiento;
		this.telefonoDenunciado = l;
		this.indIlegal = indIlegal;
		this.devolucion = devolucion;
		this.importeDevolucion = importeDevolucion;
		this.indemnizacion = indemnizacion;
		this.importeIndemnizacion = importeIndemnizacion;
		this.descPretensionesEs = descPretensionesEs;
		this.descPretensionesEu = descPretensionesEu;
		this.fechaRegEntrada = fechaRegEntrada;
		this.numRegEntrada = numRegEntrada;
		this.fechaRegSalida = fechaRegSalida;
		this.numRegSalida = numRegSalida;
		this.organismos = organismos;
		this.fechaDecision = fechaDecision;
		this.fundamentoDenunciaSolicitud = fundamentoDenunciaSolicitud;
		this.articuloInfrigidoEs = articuloInfrigidoEs;
		this.articuloInfrigidoEu = articuloInfrigidoEu;
		this.normaInfrigidaEs = normaInfrigidaEs;
		this.normaInfrigidaEu = normaInfrigidaEu;
		this.observacionesDecisionEs = observacionesDecisionEs;
		this.observacionesDecisionEu = observacionesDecisionEu;
		this.indEliminado = indEliminado;
		this.fechaRegistro = fechaRegistro;
		this.usuarioRegistro = usuarioRegistro;
		this.fechaUltmodificacion = fechaUltmodificacion;
		this.usuarioUltmodificacion = usuarioUltmodificacion;
		this.telefonoDenuncianteNf = telefonoDenuncianteNf;
		this.idInspeccion = idInspeccion;
		this.identificadorInspeccion = identificadorInspeccion;
		this.idDireccionDenunciado = idDireccionDenunciado;
		this.direccionDenunciado = direccionDenunciado;
		setNumDenunciaFormateado(numAnyo, numReclamacion);
	}

	public Integer getIdReclamacion() {
		return this.idReclamacion;
	}

	public void setIdReclamacion(Integer idReclamacion) {
		this.idReclamacion = idReclamacion;
	}

	public TipoReclamacion getTipoReclamacion() {
		return this.tipoReclamacion;
	}

	public void setTipoReclamacion(TipoReclamacion tipoReclamacion) {
		this.tipoReclamacion = tipoReclamacion;
	}

	public Decision getDecision() {
		return this.decision;
	}

	public void setDecision(Decision decision) {
		this.decision = decision;
	}

	public Producto getProducto() {
		return this.producto;
	}

	public void setProducto(Producto producto) {
		this.producto = producto;
	}

	public TipoVenta getTipoVenta() {
		return this.tipoVenta;
	}

	public void setTipoVenta(TipoVenta tipoVenta) {
		this.tipoVenta = tipoVenta;
	}

	public Integer getIdDireccion() {
		return this.idDireccion;
	}

	public Expedientes getExpediente() {
		return expediente;
	}

	public void setExpediente(Expedientes expediente) {
		this.expediente = expediente;
	}

	public void setIdDireccion(Integer idDireccion) {
		this.idDireccion = idDireccion;
	}

	public Long getNumAnyo() {
		return this.numAnyo;
	}

	public void setNumAnyo(Long numAnyo) {
		this.numAnyo = numAnyo;
	}

	public Integer getNumReclamacion() {
		return this.numReclamacion;
	}

	public void setNumReclamacion(Integer numReclamacion) {
		this.numReclamacion = numReclamacion;
	}

	public String getIdProvinciaTthh() {
		return this.idProvinciaTthh;
	}

	public void setIdProvinciaTthh(String idProvinciaTthh) {
		this.idProvinciaTthh = idProvinciaTthh;
	}

	public Integer getIndConoceEstablecimiento() {
		return this.indConoceEstablecimiento;
	}

	public void setIndConoceEstablecimiento(Integer indConoceEstablecimiento) {
		this.indConoceEstablecimiento = indConoceEstablecimiento;
	}

	public String getObservacionesNoCensado() {
		return this.observacionesNoCensado;
	}

	public void setObservacionesNoCensado(String observacionesNoCensado) {
		this.observacionesNoCensado = observacionesNoCensado;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaPresentacion() {
		return this.fechaPresentacion;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaPresentacion(Date fechaPresentacion) {
		this.fechaPresentacion = fechaPresentacion;
	}

	public Integer getTipoInfraccion() {
		return this.tipoInfraccion;
	}

	public void setTipoInfraccion(Integer tipoInfraccion) {
		this.tipoInfraccion = tipoInfraccion;
	}

	public String getNumPaginaRec() {
		return this.numPaginaRec;
	}

	public void setNumPaginaRec(String numPaginaRec) {
		this.numPaginaRec = numPaginaRec;
	}

	public String getDescMotivosEs() {
		return this.descMotivosEs;
	}

	public void setDescMotivosEs(String descMotivosEs) {
		this.descMotivosEs = descMotivosEs;
	}

	public String getDescMotivosEu() {
		return this.descMotivosEu;
	}

	public void setDescMotivosEu(String descMotivosEu) {
		this.descMotivosEu = descMotivosEu;
	}

	public String getAsuntoHechos() {
		return this.asuntoHechos;
	}

	public void setAsuntoHechos(String asuntoHechos) {
		this.asuntoHechos = asuntoHechos;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaHechos() {
		return this.fechaHechos;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaHechos(Date fechaHechos) {
		this.fechaHechos = fechaHechos;
	}

	public String getDescHechosEs() {
		return this.descHechosEs;
	}

	public void setDescHechosEs(String descHechosEs) {
		this.descHechosEs = descHechosEs;
	}

	public String getDescHechosEu() {
		return this.descHechosEu;
	}

	public void setDescHechosEu(String descHechosEu) {
		this.descHechosEu = descHechosEu;
	}

	public Integer getIndTipoReclamacion() {
		return this.indTipoReclamacion;
	}

	public void setIndTipoReclamacion(Integer indTipoReclamacion) {
		this.indTipoReclamacion = indTipoReclamacion;
	}

	public String getTipoComercio() {
		return this.tipoComercio;
	}

	public void setTipoComercio(String tipoComercio) {
		this.tipoComercio = tipoComercio;
	}

	public String getIdTipoEstablecimiento() {
		return this.idTipoEstablecimiento;
	}

	public void setIdTipoEstablecimiento(String idTipoEstablecimiento) {
		this.idTipoEstablecimiento = idTipoEstablecimiento;
	}

	public Integer getIndIlegal() {
		return this.indIlegal;
	}

	public void setIndIlegal(Integer indIlegal) {
		this.indIlegal = indIlegal;
	}

	public Integer getDevolucion() {
		return devolucion;
	}

	public void setDevolucion(Integer devolucion) {
		this.devolucion = devolucion;
	}

	public BigDecimal getImporteDevolucion() {
		return this.importeDevolucion;
	}

	public void setImporteDevolucion(BigDecimal importeDevolucion) {
		this.importeDevolucion = importeDevolucion;
	}

	public Integer getIndemnizacion() {
		return indemnizacion;
	}

	public void setIndemnizacion(Integer indemnizacion) {
		this.indemnizacion = indemnizacion;
	}

	public BigDecimal getImporteIndemnizacion() {
		return importeIndemnizacion;
	}

	public void setImporteIndemnizacion(BigDecimal importeIndemnizacion) {
		this.importeIndemnizacion = importeIndemnizacion;
	}

	public String getDescPretensionesEs() {
		return this.descPretensionesEs;
	}

	public void setDescPretensionesEs(String descPretensionesEs) {
		this.descPretensionesEs = descPretensionesEs;
	}

	public String getDescPretensionesEu() {
		return this.descPretensionesEu;
	}

	public void setDescPretensionesEu(String descPretensionesEu) {
		this.descPretensionesEu = descPretensionesEu;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegEntrada() {
		return this.fechaRegEntrada;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegEntrada(Date fechaRegEntrada) {
		this.fechaRegEntrada = fechaRegEntrada;
	}

	public String getNumRegEntrada() {
		return this.numRegEntrada;
	}

	public void setNumRegEntrada(String numRegEntrada) {
		this.numRegEntrada = numRegEntrada;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegSalida() {
		return this.fechaRegSalida;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegSalida(Date fechaRegSalida) {
		this.fechaRegSalida = fechaRegSalida;
	}
	
	public String getNumRegSalida() {
		return this.numRegSalida;
	}

	public void setNumRegSalida(String numRegSalida) {
		this.numRegSalida = numRegSalida;
	}

	public String getOrganismos() {
		return this.organismos;
	}

	public void setOrganismos(String organismos) {
		this.organismos = organismos;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaDecision() {
		return this.fechaDecision;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaDecision(Date fechaDecision) {
		this.fechaDecision = fechaDecision;
	}

	public String getFundamentoDenunciaSolicitud() {
		return this.fundamentoDenunciaSolicitud;
	}

	public void setFundamentoDenunciaSolicitud(String fundamentoDenunciaSolicitud) {
		this.fundamentoDenunciaSolicitud = fundamentoDenunciaSolicitud;
	}

	public String getArticuloInfrigidoEs() {
		return this.articuloInfrigidoEs;
	}

	public void setArticuloInfrigidoEs(String articuloInfrigidoEs) {
		this.articuloInfrigidoEs = articuloInfrigidoEs;
	}

	public String getArticuloInfrigidoEu() {
		return this.articuloInfrigidoEu;
	}


	public void setArticuloInfrigidoEu(String articuloInfrigidoEu) {
		this.articuloInfrigidoEu = articuloInfrigidoEu;
	}

	public String getNormaInfrigidaEs() {
		return this.normaInfrigidaEs;
	}

	public void setNormaInfrigidaEs(String normaInfrigidaEs) {
		this.normaInfrigidaEs = normaInfrigidaEs;
	}

	public String getNormaInfrigidaEu() {
		return this.normaInfrigidaEu;
	}

	public void setNormaInfrigidaEu(String normaInfrigidaEu) {
		this.normaInfrigidaEu = normaInfrigidaEu;
	}

	public String getObservacionesDecisionEs() {
		return this.observacionesDecisionEs;
	}

	public void setObservacionesDecisionEs(String observacionesDecisionEs) {
		this.observacionesDecisionEs = observacionesDecisionEs;
	}

	public String getObservacionesDecisionEu() {
		return this.observacionesDecisionEu;
	}

	public void setObservacionesDecisionEu(String observacionesDecisionEu) {
		this.observacionesDecisionEu = observacionesDecisionEu;
	}

	public String getIndEliminado() {
		return this.indEliminado;
	}

	public void setIndEliminado(String indEliminado) {
		this.indEliminado = indEliminado;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaRegistro() {
		return this.fechaRegistro;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaRegistro(Date fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}

	public String getUsuarioRegistro() {
		return this.usuarioRegistro;
	}

	public void setUsuarioRegistro(String usuarioRegistro) {
		this.usuarioRegistro = usuarioRegistro;
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaUltmodificacion() {
		return this.fechaUltmodificacion;
	}

	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaUltmodificacion(Date fechaUltmodificacion) {
		this.fechaUltmodificacion = fechaUltmodificacion;
	}

	public String getUsuarioUltmodificacion() {
		return this.usuarioUltmodificacion;
	}

	public void setUsuarioUltmodificacion(String usuarioUltmodificacion) {
		this.usuarioUltmodificacion = usuarioUltmodificacion;
	}

	public String getIdentificadorInspeccion() {
		return identificadorInspeccion;
	}

	public void setIdentificadorInspeccion(String identificadorInspeccion) {
		this.identificadorInspeccion = identificadorInspeccion;
	}

	public Integer getIdInspeccion() {
		return idInspeccion;
	}

	public void setIdInspeccion(Integer idInspeccion) {
		this.idInspeccion = idInspeccion;
	}

	public Integer getIdDireccionDenunciado() {
		return idDireccionDenunciado;
	}

	public void setIdDireccionDenunciado(Integer idDireccionDenunciado) {
		this.idDireccionDenunciado = idDireccionDenunciado;
	}

	public DatosDirecciones getDireccionDenunciado() {
		return direccionDenunciado;
	}

	public void setDireccionDenunciado(DatosDirecciones direccionDenunciado) {
		this.direccionDenunciado = direccionDenunciado;
	}

	public String getNumDenunciaFormateado() {
		return numDenunciaFormateado;
	}

	public void setNumDenunciaFormateado(Long numAnyo, Integer numReclamacion) {
		StringBuilder title = new StringBuilder();

		String strNumAnyo = numAnyo != null ? String.valueOf(numAnyo) : "";
		String strNumReclamacion = numReclamacion != null ? String.format("%05d", numReclamacion) : "";

		title.append(strNumAnyo).append("-");
		if (expediente != null && expediente.getIdExpediente() != null && expediente.getIdExpediente() > 0) {
			if (this.idProvinciaTthh != null) {
				title.append(Constantes.getMapaTTHH().get(this.idProvinciaTthh)).append("-");
			}
		}
		title.append(strNumReclamacion);
		this.numDenunciaFormateado = title.toString();
	}

	public String getTelefonoDenunciado() {
		return telefonoDenunciado;
	}

	public void setTelefonoDenunciado(String telefonoDenunciado) {
		this.telefonoDenunciado = telefonoDenunciado;
	}

	public List<IrregularidadDenuncia> getIrregularidadDenuncias() {
		return irregularidadDenuncias;
	}

	public void setIrregularidadDenuncias(List<IrregularidadDenuncia> irregularidadDenuncias) {
		this.irregularidadDenuncias = irregularidadDenuncias;
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idReclamacion: ").append(this.idReclamacion).append(" ]");
		// result.append(", [ idExpediente:
		// ").append(this.expediente.getIdExpediente()).append(" ]");
		result.append(", [ idDireccion: ").append(this.idDireccion).append(" ]");
		result.append(", [ numAnyo: ").append(this.numAnyo).append(" ]");
		result.append(", [ numReclamacion: ").append(this.numReclamacion).append(" ]");
		result.append(", [ idProvinciaTthh: ").append(this.idProvinciaTthh).append(" ]");
		result.append(", [ indConoceEstablecimiento: ").append(this.indConoceEstablecimiento).append(" ]");
		result.append(", [ observacionesNoCensado: ").append(this.observacionesNoCensado).append(" ]");
		result.append(", [ fechaPresentacion: ").append(this.fechaPresentacion).append(" ]");
		result.append(", [ tipoInfraccion: ").append(this.tipoInfraccion).append(" ]");
		result.append(", [ numPaginaRec: ").append(this.numPaginaRec).append(" ]");
		result.append(", [ descMotivosEs: ").append(this.descMotivosEs).append(" ]");
		result.append(", [ descMotivosEu: ").append(this.descMotivosEu).append(" ]");
		result.append(", [ asuntoHechos: ").append(this.asuntoHechos).append(" ]");
		result.append(", [ fechaHechos: ").append(this.fechaHechos).append(" ]");
		result.append(", [ descHechosEs: ").append(this.descHechosEs).append(" ]");
		result.append(", [ descHechosEu: ").append(this.descHechosEu).append(" ]");
		result.append(", [ indTipoReclamacion: ").append(this.indTipoReclamacion).append(" ]");
		result.append(", [ tipoComercio: ").append(this.tipoComercio).append(" ]");
		result.append(", [ idTipoEstablecimiento: ").append(this.idTipoEstablecimiento).append(" ]");
		result.append(", [ indIlegal: ").append(this.indIlegal).append(" ]");
		result.append(", [ importe: ").append(this.importeDevolucion).append(" ]");
		result.append(", [ descPretensionesEs: ").append(this.descPretensionesEs).append(" ]");
		result.append(", [ descPretensionesEu: ").append(this.descPretensionesEu).append(" ]");
		result.append(", [ fechaRegEntrada: ").append(this.fechaRegEntrada).append(" ]");
		result.append(", [ numRegEntrada: ").append(this.numRegEntrada).append(" ]");
		result.append(", [ fechaRegSalida: ").append(this.fechaRegSalida).append(" ]");
		result.append(", [ numRegSalida: ").append(this.numRegSalida).append(" ]");
		result.append(", [ organismos: ").append(this.organismos).append(" ]");
		result.append(", [ fechaDecision: ").append(this.fechaDecision).append(" ]");
		result.append(", [ fundamentoDenunciaSolicitud: ").append(this.fundamentoDenunciaSolicitud).append(" ]");
		result.append(", [ articuloInfrigidoEs: ").append(this.articuloInfrigidoEs).append(" ]");
		result.append(", [ articuloInfrigidoEu: ").append(this.articuloInfrigidoEu).append(" ]");
		result.append(", [ normaInfrigidaEs: ").append(this.normaInfrigidaEs).append(" ]");
		result.append(", [ normaInfrigidaEu: ").append(this.normaInfrigidaEu).append(" ]");
		result.append(", [ observacionesDecisionEs: ").append(this.observacionesDecisionEs).append(" ]");
		result.append(", [ observacionesDecisionEu: ").append(this.observacionesDecisionEu).append(" ]");
		result.append(", [ indEliminado: ").append(this.indEliminado).append(" ]");
		result.append(", [ fechaRegistro: ").append(this.fechaRegistro).append(" ]");
		result.append(", [ usuarioRegistro: ").append(this.usuarioRegistro).append(" ]");
		result.append(", [ fechaUltmodificacion: ").append(this.fechaUltmodificacion).append(" ]");
		result.append(", [ usuarioUltmodificacion: ").append(this.usuarioUltmodificacion).append(" ]");
		result.append("}");
		return result.toString();
	}

	public String[] getSubtipoParticipacion() {
		return subtipoParticipacion;
	}

	public void setSubtipoParticipacion(String[] subtipoParticipacion) {
		this.subtipoParticipacion = subtipoParticipacion;
	}

	public List<String> getCheckIrregularidad() {
		return checkIrregularidad;
	}

	public void setCheckIrregularidad(List<String> checkIrregularidad) {
		this.checkIrregularidad = checkIrregularidad;
	}

	public String getIdExpRel() {
		return idExpRel;
	}

	public void setIdExpRel(String idExpRel) {
		this.idExpRel = idExpRel;
	}

	public Integer getTelefonoDenuncianteNf() {
		return telefonoDenuncianteNf;
	}

	public void setTelefonoDenuncianteNf(Integer telefonoDenuncianteNf) {
		this.telefonoDenuncianteNf = telefonoDenuncianteNf;
	}

}
