package com.ejie.ab78.model;

public class InfoEstablecimiento implements java.io.Serializable {

	private static final long serialVersionUID = -2636312705663075425L;

	private Long idEstablecimiento;

	private String identificadorEstablecimiento;

	private String nombreEstablecimiento;

	private Integer idTitular;

	private String nombre;

	private String apellido1;

	private String apellido2;

	private String documento;

	public InfoEstablecimiento() {

	}

	public InfoEstablecimiento(Long idEstablecimiento) {
		this.idEstablecimiento = idEstablecimiento;
	}

	public InfoEstablecimiento(Long idEstablecimiento, String identificadorEstablecimiento,
			String nombreEstablecimiento, Integer idTitular, String nombre, String apellido1, String apellido2,
			String documento) {
		this.idEstablecimiento = idEstablecimiento;
		this.identificadorEstablecimiento = identificadorEstablecimiento;
		this.nombreEstablecimiento = nombreEstablecimiento;
		this.idTitular = idTitular;
		this.nombre = nombre;
		this.apellido1 = apellido1;
		this.apellido2 = apellido2;
		this.documento = documento;
	}

	public String getTitular() {
		StringBuffer titular = new StringBuffer();
		if (documento != null && !"".equals(documento)) {
			titular.append(documento).append(" - ");
		}
		if (nombre != null && !"".equals(nombre)) {
			titular.append(nombre).append(" ");
		}
		if (apellido1 != null && !"".equals(apellido1)) {
			titular.append(apellido1).append(" ");
		}
		if (apellido2 != null && !"".equals(apellido2)) {
			titular.append(apellido2);
		}
		return titular.toString();
	}

	public Long getIdEstablecimiento() {
		return idEstablecimiento;
	}

	public void setIdEstablecimiento(Long idEstablecimiento) {
		this.idEstablecimiento = idEstablecimiento;
	}

	public String getIdentificadorEstablecimiento() {
		return identificadorEstablecimiento;
	}

	public void setIdentificadorEstablecimiento(String identificadorEstablecimiento) {
		this.identificadorEstablecimiento = identificadorEstablecimiento;
	}

	public String getNombreEstablecimiento() {
		return nombreEstablecimiento;
	}

	public void setNombreEstablecimiento(String nombreEstablecimiento) {
		this.nombreEstablecimiento = nombreEstablecimiento;
	}

	@Override
	public String toString() {
		return "InfoEstablecimiento [idEstablecimiento=" + idEstablecimiento + ", identificadorEstablecimiento="
				+ identificadorEstablecimiento + ", nombreEstablecimiento=" + nombreEstablecimiento + "]";
	}

	public Integer getIdTitular() {
		return idTitular;
	}

	public void setIdTitular(Integer idTitular) {
		this.idTitular = idTitular;
	}

	public String getNombre() {
		return nombre;
	}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	public String getApellido1() {
		return apellido1;
	}

	public void setApellido1(String apellido1) {
		this.apellido1 = apellido1;
	}

	public String getApellido2() {
		return apellido2;
	}

	public void setApellido2(String apellido2) {
		this.apellido2 = apellido2;
	}

	public String getDocumento() {
		return documento;
	}

	public void setDocumento(String documento) {
		this.documento = documento;
	}

}
