package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDocumentoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TiposDocumentoDaoImpl implements TiposDocumentoDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPODOCUMENTO", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TiposDocumento> rwMap = new RowMapper<TiposDocumento>() {
		public TiposDocumento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TiposDocumento(resultSet.getLong("IDTIPODOCUMENTO"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"));
		}
	};

	private RowMapper<TiposDocumento> rwMapPK = new RowMapper<TiposDocumento>() {
		public TiposDocumento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TiposDocumento(resultSet.getLong("IDTIPODOCUMENTO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<TiposDocumento>> rwMapJerarquia = new RowMapper<JerarquiaDto<TiposDocumento>>() {
		public JerarquiaDto<TiposDocumento> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			TiposDocumento tiposdocumento = new TiposDocumento(resultSet.getLong("IDTIPODOCUMENTO"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"));

			JerarquiaDto<TiposDocumento> jerarquia = new JerarquiaDto<TiposDocumento>();
			jerarquia.setModel(tiposdocumento);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	public TiposDocumento add(TiposDocumento tiposdocumento) {
		String query = "INSERT INTO AB78.TIPOS_DOCUMENTO t1 (ID_TIPO_DOCUMENTO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, tiposdocumento.getIdTipoDocumento(), tiposdocumento.getDescripcionCastellano(),
				tiposdocumento.getDescripcionEuskera(), tiposdocumento.getFechaRegistro(),
				tiposdocumento.getUsuarioRegistro());
		return tiposdocumento;
	}

	/**
	 * Updates a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	public TiposDocumento update(TiposDocumento tiposdocumento) {
		String query = "UPDATE AB78.TIPOS_DOCUMENTO t1 SET DESCRIPCION_CASTELLANO=?, DESCRIPCION_EUSKERA=?, FECHA_REGISTRO=?, USUARIO_REGISTRO=? WHERE ID_TIPO_DOCUMENTO=?";
		this.jdbcTemplate.update(query, tiposdocumento.getDescripcionCastellano(),
				tiposdocumento.getDescripcionEuskera(), tiposdocumento.getFechaRegistro(),
				tiposdocumento.getUsuarioRegistro(), tiposdocumento.getIdTipoDocumento());
		return tiposdocumento;
	}

	/**
	 * Finds a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	@Transactional(readOnly = true)
	public TiposDocumento find(TiposDocumento tiposdocumento) {
		String query = "SELECT t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO FROM AB78.TIPOS_DOCUMENTO t1  WHERE t1.ID_TIPO_DOCUMENTO = ?  ";

		List<TiposDocumento> tiposdocumentoList = this.jdbcTemplate.query(query, this.rwMap,
				tiposdocumento.getIdTipoDocumento());
		return (TiposDocumento) DataAccessUtils.uniqueResult(tiposdocumentoList);
	}

	/**
	 * Finds id_tipo_documento
	 *
	 * @param nombreDocumento
	 *            String
	 * @return IdTipoDocumento Integer
	 */
	public TiposDocumento findIdTipoDocumento(String nombreDocumento) {
		String query = "SELECT t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO FROM AB78.TIPOS_DOCUMENTO t1  WHERE t1.DESCRIPCION_CASTELLANO = ? ";

		List<TiposDocumento> tiposdocumentoList = this.jdbcTemplate.query(query, this.rwMapPK, nombreDocumento);
		return (TiposDocumento) DataAccessUtils.uniqueResult(tiposdocumentoList);

	}

	/**
	 * Removes a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return
	 */
	public void remove(TiposDocumento tiposdocumento) {
		String query = "DELETE FROM TIPOS_DOCUMENTO t1 WHERE ID_TIPO_DOCUMENTO=?";
		this.jdbcTemplate.update(query, tiposdocumento.getIdTipoDocumento());
	}

	/**
	 * Finds a list of rows in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposDocumento>
	 */
	@Transactional(readOnly = true)
	public List<TiposDocumento> findAll(TiposDocumento tiposdocumento, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM AB78.TIPOS_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposdocumento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, TiposDocumentoDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TiposDocumento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TiposDocumento table using like.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposDocumento>
	 */
	@Transactional(readOnly = true)
	public List<TiposDocumento> findAllLike(TiposDocumento tiposdocumento, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM AB78.TIPOS_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposdocumento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, TiposDocumentoDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TiposDocumento>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TiposDocumento tiposdocumento) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.TIPOS_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposdocumento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the TiposDocumento table using like.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TiposDocumento tiposdocumento, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.TIPOS_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposdocumento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of TiposDocumento selected for rup_table
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	@Override
	public List<TableRowDto<TiposDocumento>> reorderSelection(TiposDocumento tiposdocumento,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPOS_DOCUMENTO t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposdocumento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, TableRequestDto, TiposDocumento.class,
				filterParamList, "ID_TIPO_DOCUMENTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TiposDocumento>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            TiposDocumento
	 * @param searchParams
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	@Override
	public List<TableRowDto<TiposDocumento>> search(TiposDocumento filterParams, TiposDocumento searchParams,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPOS_DOCUMENTO t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, TableRequestDto, TiposDocumento.class,
				filterParamList, searchSQL, searchParamList, from_alias, "ID_TIPO_DOCUMENTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TiposDocumento>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filtertiposdocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(TiposDocumento filtertiposdocumento, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM TIPOS_DOCUMENTO t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtertiposdocumento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(TableRequestDto, TiposDocumento.class,
				query, params, "ID_TIPO_DOCUMENTO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TiposDocumento>>
	 */
	@Override
	public List<JerarquiaDto<TiposDocumento>> findAllLikeJerarquia(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPOS_DOCUMENTO t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPOS_DOCUMENTO t1");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposDocumento, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(TableRequestDto, query, mapaWhere, "ID_TIPO_DOCUMENTO", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(TableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (TableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(TableRequestDto, query,
					TiposDocumentoDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPOS_DOCUMENTO t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPOS_DOCUMENTO t1");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposDocumento, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere, "ID_TIPO_DOCUMENTO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	@Override
	public List<TableRowDto<TiposDocumento>> findAllChild(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPOS_DOCUMENTO t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPOS_DOCUMENTO t1");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposDocumento, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere, "ID_TIPO_DOCUMENTO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<TiposDocumento>(this.rwMapPK, "ID_TIPO_DOCUMENTO"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposDocumento entity
	 *
	 * @param tiposdocumento
	 *            TiposDocumento Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TiposDocumento tiposdocumento) {

		StringBuilder where = new StringBuilder(TiposDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposdocumento != null && tiposdocumento.getIdTipoDocumento() != null) {
			where.append(" AND t1.ID_TIPO_DOCUMENTO = ?");
			params.add(tiposdocumento.getIdTipoDocumento());
		}
		if (tiposdocumento != null && tiposdocumento.getDescripcionCastellano() != null) {
			where.append(" AND t1.DESCRIPCION_CASTELLANO = ?");
			params.add(tiposdocumento.getDescripcionCastellano());
		}
		if (tiposdocumento != null && tiposdocumento.getDescripcionEuskera() != null) {
			where.append(" AND t1.DESCRIPCION_EUSKERA = ?");
			params.add(tiposdocumento.getDescripcionEuskera());
		}
		if (tiposdocumento != null && tiposdocumento.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tiposdocumento.getFechaRegistro());
		}
		if (tiposdocumento != null && tiposdocumento.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(tiposdocumento.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposDocumento entity
	 *
	 * @param tiposdocumento
	 *            TiposDocumento Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TiposDocumento tiposdocumento, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TiposDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposdocumento != null && tiposdocumento.getIdTipoDocumento() != null) {
			where.append(" AND t1.ID_TIPO_DOCUMENTO = ?");
			params.add(tiposdocumento.getIdTipoDocumento());
		}
		if (tiposdocumento != null && tiposdocumento.getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposdocumento.getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + tiposdocumento.getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (tiposdocumento != null && tiposdocumento.getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposdocumento.getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + tiposdocumento.getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (tiposdocumento != null && tiposdocumento.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tiposdocumento.getFechaRegistro());
		}
		if (tiposdocumento != null && tiposdocumento.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposdocumento.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tiposdocumento.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
