package com.ejie.ab78.dao.terceros;

import java.util.List;

import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDocumentoDao  
 * 
 *  
 */

public interface TiposDocumentoDao {

	/**
	 * Inserts a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	TiposDocumento add(TiposDocumento tiposdocumento);

	/**
	 * Updates a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	TiposDocumento update(TiposDocumento tiposdocumento);

	/**
	 * Finds a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return TiposDocumento
	 */
	TiposDocumento find(TiposDocumento tiposdocumento);

	/**
	 * Finds id_tipo_documento
	 *
	 * @param nombreDocumento
	 *            String
	 * @return IdTipoDocumento Integer
	 */
	TiposDocumento findIdTipoDocumento(String nombreDocumento);

	/**
	 * Removes a single row in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 */
	void remove(TiposDocumento tiposdocumento);

	/**
	 * Finds a List of rows in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<TiposDocumento> findAll(TiposDocumento tiposdocumento, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the TiposDocumento table using like.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TiposDocumento> findAllLike(TiposDocumento tiposdocumento, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the TiposDocumento table using like.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TiposDocumento tiposdocumento, Boolean startsWith);

	/**
	 * Counts rows in the TiposDocumento table.
	 *
	 * @param tiposdocumento
	 *            TiposDocumento
	 * @return Long
	 */
	Long findAllCount(TiposDocumento tiposdocumento);

	/**
	 * Reorder selection.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	List<TableRowDto<TiposDocumento>> reorderSelection(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param searchTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	List<TableRowDto<TiposDocumento>> search(TiposDocumento filterTiposDocumento, TiposDocumento searchTiposDocumento,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical TiposDocumento table.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TiposDocumento>>
	 */
	List<JerarquiaDto<TiposDocumento>> findAllLikeJerarquia(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(TiposDocumento filterTiposDocumento, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TiposDocumento>>
	 */
	List<TableRowDto<TiposDocumento>> findAllChild(TiposDocumento filterTiposDocumento,
			TableRequestDto TableRequestDto);

}
