package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDireccionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TiposDireccionDaoImpl implements TiposDireccionDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPODIRECCION", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TiposDireccion> rwMap = new RowMapper<TiposDireccion>() {
		public TiposDireccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TiposDireccion(resultSet.getLong("IDTIPODIRECCION"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"));
		}
	};

	private RowMapper<TiposDireccion> rwMapPK = new RowMapper<TiposDireccion>() {
		public TiposDireccion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TiposDireccion(resultSet.getLong("IDTIPODIRECCION"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<TiposDireccion>> rwMapJerarquia = new RowMapper<JerarquiaDto<TiposDireccion>>() {
		public JerarquiaDto<TiposDireccion> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			TiposDireccion tiposdireccion = new TiposDireccion(resultSet.getLong("IDTIPODIRECCION"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"));

			JerarquiaDto<TiposDireccion> jerarquia = new JerarquiaDto<TiposDireccion>();
			jerarquia.setModel(tiposdireccion);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	public TiposDireccion add(TiposDireccion tiposdireccion) {
		String query = "INSERT INTO TIPO_DIRECCION (ID_TIPO_DIRECCION, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, tiposdireccion.getIdTipoDireccion(), tiposdireccion.getDescripcionCastellano(),
				tiposdireccion.getDescripcionEuskera(), tiposdireccion.getFechaRegistro(),
				tiposdireccion.getUsuarioRegistro());
		return tiposdireccion;
	}

	/**
	 * Updates a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	public TiposDireccion update(TiposDireccion tiposdireccion) {
		String query = "UPDATE TIPO_DIRECCION SET DESCRIPCION_CASTELLANO=?, DESCRIPCION_EUSKERA=?, FECHA_REGISTRO=?, USUARIO_REGISTRO=? WHERE ID_TIPO_DIRECCION=?";
		this.jdbcTemplate.update(query, tiposdireccion.getDescripcionCastellano(),
				tiposdireccion.getDescripcionEuskera(), tiposdireccion.getFechaRegistro(),
				tiposdireccion.getUsuarioRegistro(), tiposdireccion.getIdTipoDireccion());
		return tiposdireccion;
	}

	/**
	 * Finds a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	@Transactional(readOnly = true)
	public TiposDireccion find(TiposDireccion tiposdireccion) {
		String query = "SELECT t1.ID_TIPO_DIRECCION IDTIPODIRECCION, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO FROM AB78.TIPO_DIRECCION t1  WHERE t1.ID_TIPO_DIRECCION = ?  ";

		List<TiposDireccion> tiposdireccionList = this.jdbcTemplate.query(query, this.rwMap,
				tiposdireccion.getIdTipoDireccion());
		return (TiposDireccion) DataAccessUtils.uniqueResult(tiposdireccionList);
	}

	/**
	 * Removes a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return
	 */
	public void remove(TiposDireccion tiposdireccion) {
		String query = "DELETE FROM AB78.TIPO_DIRECCION WHERE ID_TIPO_DIRECCION=?";
		this.jdbcTemplate.update(query, tiposdireccion.getIdTipoDireccion());
	}

	/**
	 * Finds a list of rows in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposDireccion>
	 */
	@Transactional(readOnly = true)
	public List<TiposDireccion> findAll(TiposDireccion tiposdireccion, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_DIRECCION IDTIPODIRECCION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM AB78.TIPO_DIRECCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposdireccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, TiposDireccionDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TiposDireccion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TiposDireccion table using like.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposDireccion>
	 */
	@Transactional(readOnly = true)
	public List<TiposDireccion> findAllLike(TiposDireccion tiposdireccion, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_DIRECCION IDTIPODIRECCION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM AB78.TIPO_DIRECCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposdireccion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, TiposDireccionDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TiposDireccion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TiposDireccion tiposdireccion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.TIPO_DIRECCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposdireccion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the TiposDireccion table using like.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TiposDireccion tiposdireccion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.TIPO_DIRECCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposdireccion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of TiposDireccion selected for rup_table
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	@Override
	public List<TableRowDto<TiposDireccion>> reorderSelection(TiposDireccion tiposdireccion,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DIRECCION IDTIPODIRECCION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPO_DIRECCION t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposdireccion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, TableRequestDto, TiposDireccion.class,
				filterParamList, "ID_TIPO_DIRECCION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TiposDireccion>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            TiposDireccion
	 * @param searchParams
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	@Override
	public List<TableRowDto<TiposDireccion>> search(TiposDireccion filterParams, TiposDireccion searchParams,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DIRECCION IDTIPODIRECCION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPO_DIRECCION t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, TableRequestDto, TiposDireccion.class,
				filterParamList, searchSQL, searchParamList, from_alias, "ID_TIPO_DIRECCION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TiposDireccion>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filtertiposdireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(TiposDireccion filtertiposdireccion, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DIRECCION IDTIPODIRECCION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPO_DIRECCION t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtertiposdireccion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(TableRequestDto, TiposDireccion.class,
				query, params, "ID_TIPO_DIRECCION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TiposDireccion>>
	 */
	@Override
	public List<JerarquiaDto<TiposDireccion>> findAllLikeJerarquia(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_DIRECCION IDTIPODIRECCION,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPO_DIRECCION t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPO_DIRECCION");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposDireccion, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(TableRequestDto, query, mapaWhere, "ID_TIPO_DIRECCION", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(TableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (TableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(TableRequestDto, query,
					TiposDireccionDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPO_DIRECCION t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPO_DIRECCION");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposDireccion, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere, "ID_TIPO_DIRECCION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	@Override
	public List<TableRowDto<TiposDireccion>> findAllChild(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPO_DIRECCION t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPO_DIRECCION");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposDireccion, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere, "ID_TIPO_DIRECCION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<TiposDireccion>(this.rwMapPK, "ID_TIPO_DIRECCION"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposDireccion entity
	 *
	 * @param tiposdireccion
	 *            TiposDireccion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TiposDireccion tiposdireccion) {

		StringBuilder where = new StringBuilder(TiposDireccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposdireccion != null && tiposdireccion.getIdTipoDireccion() != null) {
			where.append(" AND t1.ID_TIPO_DIRECCION = ?");
			params.add(tiposdireccion.getIdTipoDireccion());
		}
		if (tiposdireccion != null && tiposdireccion.getDescripcionCastellano() != null) {
			where.append(" AND t1.DESCRIPCION_CASTELLANO = ?");
			params.add(tiposdireccion.getDescripcionCastellano());
		}
		if (tiposdireccion != null && tiposdireccion.getDescripcionEuskera() != null) {
			where.append(" AND t1.DESCRIPCION_EUSKERA = ?");
			params.add(tiposdireccion.getDescripcionEuskera());
		}
		if (tiposdireccion != null && tiposdireccion.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tiposdireccion.getFechaRegistro());
		}
		if (tiposdireccion != null && tiposdireccion.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(tiposdireccion.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposDireccion entity
	 *
	 * @param tiposdireccion
	 *            TiposDireccion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TiposDireccion tiposdireccion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TiposDireccionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposdireccion != null && tiposdireccion.getIdTipoDireccion() != null) {
			where.append(" AND t1.ID_TIPO_DIRECCION = ?");
			params.add(tiposdireccion.getIdTipoDireccion());
		}
		if (tiposdireccion != null && tiposdireccion.getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposdireccion.getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + tiposdireccion.getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (tiposdireccion != null && tiposdireccion.getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposdireccion.getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + tiposdireccion.getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (tiposdireccion != null && tiposdireccion.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tiposdireccion.getFechaRegistro());
		}
		if (tiposdireccion != null && tiposdireccion.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposdireccion.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tiposdireccion.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
