package com.ejie.ab78.dao.terceros;

import java.util.List;

import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDireccionDao  
 * 
 *  
 */

public interface TiposDireccionDao {

	/**
	 * Inserts a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	TiposDireccion add(TiposDireccion tiposdireccion);

	/**
	 * Updates a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	TiposDireccion update(TiposDireccion tiposdireccion);

	/**
	 * Finds a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return TiposDireccion
	 */
	TiposDireccion find(TiposDireccion tiposdireccion);

	/**
	 * Removes a single row in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 */
	void remove(TiposDireccion tiposdireccion);

	/**
	 * Finds a List of rows in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<TiposDireccion> findAll(TiposDireccion tiposdireccion, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the TiposDireccion table using like.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TiposDireccion> findAllLike(TiposDireccion tiposdireccion, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the TiposDireccion table using like.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TiposDireccion tiposdireccion, Boolean startsWith);

	/**
	 * Counts rows in the TiposDireccion table.
	 *
	 * @param tiposdireccion
	 *            TiposDireccion
	 * @return Long
	 */
	Long findAllCount(TiposDireccion tiposdireccion);

	/**
	 * Reorder selection.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	List<TableRowDto<TiposDireccion>> reorderSelection(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param searchTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	List<TableRowDto<TiposDireccion>> search(TiposDireccion filterTiposDireccion, TiposDireccion searchTiposDireccion,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical TiposDireccion table.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TiposDireccion>>
	 */
	List<JerarquiaDto<TiposDireccion>> findAllLikeJerarquia(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(TiposDireccion filterTiposDireccion, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TiposDireccion>>
	 */
	List<TableRowDto<TiposDireccion>> findAllChild(TiposDireccion filterTiposDireccion,
			TableRequestDto TableRequestDto);

}
