package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.terceros.Sexo;

/**
 * SexoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SexoDaoImpl implements SexoDao {
	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDSEXO", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */

	private RowMapper<Sexo> rwMapALL = new RowMapper<Sexo>() {
		public Sexo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Sexo(resultSet.getLong("IDSEXO"), resultSet.getString("DESCRIPCIONCASTELLANO"),
					resultSet.getString("DESCRIPCIONEUSKERA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a list of rows in the Sexo table.
	 *
	 * @param sexoidiomas
	 *            Sexo
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Sexo>
	 */
	@Transactional(readOnly = true)
	public List<Sexo> findAll() {

		String query = "SELECT T1.ID_SEXO IDSEXO, T1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, T1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA FROM AB78.SEXO T1 ";

		return (List<Sexo>) this.jdbcTemplate.query(query, this.rwMapALL);

	}

}
