package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.RelExpTer;
import com.ejie.ab78.model.terceros.Sexo;
import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.ab78.model.terceros.TiposTercero;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * RelExpTerDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelExpTerDaoImpl implements RelExpTerDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDRELEXPTER", "IDEXPEDIENTE", "IDTIPOTERCERO",
			"DESCRIPCIONCASTELLANO", "DESCRIPCIONEUSKERA", "PARTICIPANTID", "ORDEN", "FECHAREGISTRO", "USUARIOREGISTRO",
			"DATOSTERCEROSIDTERCERO", "DATOSTERCEROSDOCUMENTO", "DATOSTERCEROSIDTIPODOCUMENTO", "DATOSTERCEROSNOMBRE",
			"DATOSTERCEROSAPELLIDO1", "DATOSTERCEROSAPELLIDO2", "DATOSTERCEROSIDSEXO", "DATOSTERCEROSTELEFONO",
			"DATOSTERCEROSEMAIL", "DATOSTERCEROSIDIOMA", "DATOSTERCEROSTIPOPARTICIPANTE", "DATOSTERCEROSFECHAREGISTRO",
			"DATOSTERCEROSUSUARIOREGISTRO", "DATOSTERCEROSFECHAULTMOD", "DATOSTERCEROSUSUARIOULTMOD",
			"DATOSTERCEROSIDREPRESENTANTE" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelExpTer> rwMap = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpTer expTer = new RelExpTer(resultSet.getInt("IDRELEXPTER"), resultSet.getInt("IDEXPEDIENTE"),
					resultSet.getString("PARTICIPANTID"), 0, resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"),
					new DatosTerceros(resultSet.getInt("DatosTercerosIDTERCERO"),
							resultSet.getString("DatosTercerosDOCUMENTO"),
							new TiposDocumento(resultSet.getLong("DATOSTERCEROSIDTIPODOCUMENTO"),
									resultSet.getString("DESCRIPCION_CASTELLANO"),
									resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
									resultSet.getString("USUARIO_REGISTRO")),
							resultSet.getString("DatosTercerosNOMBRE"), resultSet.getString("DatosTercerosAPELLIDO1"),
							resultSet.getString("DatosTercerosAPELLIDO2"),
							new Sexo(resultSet.getLong("ID_SEXO"), resultSet.getString("DESCRIPCION_CASTELLANO"),
									resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
									resultSet.getString("USUARIO_REGISTRO")),
							resultSet.getLong("DatosTercerosTELEFONO"), resultSet.getString("DatosTercerosEMAIL"),
							resultSet.getInt("DatosTercerosIDIOMA"), resultSet.getInt("DatosTercerosTIPOPARTICIPANTE")),
					new TiposTercero(resultSet.getLong("IDTIPOTERCERO"), resultSet.getString("DESCRIPCIONCASTELLANO"),
							resultSet.getString("DESCRIPCIONEUSKERA"), null, null, null));
			return expTer;
		}
	};

	private RowMapper<RelExpTer> rwMapAgrupado = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelExpTer expTer = new RelExpTer(resultSet.getInt("IDRELEXPTER"), resultSet.getInt("IDEXPEDIENTE"),
					resultSet.getString("PARTICIPANTID"), null, resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), new DatosTerceros(resultSet.getInt("IDTERCERO")),
					new TiposTercero(resultSet.getLong("IDTIPOTERCERO")));
			expTer.setIdSubtipo(resultSet.getInt("SUBTIPOTERCERO"));
			return expTer;
		}
	};

	private RowMapper<RelExpTer> rwMapIdTercero = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpTer ter = new RelExpTer();
			DatosTerceros datosTercero = new DatosTerceros();
			TiposTercero tiposTercero = new TiposTercero();
			tiposTercero.setIdTipoTercero(resultSet.getLong("IDTIPOTERCERO"));
			tiposTercero.setRole(resultSet.getString("ROLE"));
			datosTercero.setIdTercero(resultSet.getInt("DATOSTERCEROSIDTERCERO"));
			datosTercero.setTipoParticipante(resultSet.getInt("DATOSTERCEROSTIPOPARTICIPANTE"));
			datosTercero.setDocumento(resultSet.getString("DOCUMENTO"));
			ter.setDatosTerceros(datosTercero);
			ter.setTiposTercero(tiposTercero);
			ter.setParticipantId(resultSet.getString("PARTICIPANTID"));
			return ter;
		}
	};

	private RowMapper<DatosTerceros> rwMapTercero = new RowMapper<DatosTerceros>() {
		public DatosTerceros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			DatosTerceros datosTercero = new DatosTerceros();
			TiposTercero tiposTercero = new TiposTercero();
			tiposTercero.setIdTipoTercero(resultSet.getLong("IDTIPOTERCERO"));
			tiposTercero.setRole(resultSet.getString("ROLE"));
			datosTercero.setIdTercero(resultSet.getInt("DATOSTERCEROSIDTERCERO"));
			datosTercero.setTipoParticipante(resultSet.getInt("DATOSTERCEROSTIPOPARTICIPANTE"));
			datosTercero.setDocumento(resultSet.getString("DOCUMENTO"));
			return datosTercero;
		}
	};

	private RowMapper<RelExpTer> rwMapValorParticipacion = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelExpTer ter = new RelExpTer(resultSet.getInt("IDRELEXPTER"));
			DatosTerceros datosTerceros = new DatosTerceros(resultSet.getInt("IDTERCERO"));
			datosTerceros.setDocumento(resultSet.getString("DOCUMENTO"));
			ter.setParticipantId(resultSet.getString("PARTICIPANTID"));
			ter.setDatosTerceros(datosTerceros);
			return ter;
		}
	};

	private RowMapper<RelExpTer> rwMapParticipantId = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelExpTer ter = new RelExpTer();
			DatosTerceros datosTercero = new DatosTerceros();
			datosTercero.setIdTercero(resultSet.getInt("DATOSTERCEROSIDTERCERO"));
			datosTercero.setDocumento(resultSet.getString("DOCUMENTO"));
			datosTercero.setTipoParticipante(resultSet.getInt("TIPOPARTICIPANTE"));
			ter.setDatosTerceros(datosTercero);
			ter.setParticipantId(resultSet.getString("PARTICIPANTID"));
			return ter;
		}
	};

	private RowMapper<RelExpTer> rwMapParticipantes = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelExpTer ter = new RelExpTer();
			DatosTerceros datosTercero = new DatosTerceros();
			TiposTercero tiposTercero = new TiposTercero();
			tiposTercero.setIdTipoTercero(resultSet.getLong("IDTIPOTERCERO"));
			tiposTercero.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			tiposTercero.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));

			datosTercero.setIdTercero(resultSet.getInt("DATOSTERCEROSIDTERCERO"));
			datosTercero.setNombre(resultSet.getString("NOMBRE"));
			datosTercero.setApellido1(resultSet.getString("APELLIDO1"));
			datosTercero.setApellido2(resultSet.getString("APELLIDO2"));
			datosTercero.setEmail(resultSet.getString("EMAIL"));
			datosTercero.setDocumento(resultSet.getString("DOCUMENTO"));
			
			datosTercero.setIdioma(getIntWithNullCheck(resultSet, "IDIOMA"));
			datosTercero.setTipoParticipante(resultSet.getInt("DATOSTERCEROSTIPOPARTICIPANTE"));
			ter.setDatosTerceros(datosTercero);
			ter.setTiposTercero(tiposTercero);
			ter.setParticipantId(resultSet.getString("PARTICIPANTID"));
			ter.setOrden(resultSet.getInt("ORDEN"));
			
			if(datosTercero.getTelefono() != getLongWithNullCheck(resultSet, "TFNO_DENUNCIANTE_NF")){
			
				updateTelefonoTerceros(datosTercero.getIdTercero(), Long.parseLong((getIntWithNullCheck(resultSet, "TFNO_DENUNCIANTE_NF")).toString()));

			}
			
			return ter;
		}

		private Integer getIntWithNullCheck(ResultSet rset, String columnName) {
			try {
				Integer value = rset.getInt(columnName);
				return rset.wasNull() ? null : value;
			} catch (Exception e) {
				return null;
			}
		}
		
		private Long getLongWithNullCheck(ResultSet rset, String columnName) {
			try {
				Long value = rset.getLong(columnName);
				return rset.wasNull() ? null : value;
			} catch (Exception e) {
				return null;
			}
		}
		
	};
	private RowMapper<RelExpTer> rwMapPK = new RowMapper<RelExpTer>() {
		public RelExpTer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new RelExpTer(resultSet.getInt("IDRELEXPTER"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	public RelExpTer add(RelExpTer relexpter) {
		String query = "INSERT INTO AB78.REL_EXP_TER (ID_REL_EXP_TER, ID_TERCERO, ID_EXPEDIENTE, ID_TIPO_TERCERO, PARTICIPANT_ID, FECHA_REGISTRO, USUARIO_REGISTRO, ID_SUBTIPO_TERCERO) VALUES (AB61.S_AB6134T00.NEXTVAL,?,?,?,?,SYSDATE,?,?)";
		Object getDatosTercerosIdTerceroAux = null;
		if (relexpter.getDatosTerceros() != null && relexpter.getDatosTerceros().getIdTercero() != null) {
			getDatosTercerosIdTerceroAux = relexpter.getDatosTerceros().getIdTercero();
		}
		Object getTiposTerceroIdTipoTerceroAux = null;
		if (relexpter.getTiposTercero() != null && relexpter.getTiposTercero().getIdTipoTercero() != null) {
			getTiposTerceroIdTipoTerceroAux = relexpter.getTiposTercero().getIdTipoTercero();
		}
		this.jdbcTemplate.update(query, getDatosTercerosIdTerceroAux, relexpter.getIdExpediente(),
				getTiposTerceroIdTipoTerceroAux, relexpter.getParticipantId(), UtilUsuario.getUserConnected(),
				relexpter.getIdSubtipo());
		return relexpter;
	}

	/**
	 * Updates a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	public RelExpTer update(RelExpTer relexpter) {
		String query = "UPDATE AB78.REL_EXP_TER SET ID_TERCERO=?, ID_EXPEDIENTE=?, ID_TIPO_TERCERO=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_REL_EXP_TER=?";
		Object getDatosTercerosIdTerceroAux = null;
		if (relexpter.getDatosTerceros() != null && relexpter.getDatosTerceros().getIdTercero() != null) {
			getDatosTercerosIdTerceroAux = relexpter.getDatosTerceros().getIdTercero();
		}
		Object getTiposTerceroIdTipoTerceroAux = null;
		if (relexpter.getTiposTercero() != null && relexpter.getTiposTercero().getIdTipoTercero() != null) {
			getTiposTerceroIdTipoTerceroAux = relexpter.getTiposTercero().getIdTipoTercero();
		}
		this.jdbcTemplate.update(query, getDatosTercerosIdTerceroAux, relexpter.getIdExpediente(),
				getTiposTerceroIdTipoTerceroAux, UtilUsuario.getUserConnected(),
				relexpter.getIdRelExpTer());
		return relexpter;
	}

	/**
	 * Update tipo de una relacion
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	public RelExpTer updateByParticipantId(RelExpTer relexpter) {
		String query = "UPDATE AB78.REL_EXP_TER SET ID_TIPO_TERCERO=?, FECHA_ULTMODIFICACION =SYSDATE, USUARIO_ULTMODIFICACION =? WHERE PARTICIPANT_ID =?";

		Object getTiposTerceroIdTipoTerceroAux = null;
		if (relexpter.getTiposTercero() != null && relexpter.getTiposTercero().getIdTipoTercero() != null) {
			getTiposTerceroIdTipoTerceroAux = relexpter.getTiposTercero().getIdTipoTercero();
		}
		this.jdbcTemplate.update(query, getTiposTerceroIdTipoTerceroAux,
				UtilUsuario.getUserConnected(), relexpter.getParticipantId());
		return relexpter;
	}

	/**
	 * Update valor de participacionid
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	public RelExpTer updateByParticipantValue(RelExpTer relexpter) {
		String query = "UPDATE AB78.REL_EXP_TER SET PARTICIPANT_ID =?, FECHA_ULTMODIFICACION =SYSDATE, USUARIO_ULTMODIFICACION =? WHERE ID_TERCERO =?";

		this.jdbcTemplate.update(query, relexpter.getParticipantId(), 
				UtilUsuario.getUserConnected(), relexpter.getDatosTerceros().getIdTercero());
		return relexpter;
	}

	/**
	 * Finds a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Transactional(readOnly = true)
	public RelExpTer find(RelExpTer relexpter) {
		String query = "SELECT t1.ID_REL_EXP_TER IDRELEXPTER, t1.ID_EXPEDIENTE IDEXPEDIENTE, t1.PARTICIPANT_ID PARTICIPANTID, t1.ID_TIPO_TERCERO IDTIPOTERCERO, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t2.ID_TERCERO DATOSTERCEROSIDTERCERO, t2.DOCUMENTO DATOSTERCEROSDOCUMENTO, t3.ID_TIPO_DOCUMENTO DATOSTERCEROSIDTIPODOCUMENTO,t3.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO, t2.NOMBRE DATOSTERCEROSNOMBRE, t2.APELLIDO1 DATOSTERCEROSAPELLIDO1, t2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO, t2.TELEFONO DATOSTERCEROSTELEFONO, t2.EMAIL DATOSTERCEROSEMAIL, t2.IDIOMA DATOSTERCEROSIDIOMA, t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE FROM AB78.REL_EXP_TER t1 , AB78.DATOS_TERCERO t2, AB78.TIPOS_DOCUMENTO t3, AB78.SEXO t4 WHERE t1.ID_REL_EXP_TER = ?   AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t2.ID_TIPO_DOCUMENTO  = t3.ID_TIPO_DOCUMENTO (+) AND t2.ID_SEXO = t4.ID_SEXO(+) ";

		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMap, relexpter.getIdRelExpTer());
		return (RelExpTer) DataAccessUtils.uniqueResult(relexpterList);
	}

	/**
	 * Finds lista de parcicipaciones de la tabla RelExpTer
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findParticipantId(Integer idExpediente) {
		String query = "SELECT t1.PARTICIPANT_ID AS PARTICIPANTID, t1.ID_TERCERO AS DATOSTERCEROSIDTERCERO, t2.DOCUMENTO AS DOCUMENTO, t2.TIPO_PARTICIPANTE AS TIPOPARTICIPANTE FROM AB78.REL_EXP_TER t1, AB78.DATOS_TERCERO t2 WHERE t1.ID_TERCERO = t2.ID_TERCERO AND t1.ID_EXPEDIENTE = ? AND t1.PARTICIPANT_ID IS NOT NULL";
		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMapParticipantId, idExpediente);

		return relexpterList;
	}

	/**
	 * buscar valor de participaciones
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findValorParticipant(Integer idExpediente) {
		String query = "SELECT T1.ID_REL_EXP_TER IDRELEXPTER, T1.PARTICIPANT_ID PARTICIPANTID, t1.id_tercero IDTERCERO,t2.DOCUMENTO DOCUMENTO FROM AB78.REL_EXP_TER T1, AB78.DATOS_TERCERO t2 WHERE t1.id_tercero = T2.ID_TERCERO AND T1.ID_EXPEDIENTE = ?  AND (T1.ID_TIPO_TERCERO = 1 OR T1.ID_TIPO_TERCERO = 3) order by T1.PARTICIPANT_ID ";
		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMapValorParticipacion, idExpediente);

		return relexpterList;
	}

	/**
	 * Finds lista de participantes de la tabla RelExpTer
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findParticipantes(Integer idExpediente) {
		String query = "SELECT  T1.ID_REL_EXP_TER IDRELEXPTER, T1.ID_TIPO_TERCERO AS IDTIPOTERCERO,T3.DESCRIPCION_CASTELLANO AS DESCRIPCIONCASTELLANO, T3.DESCRIPCION_EUSKERA AS DESCRIPCIONEUSKERA, T1.PARTICIPANT_ID AS PARTICIPANTID, T1.ID_TERCERO AS DATOSTERCEROSIDTERCERO, t1.ID_SUBTIPO_TERCERO AS SUBTIPOTERCERO , T2.NOMBRE AS NOMBRE, T2.APELLIDO1 AS APELLIDO1, T2.APELLIDO2 AS APELLIDO2,T2.EMAIL AS EMAIL, T4.TFNO_DENUNCIANTE_NF AS TFNO_DENUNCIANTE_NF, T2.TIPO_PARTICIPANTE AS DATOSTERCEROSTIPOPARTICIPANTE , T2.DOCUMENTO AS DOCUMENTO , T2.IDIOMA AS IDIOMA, DECODE(  T1.ID_TIPO_TERCERO, 1,1 ,2,9,3,2,4,3,5,4,6,8,7,6,8,7,5)AS ORDEN FROM   REL_EXP_TER T1, DATOS_TERCERO T2 , TIPOS_TERCERO T3, AB78.AB7801T00 T4  WHERE  T1.ID_EXPEDIENTE = ? AND T1.ID_TERCERO = T2.ID_TERCERO AND T1.ID_TIPO_TERCERO =  T3.ID_TIPO_TERCERO AND T1.ID_EXPEDIENTE = T4.ID_EXPEDIENTE  ORDER BY ORDEN , PARTICIPANTID , DATOSTERCEROSTIPOPARTICIPANTE  ASC";
		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMapParticipantes, idExpediente);

		return relexpterList;
	}

	/**
	 * Removes a single row in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	public void remove(RelExpTer relexpter) {
		String query = "DELETE FROM AB78.REL_EXP_TER WHERE ID_REL_EXP_TER=?";
		this.jdbcTemplate.update(query, relexpter.getIdRelExpTer());
	}

	/**
	 * Remove a single row in the RelExpTer dado un idTercero
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	public void removeidTercero(Integer idTercero) {
		String query = "DELETE FROM AB78.REL_EXP_TER WHERE ID_TERCERO = ?";
		this.jdbcTemplate.update(query, idTercero);
	}

	/**
	 * Finds a list of rows in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<RelExpTer>
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findAll(RelExpTer relexpter, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_REL_EXP_TER IDRELEXPTER,t1.PARTICIPANT_ID PARTICIPANTID,t1.ID_EXPEDIENTE IDEXPEDIENTE,t1.ID_TIPO_TERCERO IDTIPOTERCERO,T3.DESCRIPCION_CASTELLANO AS DESCRIPCIONCASTELLANO, T3.DESCRIPCION_EUSKERA AS DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t2.ID_TERCERO DATOSTERCEROSIDTERCERO,t2.DOCUMENTO DATOSTERCEROSDOCUMENTO,t2.ID_TIPO_DOCUMENTO DATOSTERCEROSIDTIPODOCUMENTO,t2.NOMBRE DATOSTERCEROSNOMBRE,t2.APELLIDO1 DATOSTERCEROSAPELLIDO1,t2.APELLIDO2 DATOSTERCEROSAPELLIDO2,t2.ID_SEXO DATOSTERCEROSIDSEXO,t2.TELEFONO DATOSTERCEROSTELEFONO,t2.EMAIL DATOSTERCEROSEMAIL,t2.IDIOMA DATOSTERCEROSIDIOMA,t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE,t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO,t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO,t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD,t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD,t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE, DECODE(  T1.ID_TIPO_TERCERO, 1,1 ,2,9,3,2,4,3,5,4,6,8,7,6,8,7,5)AS ORDEN,t3.DESCRIPCION_CASTELLANO,t3.DESCRIPCION_EUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO, t2.NOMBRE DATOSTERCEROSNOMBRE, t2.APELLIDO1 DATOSTERCEROSAPELLIDO1, t2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO, t2.TELEFONO DATOSTERCEROSTELEFONO, t2.EMAIL DATOSTERCEROSEMAIL, t2.IDIOMA DATOSTERCEROSIDIOMA, t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE   ");
		query.append("FROM AB78.REL_EXP_TER t1, AB78.DATOS_TERCERO t2, AB78.TIPOS_TERCERO t3, AB78.SEXO t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relexpter);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_TERCERO = t3.ID_TIPO_TERCERO(+)  AND t2.ID_SEXO = t4.ID_SEXO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, RelExpTerDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelExpTer>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<RelExpTer> findParticipacionesAgrupadas(RelExpTer relexpter) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.ID_REL_EXP_TER IDRELEXPTER, t1.PARTICIPANT_ID PARTICIPANTID, t1.ID_TERCERO IDTERCERO, t1.ID_EXPEDIENTE IDEXPEDIENTE, t1.ID_TIPO_TERCERO IDTIPOTERCERO, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.ID_SUBTIPO_TERCERO SUBTIPOTERCERO ");
		query.append(" FROM AB78.REL_EXP_TER t1 WHERE t1.ID_EXPEDIENTE = ? ");
		return (List<RelExpTer>) this.jdbcTemplate.query(query.toString(), this.rwMapAgrupado,
				relexpter.getIdExpediente());
	}

	/**
	 * Finds rows in the RelExpTer table using like.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelExpTer>
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findAllLike(RelExpTer relexpter, TableRequestDto TableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_REL_EXP_TER IDRELEXPTER,T1.PARTICIPANT_ID PARTICIPANTID,t1.ID_EXPEDIENTE IDEXPEDIENTE,t1.ID_TIPO_TERCERO IDTIPOTERCERO,T3.DESCRIPCION_CASTELLANO AS DESCRIPCIONCASTELLANO, T3.DESCRIPCION_EUSKERA AS DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t2.ID_TERCERO DATOSTERCEROSIDTERCERO,t2.DOCUMENTO DATOSTERCEROSDOCUMENTO,t2.ID_TIPO_DOCUMENTO DATOSTERCEROSIDTIPODOCUMENTO,t2.NOMBRE DATOSTERCEROSNOMBRE,t2.APELLIDO1 DATOSTERCEROSAPELLIDO1,t2.APELLIDO2 DATOSTERCEROSAPELLIDO2,t2.ID_SEXO DATOSTERCEROSIDSEXO,t2.TELEFONO DATOSTERCEROSTELEFONO,t2.EMAIL DATOSTERCEROSEMAIL,t2.IDIOMA DATOSTERCEROSIDIOMA,t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE,t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO,t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO,t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD,t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD,t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE, DECODE(  T1.ID_TIPO_TERCERO, 1,1 ,2,9,3,2,4,3,5,4,6,8,7,6,8,7,5)AS ORDEN,t3.DESCRIPCION_CASTELLANO,t3.DESCRIPCION_EUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO, t2.NOMBRE DATOSTERCEROSNOMBRE, t2.APELLIDO1 DATOSTERCEROSAPELLIDO1, t2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO, t2.TELEFONO DATOSTERCEROSTELEFONO, t2.EMAIL DATOSTERCEROSEMAIL, t2.IDIOMA DATOSTERCEROSIDIOMA, t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE   ");
		query.append(
				"FROM AB78.REL_EXP_TER t1, AB78.DATOS_TERCERO t2 , AB78.TIPOS_TERCERO t3, AB78.SEXO t4  AND t2.ID_SEXO = t4.ID_SEXO(+)  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relexpter, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_TERCERO = t3.ID_TIPO_TERCERO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, RelExpTerDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelExpTer>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Busca los id terceros en la tabla de Rel_Exp_Ter
	 *
	 * @param idExpediente
	 *            Integer
	 * @param partipant_id
	 *            String
	 * @param role
	 *            String
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findIdTerceros(Integer idExpediente) {

		String query = "SELECT  T1.ID_TERCERO   AS DATOSTERCEROSIDTERCERO, T1.PARTICIPANT_ID PARTICIPANTID, T2.TIPO_PARTICIPANTE AS DATOSTERCEROSTIPOPARTICIPANTE,  T2.DOCUMENTO AS DOCUMENTO,  T3.ROLE  AS ROLE , T1.ID_TIPO_TERCERO   AS IDTIPOTERCERO FROM AB78.REL_EXP_TER T1, AB78.DATOS_TERCERO T2, AB78.TIPOS_TERCERO T3 WHERE T1.ID_EXPEDIENTE = ? AND T2.ID_TERCERO = T1.ID_TERCERO AND T1.ID_TIPO_TERCERO = T3.ID_TIPO_TERCERO AND PARTICIPANT_ID IS NOT NULL ";
		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMapIdTercero, idExpediente);
		return relexpterList;

	}

	/**
	 * Busca los id terceros en la tabla de Rel_Exp_Ter
	 *
	 * @param idExpediente
	 *            Integer
	 * @param partipant_id
	 *            String
	 * @param role
	 *            String
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public Integer findFirstTerceroWhitoutEstablecimiento(Integer idExpediente) {
		String query = "SELECT MIN(T1.ID_TERCERO) AS VALOR FROM AB78.REL_EXP_TER T1, AB78.DATOS_DIRECCIONES T2 WHERE T1.ID_TERCERO = T2.ID_TERCERO(+) AND T1.ID_EXPEDIENTE = ? ";
		return this.jdbcTemplate.queryForObject(query, Integer.class, idExpediente);

	}

	/**
	 * Busca los id terceros en la tabla de Rel_Exp_Ter
	 *
	 * @param idExpediente
	 *            Integer
	 * @param partipant_id
	 *            String
	 * @param role
	 *            String
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<RelExpTer> findIdTerceros(Integer idExpediente, String participantId) {

		String query = "SELECT T1.ID_TERCERO AS DATOSTERCEROSIDTERCERO, T1.PARTICIPANT_ID PARTICIPANTID, T2.TIPO_PARTICIPANTE AS DATOSTERCEROSTIPOPARTICIPANTE,  T2.DOCUMENTO AS DOCUMENTO, T3.ROLE AS ROLE , T1.ID_TIPO_TERCERO AS IDTIPOTERCERO FROM AB78.REL_EXP_TER T1,AB78.DATOS_TERCERO T2, AB78.TIPOS_TERCERO T3 WHERE T1.ID_EXPEDIENTE = ? AND T1.PARTICIPANT_ID = ? AND T2.ID_TERCERO = T1.ID_TERCERO AND T1.ID_TIPO_TERCERO = T3.ID_TIPO_TERCERO";

		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMapIdTercero, idExpediente,
				participantId);
		return relexpterList;

	}

	/**
	 * Busca los id terceros en la tabla de Rel_Exp_Ter
	 *
	 * @param idExpediente
	 *            Integer
	 * @param partipant_id
	 *            String
	 * @param role
	 *            String
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DatosTerceros> findTerceros(Integer idExpediente, String participantId) {

		String query = "SELECT T1.ID_TERCERO AS DATOSTERCEROSIDTERCERO, T1.PARTICIPANT_ID PARTICIPANTID, T2.TIPO_PARTICIPANTE AS DATOSTERCEROSTIPOPARTICIPANTE,  T2.DOCUMENTO AS DOCUMENTO, T3.ROLE AS ROLE , T1.ID_TIPO_TERCERO AS IDTIPOTERCERO FROM AB78.REL_EXP_TER T1,AB78.DATOS_TERCERO T2, AB78.TIPOS_TERCERO T3 WHERE  T2.ID_TERCERO = T1.ID_TERCERO AND T1.ID_TIPO_TERCERO = T3.ID_TIPO_TERCERO AND T1.ID_EXPEDIENTE = ? ";
		if (participantId == null) {
			query += "AND T1.PARTICIPANT_ID IS NULL ";
			return (List<DatosTerceros>) this.jdbcTemplate.query(query, this.rwMapTercero, idExpediente);
		} else {
			query += "AND T1.PARTICIPANT_ID = ? ";
			return (List<DatosTerceros>) this.jdbcTemplate.query(query, this.rwMapTercero, idExpediente, participantId);
		}
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelExpTer table.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RelExpTer relexpter) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.REL_EXP_TER t1 , AB78.DATOS_TERCERO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relexpter);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the RelExpTer table using like.
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RelExpTer relexpter, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.REL_EXP_TER t1 ,AB78.DATOS_TERCERO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relexpter, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	private Map<String, ?> getWhereMap(RelExpTer relexpter) {

		StringBuilder where = new StringBuilder(RelExpTerDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relexpter != null && relexpter.getIdRelExpTer() != null) {
			where.append(" AND t1.ID_REL_EXP_TER = ?");
			params.add(relexpter.getIdRelExpTer());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getIdTercero() != null) {
			where.append(" AND t2.ID_TERCERO = ?");
			params.add(relexpter.getDatosTerceros().getIdTercero());
		}

		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getDocumento() != null) {
			where.append(" AND t2.DOCUMENTO = ?");
			params.add(relexpter.getDatosTerceros().getDocumento());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getTiposDocumento().getIdTipoDocumento() != null) {
			where.append(" AND t2.ID_TIPO_DOCUMENTO = ?");
			params.add(relexpter.getDatosTerceros().getTiposDocumento().getIdTipoDocumento());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(relexpter.getDatosTerceros().getNombre());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getApellido1() != null) {
			where.append(" AND t2.APELLIDO1 = ?");
			params.add(relexpter.getDatosTerceros().getApellido1());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getApellido2() != null) {
			where.append(" AND t2.APELLIDO2 = ?");
			params.add(relexpter.getDatosTerceros().getApellido2());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getSexo().getIdSexo() != null) {
			where.append(" AND t2.ID_SEXO = ?");
			params.add(relexpter.getDatosTerceros().getSexo().getIdSexo());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(relexpter.getDatosTerceros().getTelefono());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(relexpter.getDatosTerceros().getEmail());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getIdioma() != null) {
			where.append(" AND t2.IDIOMA = ?");
			params.add(relexpter.getDatosTerceros().getIdioma());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getTipoParticipante() != null) {
			where.append(" AND t2.TIPO_PARTICIPANTE = ?");
			params.add(relexpter.getDatosTerceros().getTipoParticipante());
		}
		if (relexpter != null && relexpter.getIdExpediente() != null) {
			where.append(" AND t1.ID_EXPEDIENTE = ?");
			params.add(relexpter.getIdExpediente());
		}
		if (relexpter != null && relexpter.getTiposTercero() != null) {
			where.append(" AND t1.ID_TIPO_TERCERO = ?");
			params.add(relexpter.getTiposTercero().getIdTipoTercero());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(RelExpTer relexpter, Boolean startsWith) {

		StringBuilder where = new StringBuilder(RelExpTerDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relexpter != null && relexpter.getIdRelExpTer() != null) {
			where.append(" AND t1.ID_REL_EXP_TER = ?");
			params.add(relexpter.getIdRelExpTer());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getIdTercero() != null) {
			where.append(" AND t2.ID_TERCERO = ?");
			params.add(relexpter.getDatosTerceros().getIdTercero());
		}

		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getDocumento() != null) {
			where.append(" AND UPPER(t2.DOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relexpter.getDatosTerceros().getDocumento().toUpperCase() + "%");
			} else {
				params.add("%" + relexpter.getDatosTerceros().getDocumento().toUpperCase() + "%");
			}
			where.append(" AND t2.DOCUMENTO IS NOT NULL");
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getTiposDocumento().getIdTipoDocumento() != null) {
			where.append(" AND t2.ID_TIPO_DOCUMENTO = ?");
			params.add(relexpter.getDatosTerceros().getTiposDocumento().getIdTipoDocumento());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getNombre() != null) {
			where.append(" AND UPPER(t2.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relexpter.getDatosTerceros().getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + relexpter.getDatosTerceros().getNombre().toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE IS NOT NULL");
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getApellido1() != null) {
			where.append(" AND UPPER(t2.APELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relexpter.getDatosTerceros().getApellido1().toUpperCase() + "%");
			} else {
				params.add("%" + relexpter.getDatosTerceros().getApellido1().toUpperCase() + "%");
			}
			where.append(" AND t2.APELLIDO1 IS NOT NULL");
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getApellido2() != null) {
			where.append(" AND UPPER(t2.APELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relexpter.getDatosTerceros().getApellido2().toUpperCase() + "%");
			} else {
				params.add("%" + relexpter.getDatosTerceros().getApellido2().toUpperCase() + "%");
			}
			where.append(" AND t2.APELLIDO2 IS NOT NULL");
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getSexo().getIdSexo() != null) {
			where.append(" AND t2.ID_SEXO = ?");
			params.add(relexpter.getDatosTerceros().getSexo().getIdSexo());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(relexpter.getDatosTerceros().getTelefono());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getEmail() != null) {
			where.append(" AND UPPER(t2.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relexpter.getDatosTerceros().getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + relexpter.getDatosTerceros().getEmail().toUpperCase() + "%");
			}
			where.append(" AND t2.EMAIL IS NOT NULL");
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getIdioma() != null) {
			where.append(" AND t2.IDIOMA = ?");
			params.add(relexpter.getDatosTerceros().getIdioma());
		}
		if (relexpter != null && relexpter.getDatosTerceros() != null
				&& relexpter.getDatosTerceros().getTipoParticipante() != null) {
			where.append(" AND t2.TIPO_PARTICIPANTE = ?");
			params.add(relexpter.getDatosTerceros().getTipoParticipante());
		}
		if (relexpter != null && relexpter.getIdExpediente() != null) {
			where.append(" AND t1.ID_EXPEDIENTE = ?");
			params.add(relexpter.getIdExpediente());
		}
		if (relexpter != null && relexpter.getTiposTercero() != null) {
			where.append(" AND t1.ID_TIPO_TERCERO = ?");
			params.add(relexpter.getTiposTercero().getIdTipoTercero());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public RelExpTer getRelExpTerByExpTercero(Integer idExpediente, Integer idTercero) {
		String query = "SELECT ID_REL_EXP_TER IDRELEXPTER FROM AB78.REL_EXP_TER WHERE ID_EXPEDIENTE = ? AND ID_TERCERO = ?";

		List<RelExpTer> relexpterList = this.jdbcTemplate.query(query, this.rwMapPK, idExpediente, idTercero);
		return (RelExpTer) DataAccessUtils.uniqueResult(relexpterList);
	}

	@Override
	public void updateSubtipo(RelExpTer relexpter) {
		String query = "UPDATE AB78.REL_EXP_TER SET ID_SUBTIPO_TERCERO=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_REL_EXP_TER=?";

		this.jdbcTemplate.update(query, relexpter.getIdSubtipo(), UtilUsuario.getUserConnected(),
				relexpter.getIdRelExpTer());

	}
	
	@Override
	public void updateTelefonoTerceros(Integer idTercero, Long telefono){
		String query = "UPDATE AB78.DATOS_TERCERO SET TELEFONO=? WHERE ID_TERCERO=?";
		this.jdbcTemplate.update(query, telefono,
				idTercero);
	}

}
