package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.RelDenunciaTercero;
import com.ejie.ab78.model.terceros.TiposDocumento;

/**
 * RelDenunciaTerceroDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelDenunciaTerceroDaoImpl implements RelDenunciaTerceroDao {

	private JdbcTemplate jdbcTemplate;

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	private RowMapper<RelDenunciaTercero> rwMap = new RowMapper<RelDenunciaTercero>() {
		public RelDenunciaTercero mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			RelDenunciaTercero relDenunciaTercero = new RelDenunciaTercero();

			relDenunciaTercero.setIdRelRecTer(resultSet.getInt("ID_REL_REC_TER"));
			relDenunciaTercero.setIdReclamacion(resultSet.getInt("ID_RECLAMACION"));

			DatosTerceros datosTerceros = new DatosTerceros();

			datosTerceros.setIdTercero(resultSet.getInt("ID_TERCERO"));
			datosTerceros.setDocumento(resultSet.getString("DOCUMENTO"));

			TiposDocumento tiposDocumento = new TiposDocumento();
			tiposDocumento.setIdTipoDocumento(resultSet.getLong("ID_TIPO_DOCUMENTO"));
			datosTerceros.setTiposDocumento(tiposDocumento);

			datosTerceros.setNombre(resultSet.getString("NOMBRE"));
			datosTerceros.setApellido1(resultSet.getString("APELLIDO1"));
			datosTerceros.setApellido2(resultSet.getString("APELLIDO2"));
			datosTerceros.setTelefono(resultSet.getLong("TELEFONO"));
			datosTerceros.setEmail(resultSet.getString("EMAIL"));
			datosTerceros.setIdioma(resultSet.getInt("IDIOMA"));
			datosTerceros.setTipoParticipante(resultSet.getInt("TIPO_PARTICIPANTE"));
			relDenunciaTercero.setDatosTerceros(datosTerceros);
			relDenunciaTercero.setIdTipoTercero(resultSet.getLong("ID_TIPO_TERCERO"));
			relDenunciaTercero.setBaja(resultSet.getInt("BAJA"));
			relDenunciaTercero.setFechaBaja(resultSet.getDate("FECHA_BAJA"));
			relDenunciaTercero.setParticipantId(resultSet.getString("PARTICIPANTID"));
			if (null != resultSet.getObject("ID_DIRECCION")) {
				DatosDirecciones datosDirecciones = new DatosDirecciones(resultSet.getInt("ID_DIRECCION"));
				relDenunciaTercero.setDatosDirecciones(datosDirecciones);
			}

			return relDenunciaTercero;
		}
	};

	@Override
	public RelDenunciaTercero add(RelDenunciaTercero relDenunciaTercero) {

		String query = "INSERT INTO AB7808S00 (ID_REL_REC_TER, ID_RECLAMACION, ID_TERCERO, ID_TIPO_TERCERO, PARTICIPANT_ID, BAJA, FECHA_BAJA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (AB7808Q00.NEXTVAL,?,?,?,?,?,?,SYSDATE,?)";

		Object getDatosTercerosIdTerceroAux = null;
		if (relDenunciaTercero.getDatosTerceros() != null
				&& relDenunciaTercero.getDatosTerceros().getIdTercero() != null) {
			getDatosTercerosIdTerceroAux = relDenunciaTercero.getDatosTerceros().getIdTercero();
		}
		this.jdbcTemplate.update(query, relDenunciaTercero.getIdReclamacion(), getDatosTercerosIdTerceroAux,
				relDenunciaTercero.getIdTipoTercero(), relDenunciaTercero.getParticipantId(),
				relDenunciaTercero.getBaja(), relDenunciaTercero.getFechaBaja(), UtilUsuario.getUserConnected());
		return relDenunciaTercero;
	}

	@Override
	public RelDenunciaTercero update(RelDenunciaTercero relDenunciaTercero) {

		String query = "UPDATE AB7808S00 SET ID_TIPO_TERCERO = ?, PARTICIPANT_ID = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ?";

		this.jdbcTemplate.update(query, relDenunciaTercero.getIdTipoTercero(), relDenunciaTercero.getParticipantId(),
				UtilUsuario.getUserConnected());
		return relDenunciaTercero;
	}

	@Override
	public RelDenunciaTercero updateById(RelDenunciaTercero relDenunciaTercero) {

		String query = "UPDATE AB7808S00 SET ID_TIPO_TERCERO = ?, PARTICIPANT_ID = ?, FECHA_ULTMODIFICACION = SYSDATE, USUARIO_ULTMODIFICACION = ?  WHERE ID_TERCERO=?";

		this.jdbcTemplate.update(query, relDenunciaTercero.getIdTipoTercero(), relDenunciaTercero.getParticipantId(),
				UtilUsuario.getUserConnected(), relDenunciaTercero.getDatosTerceros().getIdTercero());
		return relDenunciaTercero;
	}

	@Override
	public void remove(RelDenunciaTercero relDenunciaTercero) {
		String query = "DELETE FROM AB7808S00 WHERE ID_REL_REC_TER=?";
		this.jdbcTemplate.update(query, relDenunciaTercero.getIdRelRecTer());
	}

	@Override
	public List<RelDenunciaTercero> getRelDenunciaTerceroByFolderId(Expedientes expediente) {
		String query = "SELECT REL_DEN_TER.ID_REL_REC_TER, REL_DEN_TER.ID_RECLAMACION, REL_DEN_TER.PARTICIPANT_ID PARTICIPANTID, TER.ID_TERCERO, TER.DOCUMENTO, TER.ID_TIPO_DOCUMENTO, TER.NOMBRE, TER.APELLIDO1, TER.APELLIDO2, TER.TELEFONO, TER.EMAIL, TER.IDIOMA, TER.TIPO_PARTICIPANTE, REL_DEN_TER.ID_TIPO_TERCERO, REL_DEN_TER.BAJA, REL_DEN_TER.FECHA_BAJA, DIR.ID_DIRECCION FROM AB7808S00 REL_DEN_TER, AB7801S00 DEN, AB78.EXPEDIENTES EXP, AB78.DATOS_TERCERO TER, (SELECT ID_DIRECCION, ID_TERCERO FROM AB78.DATOS_DIRECCIONES WHERE ID_TIPO_DIRECCION = 4 ) DIR WHERE  REL_DEN_TER.ID_RECLAMACION = DEN.ID_RECLAMACION AND DEN.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND REL_DEN_TER.ID_TERCERO = TER.ID_TERCERO AND TER.ID_TERCERO = DIR.ID_TERCERO(+) AND EXP.FOLDER_ID = ?";

		List<RelDenunciaTercero> lista = this.jdbcTemplate.query(query, this.rwMap, expediente.getFolderId());

		return lista;
	}

	@Override
	public Integer getIdDenunciaByFolderId(Expedientes expediente) {

		String query = "SELECT DEN.ID_RECLAMACION FROM AB7801S00 DEN, AB78.EXPEDIENTES EXP WHERE DEN.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND EXP.FOLDER_ID = ?";
		return this.jdbcTemplate.queryForObject(query, Integer.class, expediente.getFolderId());
	}

	@Override
	public RelDenunciaTercero getRelDenunciaTerceroIdExpediente(Integer idExpediente, Integer idTercero) {
		String query = "SELECT REL_DEN_TER.ID_REL_REC_TER, REL_DEN_TER.ID_RECLAMACION,  REL_DEN_TER.PARTICIPANT_ID PARTICIPANTID, TER.ID_TERCERO, TER.DOCUMENTO, TER.ID_TIPO_DOCUMENTO, TER.NOMBRE, TER.APELLIDO1, TER.APELLIDO2, TER.TELEFONO, TER.EMAIL, TER.IDIOMA, TER.TIPO_PARTICIPANTE, REL_DEN_TER.ID_TIPO_TERCERO, REL_DEN_TER.BAJA, REL_DEN_TER.FECHA_BAJA, DIR.ID_DIRECCION FROM AB7808S00 REL_DEN_TER, AB7801S00 DEN, AB78.EXPEDIENTES EXP, AB78.DATOS_TERCERO TER, AB78.DATOS_DIRECCIONES DIR WHERE  REL_DEN_TER.ID_RECLAMACION = DEN.ID_RECLAMACION AND DEN.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND REL_DEN_TER.ID_TERCERO = TER.ID_TERCERO AND TER.ID_TERCERO = DIR.ID_TERCERO(+) AND EXP.ID_EXPEDIENTE = ? AND TER.ID_TERCERO = ?";
		List<RelDenunciaTercero> relDenunciaTerceros = this.jdbcTemplate.query(query, this.rwMap, idExpediente,
				idTercero);
		return DataAccessUtils.uniqueResult(relDenunciaTerceros);
	}

	@Override
	public RelDenunciaTercero getRelDenunciaIdTercero(Integer idTercero) {
		String query = "SELECT REL_DEN_TER.ID_REL_REC_TER, REL_DEN_TER.ID_RECLAMACION, REL_DEN_TER.PARTICIPANT_ID PARTICIPANTID, TER.ID_TERCERO, TER.DOCUMENTO, TER.ID_TIPO_DOCUMENTO, TER.NOMBRE, TER.APELLIDO1, TER.APELLIDO2, TER.TELEFONO, TER.EMAIL, TER.IDIOMA, TER.TIPO_PARTICIPANTE, REL_DEN_TER.ID_TIPO_TERCERO, REL_DEN_TER.BAJA, REL_DEN_TER.FECHA_BAJA, DIR.ID_DIRECCION FROM AB7808S00 REL_DEN_TER, AB7801S00 DEN, AB78.DATOS_TERCERO TER, AB78.DATOS_DIRECCIONES DIR WHERE REL_DEN_TER.ID_RECLAMACION = DEN.ID_RECLAMACION AND REL_DEN_TER.ID_TERCERO = TER.ID_TERCERO AND TER.ID_TERCERO = DIR.ID_TERCERO (+) AND TER.ID_TERCERO = ? ";
		List<RelDenunciaTercero> relDenunciaTerceros = this.jdbcTemplate.query(query, this.rwMap, idTercero);
		return DataAccessUtils.uniqueResult(relDenunciaTerceros);
	}

	@Override
	public List<RelDenunciaTercero> getRelDenunciaTerceroByIdReclamacion(Denuncia denuncia) {
		String query = "SELECT REL_DEN_TER.ID_REL_REC_TER, REL_DEN_TER.ID_RECLAMACION, REL_DEN_TER.PARTICIPANT_ID PARTICIPANTID, TER.ID_TERCERO, TER.DOCUMENTO, TER.ID_TIPO_DOCUMENTO, TER.NOMBRE, TER.APELLIDO1, TER.APELLIDO2, TER.TELEFONO, TER.EMAIL, TER.IDIOMA, TER.TIPO_PARTICIPANTE, REL_DEN_TER.ID_TIPO_TERCERO, REL_DEN_TER.BAJA, REL_DEN_TER.FECHA_BAJA, DIR.ID_DIRECCION FROM AB7808S00 REL_DEN_TER, AB7801S00 DEN, AB78.EXPEDIENTES EXP, AB78.DATOS_TERCERO TER, AB78.DATOS_DIRECCIONES DIR WHERE REL_DEN_TER.ID_RECLAMACION = DEN.ID_RECLAMACION AND DEN.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE(+) AND REL_DEN_TER.ID_TERCERO = TER.ID_TERCERO AND TER.ID_TERCERO = DIR.ID_TERCERO(+) AND DEN.ID_RECLAMACION = ?";

		List<RelDenunciaTercero> lista = this.jdbcTemplate.query(query, this.rwMap, denuncia.getIdReclamacion());

		return lista;
	}

	@Override
	public Integer getByCif(String documentoTercero) {
		String query = "SELECT COUNT(1) FROM ESTABLECIMIENTOS_REGISTRADOS ESTABLECIMIENTOS ,  REL_EST_TER RELACION ,  DATOS_TERCERO TERCEROS WHERE TERCEROS.ID_TERCERO = RELACION.ID_TERCERO AND RELACION.ID_ESTABLECIMIENTO = ESTABLECIMIENTOS.ID_ESTABLECIMIENTO AND TERCEROS.DOCUMENTO = ?";

		Integer count = this.jdbcTemplate.queryForObject(query, Integer.class, documentoTercero);
		return count;
	}

}
