package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.Sexo;
import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.ab78.util.UtilDao;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DatosTercerosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DatosTercerosDaoImpl implements DatosTercerosDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTERCERO", "DOCUMENTO", "IDTIPODOCUMENTO",
			"NOMBRE", "APELLIDO1", "APELLIDO2", "IDSEXO", "TELEFONO", "EMAIL", "IDIOMA", "TIPOPARTICIPANTE",
			"FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION",
			"DATOSTERCEROSIDTERCERO", "DATOSTERCEROSDOCUMENTO", "DATOSTERCEROSIDTIPODOCUMENTO", "DATOSTERCEROSNOMBRE",
			"DATOSTERCEROSAPELLIDO1", "DATOSTERCEROSAPELLIDO2", "DATOSTERCEROSIDSEXO", "DATOSTERCEROSTELEFONO",
			"DATOSTERCEROSEMAIL", "DATOSTERCEROSIDIOMA", "DATOSTERCEROSTIPOPARTICIPANTE", "DATOSTERCEROSFECHAREGISTRO",
			"DATOSTERCEROSUSUARIOREGISTRO", "DATOSTERCEROSFECHAULTMOD", "DATOSTERCEROSUSUARIOULTMOD",
			"DATOSTERCEROSIDREPRESENTANTE" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosTerceros> rwMap = new RowMapper<DatosTerceros>() {
		public DatosTerceros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosTerceros(resultSet.getInt("IDTERCERO"), resultSet.getString("DOCUMENTO"),
					new TiposDocumento(resultSet.getLong("ID_TIPO_DOCUMENTO"),
							resultSet.getString("DESCRIPCION_CASTELLANO"), resultSet.getString("DESCRIPCION_EUSKERA"),
							resultSet.getDate("FECHA_REGISTRO"), resultSet.getString("USUARIO_REGISTRO")),
					resultSet.getString("NOMBRE"), resultSet.getString("APELLIDO1"), resultSet.getString("APELLIDO2"),
					new Sexo(resultSet.getLong("ID_SEXO"), resultSet.getString("DESCRIPCION_CASTELLANO"),
							resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
							resultSet.getString("USUARIO_REGISTRO")),
					resultSet.getLong("TELEFONO"), resultSet.getString("EMAIL"), resultSet.getInt("IDIOMA"),
					resultSet.getInt("TIPOPARTICIPANTE"));
		}
	};

	private RowMapper<DatosTerceros> rwMapTercerosExpdiente = new RowMapper<DatosTerceros>() {
		public DatosTerceros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosTerceros(resultSet.getInt("IDTERCERO"), resultSet.getString("DOCUMENTO"),
					new TiposDocumento(resultSet.getLong("IDTIPODOCUMENTO")), resultSet.getString("NOMBRE"),
					resultSet.getString("APELLIDO1"), resultSet.getString("APELLIDO2"),
					new Sexo(resultSet.getLong("IDSEXO")), resultSet.getLong("TELEFONO"), resultSet.getString("EMAIL"),
					resultSet.getInt("IDIOMA"), resultSet.getInt("TIPOPARTICIPANTE"));
		}
	};

	private RowMapper<DatosTerceros> rwMapTercerosEstablecimiento = new RowMapper<DatosTerceros>() {
		public DatosTerceros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosTerceros(resultSet.getInt("IDTERCERO"), resultSet.getString("DOCUMENTO"),
					new TiposDocumento(resultSet.getLong("IDTIPODOCUMENTO")), resultSet.getString("NOMBRE"),
					resultSet.getString("APELLIDO1"), resultSet.getString("APELLIDO2"),
					new Sexo(resultSet.getLong("IDSEXO")), resultSet.getLong("TELEFONO"), resultSet.getString("EMAIL"),
					resultSet.getInt("IDIOMA"), resultSet.getInt("TIPOPARTICIPANTE"));
		}
	};

	private RowMapper<DatosTerceros> rwMapPK = new RowMapper<DatosTerceros>() {
		public DatosTerceros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosTerceros(resultSet.getInt("IDTERCERO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<DatosTerceros>> rwMapJerarquia = new RowMapper<JerarquiaDto<DatosTerceros>>() {
		public JerarquiaDto<DatosTerceros> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DatosTerceros datosterceros = new DatosTerceros(resultSet.getInt("IDTERCERO"),
					resultSet.getString("DOCUMENTO"),
					new TiposDocumento(resultSet.getLong("ID_TIPO_DOCUMENTO"),
							resultSet.getString("DESCRIPCION_CASTELLANO"), resultSet.getString("DESCRIPCION_EUSKERA"),
							resultSet.getDate("FECHA_REGISTRO"), resultSet.getString("USUARIO_REGISTRO")),
					resultSet.getString("NOMBRE"), resultSet.getString("APELLIDO1"), resultSet.getString("APELLIDO2"),
					new Sexo(resultSet.getLong("ID_SEXO"), resultSet.getString("DESCRIPCION_CASTELLANO"),
							resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
							resultSet.getString("USUARIO_REGISTRO")),
					resultSet.getLong("TELEFONO"), resultSet.getString("EMAIL"), resultSet.getInt("IDIOMA"),
					resultSet.getInt("TIPOPARTICIPANTE"));

			JerarquiaDto<DatosTerceros> jerarquia = new JerarquiaDto<DatosTerceros>();
			jerarquia.setModel(datosterceros);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the DatosTerceros table.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @return DatosTerceros
	 */
	public DatosTerceros add(DatosTerceros datosterceros) {
		String query = "INSERT INTO AB78.DATOS_TERCERO (ID_TERCERO, ID_REPRESENTANTE, DOCUMENTO, ID_TIPO_DOCUMENTO, NOMBRE, APELLIDO1, APELLIDO2, ID_SEXO, TELEFONO, EMAIL, IDIOMA, TIPO_PARTICIPANTE, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?)";
		Object getDatosTercerosIdTerceroAux = null;

		Object idSexo = null;
		if (datosterceros.getSexo() != null && datosterceros.getSexo().getIdSexo() != null
				&& datosterceros.getSexo().getIdSexo() > 0) {
			idSexo = datosterceros.getSexo().getIdSexo();
		}

		long idTercero = UtilDao.getNextId(jdbcTemplate, "AB61.S_AB6135T00");
		datosterceros.setIdTercero((int) idTercero);

		this.jdbcTemplate.update(query, idTercero, getDatosTercerosIdTerceroAux, datosterceros.getDocumento(),
				datosterceros.getTiposDocumento().getIdTipoDocumento(), datosterceros.getNombre(),
				datosterceros.getApellido1(), datosterceros.getApellido2(), idSexo, datosterceros.getTelefono(),
				datosterceros.getEmail(), datosterceros.getIdioma(), datosterceros.getTipoParticipante(),
				UtilUsuario.getUserConnected());
		return datosterceros;
	}

	public DatosTerceros add(Integer idTercero, DatosTerceros datosterceros) {
		String query = "INSERT INTO AB78.DATOS_TERCERO (ID_TERCERO, ID_REPRESENTANTE, DOCUMENTO, ID_TIPO_DOCUMENTO, NOMBRE, APELLIDO1, APELLIDO2, ID_SEXO, TELEFONO, EMAIL, IDIOMA, TIPO_PARTICIPANTE, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?)";
		Object getDatosTercerosIdTerceroAux = null;

		this.jdbcTemplate.update(query, idTercero, getDatosTercerosIdTerceroAux, datosterceros.getDocumento(),
				datosterceros.getTiposDocumento().getIdTipoDocumento(), datosterceros.getNombre(),
				datosterceros.getApellido1(), datosterceros.getApellido2(), datosterceros.getSexo().getIdSexo(),
				datosterceros.getTelefono(), datosterceros.getEmail(), datosterceros.getIdioma(),
				datosterceros.getTipoParticipante(), UtilUsuario.getUserConnected());
		return datosterceros;
	}

	/**
	 * Finds el siguiente al ultimo id de la tabla in the DatosTerceros table.
	 *
	 * @return datosTercerosiD
	 */
	@Transactional(readOnly = true)
	public DatosTerceros findUltimoId() {
		String query = "SELECT ID_TERCERO AS IDTERCERO FROM AB78.DATOS_TERCERO WHERE ID_TERCERO = (SELECT MAX(ID_TERCERO) FROM DATOS_TERCERO)";
		List<DatosTerceros> datosTercerosiD = this.jdbcTemplate.query(query, this.rwMapPK);
		return (DatosTerceros) DataAccessUtils.uniqueResult(datosTercerosiD);

	}

	/**
	 * Insert los terceros que viene de searchFolder
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @return DatosTerceros
	 */
	public DatosTerceros addTerceroSearchFolder(DatosTerceros datosterceros) {
		String query = "INSERT INTO AB78.DATOS_TERCERO (ID_TERCERO,  DOCUMENTO, ID_TIPO_DOCUMENTO,IDIOMA, NOMBRE, APELLIDO1, APELLIDO2, TIPO_PARTICIPANTE, FECHA_REGISTRO, USUARIO_REGISTRO ) VALUES (AB61.S_AB6135T00.NEXTVAL,?,?,?,?,?,?,?,SYSDATE,?)";

		this.jdbcTemplate.update(query, datosterceros.getDocumento(),
				datosterceros.getTiposDocumento().getIdTipoDocumento(), datosterceros.getIdioma(),
				datosterceros.getNombre(), datosterceros.getApellido1(), datosterceros.getApellido2(),
				datosterceros.getTipoParticipante(), 
				UtilUsuario.getUserConnected());
		return datosterceros;
	}

	/**
	 * Upadte los terceros que viene de searchFolder
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @return DatosTerceros
	 */
	public DatosTerceros updateTerceroSearchfolder(DatosTerceros datosterceros) {
		String query = "UPDATE DATOS_TERCERO SET  DOCUMENTO=?, ID_TIPO_DOCUMENTO=?,  IDIOMA=?,  NOMBRE=?, APELLIDO1=?, APELLIDO2=?,  TIPO_PARTICIPANTE=?,  FECHA_ULTMODIFICACION=SYSDATE,  USUARIO_ULTMODIFICACION=?   WHERE ID_TERCERO=?";

		this.jdbcTemplate.update(query, datosterceros.getDocumento(),
				datosterceros.getTiposDocumento().getIdTipoDocumento(), datosterceros.getIdioma(),
				datosterceros.getNombre(), datosterceros.getApellido1(), datosterceros.getApellido2(),
				datosterceros.getTipoParticipante(), UtilUsuario.getUserConnected(), datosterceros.getIdTercero());
		return datosterceros;
	}

	/**
	 * Updates a single row in the DatosTerceros table.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @return DatosTerceros
	 */
	public DatosTerceros update(DatosTerceros datosterceros) {
		String query = "UPDATE DATOS_TERCERO SET ID_REPRESENTANTE=?, DOCUMENTO=?, ID_TIPO_DOCUMENTO=?, NOMBRE=?, APELLIDO1=?, APELLIDO2=?, ID_SEXO=?, TELEFONO=?, EMAIL=?, IDIOMA=?, TIPO_PARTICIPANTE=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_TERCERO=?";
		Object getDatosTercerosIdTerceroAux = null;

		Object idTipoDoc = null;
		if (datosterceros.getTiposDocumento() != null && datosterceros.getTiposDocumento().getIdTipoDocumento() != null
				&& datosterceros.getTiposDocumento().getIdTipoDocumento() > 0) {
			idTipoDoc = datosterceros.getTiposDocumento().getIdTipoDocumento();
		}
		Object idSexo = null;
		if (datosterceros.getSexo() != null && datosterceros.getSexo().getIdSexo() != null
				&& datosterceros.getSexo().getIdSexo() > 0) {
			idSexo = datosterceros.getSexo().getIdSexo();
		}

		this.jdbcTemplate.update(query, getDatosTercerosIdTerceroAux, datosterceros.getDocumento(), idTipoDoc,
				datosterceros.getNombre(), datosterceros.getApellido1(), datosterceros.getApellido2(), idSexo,
				datosterceros.getTelefono(), datosterceros.getEmail(), datosterceros.getIdioma(),
				datosterceros.getTipoParticipante(), UtilUsuario.getUserConnected(), datosterceros.getIdTercero());
		return datosterceros;
	}

	/**
	 * updatear el IDENTIFICADOR_ESTABLECIMIENTO solo para el caso de EMET
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @return DatosTerceros
	 */
	public DatosTerceros updateIdentificadorEstablecimiento(DatosTerceros datosterceros) {
		String query = "UPDATE DATOS_TERCERO SET IDENTIFICADOR_ESTABLECIMIENTO = ?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_TERCERO=?";
		Object getDatosTercerosIdTerceroAux = null;

		this.jdbcTemplate.update(query, getDatosTercerosIdTerceroAux,
				UtilUsuario.getUserConnected(), datosterceros.getIdTercero());
		return datosterceros;
	}

	/**
	 * Remove a single row in the DATOS_TERCERO dado un idTercero
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return
	 */
	public void remove(Integer idTercero) {
		String query = "DELETE FROM AB78.DATOS_TERCERO WHERE ID_TERCERO=?";
		this.jdbcTemplate.update(query, idTercero);
	}

	/**
	 * Remove todo del tipo participante 2
	 *
	 * 
	 *
	 */
	public void remove() {
		String query = "DELETE FROM AB78.DATOS_TERCERO WHERE TIPO_PARTICIPANTE = "
				+ Constantes.PARTICIPANTE_OTRO_AFECTADO;
		this.jdbcTemplate.update(query);
	}

	/**
	 * Finds a list of rows in the DatosTerceros table.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<DatosTerceros>
	 */
	@Transactional(readOnly = true)
	public List<DatosTerceros> findAll(DatosTerceros datosterceros, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TERCERO IDTERCERO,t1.DOCUMENTO DOCUMENTO,t3.ID_TIPO_DOCUMENTO,t3.DESCRIPCION_CASTELLANO,t3.DESCRIPCION_EUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO,t1.NOMBRE NOMBRE,t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO,t1.TELEFONO TELEFONO,t1.EMAIL EMAIL,t1.IDIOMA IDIOMA,t1.TIPO_PARTICIPANTE TIPOPARTICIPANTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t2.ID_TERCERO DATOSTERCEROSIDTERCERO,t2.DOCUMENTO DATOSTERCEROSDOCUMENTO,t3.ID_TIPO_DOCUMENTO,t3.DESCRIPCION_CASTELLANO,t3.DESCRIPCION_EUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO,t2.NOMBRE DATOSTERCEROSNOMBRE,t2.APELLIDO1 DATOSTERCEROSAPELLIDO1,t2.APELLIDO2 DATOSTERCEROSAPELLIDO2,t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO,t2.TELEFONO DATOSTERCEROSTELEFONO,t2.EMAIL DATOSTERCEROSEMAIL,t2.IDIOMA DATOSTERCEROSIDIOMA,t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE,t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO,t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO,t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD,t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD,t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		query.append("FROM AB78.DATOS_TERCERO t1 ,AB78.DATOS_TERCERO t2, AB78.TIPOS_DOCUMENTO t3, AB78.SEXO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosterceros);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_REPRESENTANTE= t2.ID_TERCERO(+) AND t1.ID_TIPO_DOCUMENTO  = t3.ID_TIPO_DOCUMENTO (+) AND t1.ID_SEXO = t4.ID_SEXO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, DatosTercerosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<DatosTerceros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the DatosTerceros table.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<DatosTerceros>
	 */
	@Transactional(readOnly = true)
	public List<DatosTerceros> findAllByExpdiente(Expedientes expedientes) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_TERCERO IDTERCERO, T1.DOCUMENTO DOCUMENTO, T1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO, T1.NOMBRE NOMBRE, T1.APELLIDO1 APELLIDO1, T1.APELLIDO2 APELLIDO2, T1.ID_SEXO IDSEXO, T1.TELEFONO TELEFONO, T1.EMAIL EMAIL, T1.IDIOMA IDIOMA, T1.TIPO_PARTICIPANTE TIPOPARTICIPANTE, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append(" FROM AB78.DATOS_TERCERO T1, AB78.REL_EXP_TER T2 ");
		query.append(" WHERE 1 = 1 AND T1.ID_TERCERO = T2.ID_TERCERO AND T2.ID_EXPEDIENTE = ? ");

		return (List<DatosTerceros>) this.jdbcTemplate.query(query.toString(), this.rwMapTercerosExpdiente,
				expedientes.getIdExpediente());
	}

	@Transactional(readOnly = true)
	public DatosTerceros findById(Integer idTercero) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_TERCERO IDTERCERO, T1.DOCUMENTO DOCUMENTO, T1.ID_TIPO_DOCUMENTO IDTIPODOCUMENTO, T1.NOMBRE NOMBRE, T1.APELLIDO1 APELLIDO1, T1.APELLIDO2 APELLIDO2, T1.ID_SEXO IDSEXO, T1.TELEFONO TELEFONO, T1.EMAIL EMAIL, T1.IDIOMA IDIOMA, T1.TIPO_PARTICIPANTE TIPOPARTICIPANTE, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append(" FROM AB78.DATOS_TERCERO T1 ");
		query.append(" WHERE 1 = 1 AND T1.ID_TERCERO = ? ");
		List<DatosTerceros> listDatosTerceros = this.jdbcTemplate.query(query.toString(),
				this.rwMapTercerosEstablecimiento, idTercero);
		if (!listDatosTerceros.isEmpty()) {
			return listDatosTerceros.get(0);
		}

		return new DatosTerceros();
	}

	/**
	 * Finds rows in the DatosTerceros table using like.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<DatosTerceros>
	 */
	@Transactional(readOnly = true)
	public List<DatosTerceros> findAllLike(DatosTerceros datosterceros, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TERCERO IDTERCERO,t1.DOCUMENTO DOCUMENTO,t3.ID_TIPO_DOCUMENTO,t3.DESCRIPCION_CASTELLANO,t3.DESCRIPCION_EUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO,t1.NOMBRE NOMBRE,t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO,t1.TELEFONO TELEFONO,t1.EMAIL EMAIL,t1.IDIOMA IDIOMA,t1.TIPO_PARTICIPANTE TIPOPARTICIPANTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t2.ID_TERCERO DATOSTERCEROSIDTERCERO,t2.DOCUMENTO DATOSTERCEROSDOCUMENTO,t3.ID_TIPO_DOCUMENTO,t3.DESCRIPCION_CASTELLANO,t3.DESCRIPCION_EUSKERA,t3.FECHA_REGISTRO,t3.USUARIO_REGISTRO,t2.NOMBRE DATOSTERCEROSNOMBRE,t2.APELLIDO1 DATOSTERCEROSAPELLIDO1,t2.APELLIDO2 DATOSTERCEROSAPELLIDO2,t4.ID_SEXO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO,t2.TELEFONO DATOSTERCEROSTELEFONO,t2.EMAIL DATOSTERCEROSEMAIL,t2.IDIOMA DATOSTERCEROSIDIOMA,t2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE,t2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO,t2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO,t2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD,t2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD,t2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		query.append("FROM AB78.DATOS_TERCERO t1 ,AB78.DATOS_TERCERO t2, AB78.TIPOS_DOCUMENTO t3, AB78.SEXO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosterceros, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_REPRESENTANTE= t2.ID_TERCERO(+) AND t1.ID_TIPO_DOCUMENTO  = t3.ID_TIPO_DOCUMENTO (+) AND t1.ID_SEXO = t4.ID_SEXO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, DatosTercerosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<DatosTerceros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the DatosTerceros table.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosTerceros datosterceros) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM DATOS_TERCERO t1 , DATOS_TERCERO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosterceros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ID_REPRESENTANTE= t2.ID_TERCERO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the DatosTerceros table using like.
	 *
	 * @param datosterceros
	 *            DatosTerceros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DatosTerceros datosterceros, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.DATOS_TERCERO t1 ,AB78.DATOS_TERCERO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosterceros, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ID_REPRESENTANTE= t2.ID_TERCERO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	private Map<String, ?> getWhereMap(DatosTerceros datosterceros) {

		StringBuilder where = new StringBuilder(DatosTercerosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosterceros != null && datosterceros.getIdTercero() != null) {
			where.append(" AND t1.ID_TERCERO = ?");
			params.add(datosterceros.getIdTercero());
		}

		if (datosterceros != null && datosterceros.getDocumento() != null) {
			where.append(" AND t1.DOCUMENTO = ?");
			params.add(datosterceros.getDocumento());
		}
		if (datosterceros != null && datosterceros.getTiposDocumento().getIdTipoDocumento() != null) {
			where.append(" AND t1.ID_TIPO_DOCUMENTO = ?");
			params.add(datosterceros.getTiposDocumento().getIdTipoDocumento());
		}
		if (datosterceros != null && datosterceros.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(datosterceros.getNombre());
		}
		if (datosterceros != null && datosterceros.getApellido1() != null) {
			where.append(" AND t1.APELLIDO1 = ?");
			params.add(datosterceros.getApellido1());
		}
		if (datosterceros != null && datosterceros.getApellido2() != null) {
			where.append(" AND t1.APELLIDO2 = ?");
			params.add(datosterceros.getApellido2());
		}
		if (datosterceros != null && datosterceros.getSexo().getIdSexo() != null) {
			where.append(" AND t1.ID_SEXO = ?");
			params.add(datosterceros.getSexo().getIdSexo());
		}
		if (datosterceros != null && datosterceros.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(datosterceros.getTelefono());
		}
		if (datosterceros != null && datosterceros.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(datosterceros.getEmail());
		}
		if (datosterceros != null && datosterceros.getIdioma() != null) {
			where.append(" AND t1.IDIOMA = ?");
			params.add(datosterceros.getIdioma());
		}
		if (datosterceros != null && datosterceros.getTipoParticipante() != null) {
			where.append(" AND t1.TIPO_PARTICIPANTE = ?");
			params.add(datosterceros.getTipoParticipante());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(DatosTerceros datosterceros, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DatosTercerosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosterceros != null && datosterceros.getIdTercero() != null) {
			where.append(" AND t1.ID_TERCERO = ?");
			params.add(datosterceros.getIdTercero());
		}

		if (datosterceros != null && datosterceros.getDocumento() != null) {
			where.append(" AND UPPER(t1.DOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosterceros.getDocumento().toUpperCase() + "%");
			} else {
				params.add("%" + datosterceros.getDocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.DOCUMENTO IS NOT NULL");
		}
		if (datosterceros != null && datosterceros.getTiposDocumento().getIdTipoDocumento() != null) {
			where.append(" AND t1.ID_TIPO_DOCUMENTO = ?");
			params.add(datosterceros.getTiposDocumento().getIdTipoDocumento());
		}
		if (datosterceros != null && datosterceros.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosterceros.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + datosterceros.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (datosterceros != null && datosterceros.getApellido1() != null) {
			where.append(" AND UPPER(t1.APELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosterceros.getApellido1().toUpperCase() + "%");
			} else {
				params.add("%" + datosterceros.getApellido1().toUpperCase() + "%");
			}
			where.append(" AND t1.APELLIDO1 IS NOT NULL");
		}
		if (datosterceros != null && datosterceros.getApellido2() != null) {
			where.append(" AND UPPER(t1.APELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosterceros.getApellido2().toUpperCase() + "%");
			} else {
				params.add("%" + datosterceros.getApellido2().toUpperCase() + "%");
			}
			where.append(" AND t1.APELLIDO2 IS NOT NULL");
		}
		if (datosterceros != null && datosterceros.getSexo().getIdSexo() != null) {
			where.append(" AND t1.ID_SEXO = ?");
			params.add(datosterceros.getSexo().getIdSexo());
		}
		if (datosterceros != null && datosterceros.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(datosterceros.getTelefono());
		}
		if (datosterceros != null && datosterceros.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosterceros.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + datosterceros.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (datosterceros != null && datosterceros.getIdioma() != null) {
			where.append(" AND t1.IDIOMA = ?");
			params.add(datosterceros.getIdioma());
		}
		if (datosterceros != null && datosterceros.getTipoParticipante() != null) {
			where.append(" AND t1.TIPO_PARTICIPANTE = ?");
			params.add(datosterceros.getTipoParticipante());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
